/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.text.edits.TextEditGroup;

public final class ConvertIterableLoopOperation
extends ConvertLoopOperation {
    private static final StatusInfo SEMANTIC_CHANGE_WARNING_STATUS = new StatusInfo(2, FixMessages.ConvertIterableLoopOperation_semanticChangeWarning);
    private boolean fAssigned = false;
    private IBinding fElement = null;
    private Expression fExpression = null;
    private IBinding fIterable = null;
    private boolean fThis = false;
    private IVariableBinding fIterator = null;
    private final List<Expression> fOccurrences = new ArrayList<Expression>(2);
    private EnhancedForStatement fEnhancedForLoop;
    private boolean fMakeFinal;

    private static ITypeBinding getSuperType(ITypeBinding binding, String name) {
        ITypeBinding result;
        if (binding.isArray() || binding.isPrimitive()) {
            return null;
        }
        if (binding.getQualifiedName().startsWith(name)) {
            return binding;
        }
        ITypeBinding type = binding.getSuperclass();
        if (type != null && (result = ConvertIterableLoopOperation.getSuperType(type, name)) != null) {
            return result;
        }
        ITypeBinding[] types = binding.getInterfaces();
        int index = 0;
        while (index < types.length) {
            ITypeBinding result2 = ConvertIterableLoopOperation.getSuperType(types[index], name);
            if (result2 != null) {
                return result2;
            }
            ++index;
        }
        return null;
    }

    public ConvertIterableLoopOperation(ForStatement statement) {
        this(statement, new String[0], false);
    }

    public ConvertIterableLoopOperation(ForStatement statement, String[] usedNames, boolean makeFinal) {
        super(statement, usedNames);
        this.fMakeFinal = makeFinal;
    }

    public String getIntroducedVariableName() {
        if (this.fElement != null) {
            return this.fElement.getName();
        }
        return this.getVariableNameProposals()[0];
    }

    private String[] getVariableNameProposals() {
        String[] variableNames = this.getUsedVariableNames();
        String[] elementSuggestions = StubUtility.getLocalNameSuggestions(this.getJavaProject(), "element", 0, variableNames);
        ITypeBinding binding = this.fIterator.getType();
        if (binding != null && binding.isParameterizedType()) {
            String type = binding.getTypeArguments()[0].getName();
            String[] typeSuggestions = StubUtility.getLocalNameSuggestions(this.getJavaProject(), type, 0, variableNames);
            String[] result = new String[elementSuggestions.length + typeSuggestions.length];
            System.arraycopy(typeSuggestions, 0, result, 0, typeSuggestions.length);
            System.arraycopy(elementSuggestions, 0, result, typeSuggestions.length, elementSuggestions.length);
            return result;
        }
        return elementSuggestions;
    }

    private IJavaProject getJavaProject() {
        return this.getRoot().getJavaElement().getJavaProject();
    }

    private CompilationUnit getRoot() {
        return (CompilationUnit)this.getForStatement().getRoot();
    }

    private Expression getExpression(ASTRewrite rewrite) {
        if (this.fThis) {
            return rewrite.getAST().newThisExpression();
        }
        if (this.fExpression instanceof MethodInvocation) {
            return (MethodInvocation)rewrite.createMoveTarget(this.fExpression);
        }
        return (Expression)ASTNode.copySubtree(rewrite.getAST(), this.fExpression);
    }

    private ITypeBinding getIterableType(ITypeBinding iterator) {
        ITypeBinding[] bindings;
        if (iterator != null && (bindings = iterator.getTypeArguments()).length > 0) {
            ITypeBinding arg = bindings[0];
            if (arg.isWildcardType()) {
                arg = ASTResolving.normalizeWildcardType(arg, true, this.getRoot().getAST());
            }
            return arg;
        }
        return this.getRoot().getAST().resolveWellKnownType("java.lang.Object");
    }

    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel positionGroups) throws CoreException {
        TextEditGroup group = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, cuRewrite);
        ASTRewrite astRewrite = cuRewrite.getASTRewrite();
        TightSourceRangeComputer rangeComputer = astRewrite.getExtendedSourceRangeComputer() instanceof TightSourceRangeComputer ? (TightSourceRangeComputer)astRewrite.getExtendedSourceRangeComputer() : new TightSourceRangeComputer();
        rangeComputer.addTightSourceNode(this.getForStatement());
        astRewrite.setTargetSourceRangeComputer(rangeComputer);
        Statement statement = this.convert(cuRewrite, group, positionGroups);
        astRewrite.replace(this.getForStatement(), statement, group);
    }

    protected Statement convert(CompilationUnitRewrite cuRewrite, final TextEditGroup group, LinkedProposalModel positionGroups) throws CoreException {
        final AST ast = cuRewrite.getAST();
        final ASTRewrite astRewrite = cuRewrite.getASTRewrite();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        final ImportRemover remover = cuRewrite.getImportRemover();
        this.fEnhancedForLoop = ast.newEnhancedForStatement();
        String[] names = this.getVariableNameProposals();
        String name = this.fElement != null ? this.fElement.getName() : names[0];
        final LinkedProposalPositionGroup pg = positionGroups.getPositionGroup(name, true);
        if (this.fElement != null) {
            pg.addProposal(name, null, 10);
        }
        int i = 0;
        while (i < names.length) {
            pg.addProposal(names[i], null, 10);
            ++i;
        }
        Statement body = this.getForStatement().getBody();
        if (body != null) {
            ListRewrite list;
            if (body instanceof Block) {
                list = astRewrite.getListRewrite(body, Block.STATEMENTS_PROPERTY);
                Iterator<Expression> iterator = this.fOccurrences.iterator();
                while (iterator.hasNext()) {
                    Statement parent = (Statement)ASTNodes.getParent((ASTNode)iterator.next(), Statement.class);
                    if (parent == null || !list.getRewrittenList().contains(parent)) continue;
                    list.remove(parent, null);
                    remover.registerRemovedNode(parent);
                }
            } else {
                list = null;
            }
            final String text = name;
            body.accept(new ASTVisitor(){

                private boolean replace(Expression expression) {
                    SimpleName node = ast.newSimpleName(text);
                    astRewrite.replace(expression, node, group);
                    remover.registerRemovedNode(expression);
                    pg.addPosition(astRewrite.track(node), false);
                    return false;
                }

                public final boolean visit(MethodInvocation node) {
                    IBinding result;
                    Expression expression;
                    IMethodBinding binding = node.resolveMethodBinding();
                    if (binding != null && (binding.getName().equals("next") || binding.getName().equals("nextElement")) && ((expression = node.getExpression()) instanceof Name ? (result = ((Name)expression).resolveBinding()) != null && result.equals(ConvertIterableLoopOperation.this.fIterator) : expression instanceof FieldAccess && (result = ((FieldAccess)expression).resolveFieldBinding()) != null && result.equals(ConvertIterableLoopOperation.this.fIterator))) {
                        return this.replace(node);
                    }
                    return super.visit(node);
                }

                public final boolean visit(SimpleName node) {
                    Statement parent;
                    IBinding binding;
                    if (ConvertIterableLoopOperation.this.fElement != null && (binding = node.resolveBinding()) != null && binding.equals(ConvertIterableLoopOperation.this.fElement) && (parent = (Statement)ASTNodes.getParent((ASTNode)node, Statement.class)) != null && (list == null || list.getRewrittenList().contains(parent))) {
                        pg.addPosition(astRewrite.track(node), false);
                    }
                    return false;
                }
            });
            this.fEnhancedForLoop.setBody(this.getBody(cuRewrite, group, positionGroups));
        }
        SingleVariableDeclaration declaration = ast.newSingleVariableDeclaration();
        SimpleName simple = ast.newSimpleName(name);
        pg.addPosition(astRewrite.track(simple), true);
        declaration.setName(simple);
        ITypeBinding iterable = this.getIterableType(this.fIterator.getType());
        declaration.setType(this.importType(iterable, this.getForStatement(), importRewrite, this.getRoot()));
        if (this.fMakeFinal) {
            ModifierRewrite.create(astRewrite, declaration).setModifiers(16, 0, group);
        }
        remover.registerAddedImport(iterable.getQualifiedName());
        this.fEnhancedForLoop.setParameter(declaration);
        this.fEnhancedForLoop.setExpression(this.getExpression(astRewrite));
        for (ASTNode node : this.getForStatement().initializers()) {
            if (node instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)node;
                remover.registerRemovedNode(variableDeclarationExpression.getType());
                continue;
            }
            remover.registerRemovedNode(node);
        }
        for (ASTNode node : this.getForStatement().updaters()) {
            remover.registerRemovedNode(node);
        }
        return this.fEnhancedForLoop;
    }

    public final IStatus satisfiesPreconditions() {
        IStatus resultStatus = StatusInfo.OK_STATUS;
        if (JavaModelUtil.is50OrHigher(this.getJavaProject())) {
            ASTNode root;
            resultStatus = this.checkExpressionCondition();
            if (resultStatus.getSeverity() == 4) {
                return resultStatus;
            }
            List updateExpressions = (List)this.getForStatement().getStructuralProperty(ForStatement.UPDATERS_PROPERTY);
            if (updateExpressions.size() == 1) {
                resultStatus = new StatusInfo(2, Messages.format(FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpression_Warning, BasicElementLabels.getJavaCodeString(((Expression)updateExpressions.get(0)).toString())));
            } else if (updateExpressions.size() > 1) {
                resultStatus = new StatusInfo(2, FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpressions_Warning);
            }
            for (Expression initializer : this.getForStatement().initializers()) {
                if (!(initializer instanceof VariableDeclarationExpression)) continue;
                VariableDeclarationExpression declaration = (VariableDeclarationExpression)initializer;
                List fragments = declaration.fragments();
                if (fragments.size() != 1) {
                    return new StatusInfo(4, "");
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
                fragment.accept(new ASTVisitor(){

                    public final boolean visit(MethodInvocation node) {
                        String qualified;
                        ITypeBinding type;
                        IMethodBinding binding = node.resolveMethodBinding();
                        if (binding != null && (type = binding.getReturnType()) != null && ((qualified = type.getQualifiedName()).startsWith("java.util.Enumeration<") || qualified.startsWith("java.util.Iterator<"))) {
                            Expression qualifier = node.getExpression();
                            if (qualifier != null) {
                                ITypeBinding iterable;
                                ITypeBinding resolved = qualifier.resolveTypeBinding();
                                if (resolved != null && (iterable = ConvertIterableLoopOperation.getSuperType(resolved, "java.lang.Iterable")) != null) {
                                    ConvertIterableLoopOperation.this.fExpression = qualifier;
                                    if (qualifier instanceof Name) {
                                        Name name = (Name)qualifier;
                                        ConvertIterableLoopOperation.this.fIterable = name.resolveBinding();
                                    } else if (qualifier instanceof MethodInvocation) {
                                        MethodInvocation invocation = (MethodInvocation)qualifier;
                                        ConvertIterableLoopOperation.this.fIterable = invocation.resolveMethodBinding();
                                    } else if (qualifier instanceof FieldAccess) {
                                        FieldAccess access = (FieldAccess)qualifier;
                                        ConvertIterableLoopOperation.this.fIterable = access.resolveFieldBinding();
                                    } else if (qualifier instanceof ThisExpression) {
                                        ConvertIterableLoopOperation.this.fIterable = resolved;
                                    }
                                }
                            } else {
                                ITypeBinding superBinding;
                                ITypeBinding declaring = binding.getDeclaringClass();
                                if (declaring != null && (superBinding = ConvertIterableLoopOperation.getSuperType(declaring, "java.lang.Iterable")) != null) {
                                    ConvertIterableLoopOperation.this.fIterable = superBinding;
                                    ConvertIterableLoopOperation.this.fThis = true;
                                }
                            }
                        }
                        return true;
                    }

                    public final boolean visit(VariableDeclarationFragment node) {
                        ITypeBinding type;
                        IVariableBinding binding = node.resolveBinding();
                        if (binding != null && (type = binding.getType()) != null) {
                            ITypeBinding iterator = ConvertIterableLoopOperation.getSuperType(type, "java.util.Iterator");
                            if (iterator != null) {
                                ConvertIterableLoopOperation.this.fIterator = binding;
                            } else {
                                iterator = ConvertIterableLoopOperation.getSuperType(type, "java.util.Enumeration");
                                if (iterator != null) {
                                    ConvertIterableLoopOperation.this.fIterator = binding;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            Statement statement = this.getForStatement().getBody();
            final boolean[] otherInvocationThenNext = new boolean[1];
            final int[] nextInvocationCount = new int[1];
            if (statement != null && this.fIterator != null) {
                final ITypeBinding iterable = this.getIterableType(this.fIterator.getType());
                statement.accept(new ASTVisitor(){

                    public final boolean visit(Assignment node) {
                        return this.visit(node.getLeftHandSide(), node.getRightHandSide());
                    }

                    private boolean visit(Expression node) {
                        ITypeBinding binding;
                        if (node != null && (binding = node.resolveTypeBinding()) != null && iterable.equals(binding)) {
                            FieldAccess access;
                            IVariableBinding result;
                            if (node instanceof Name) {
                                Name name = (Name)node;
                                IBinding result2 = name.resolveBinding();
                                if (result2 != null) {
                                    ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                    ConvertIterableLoopOperation.this.fElement = result2;
                                    return false;
                                }
                            } else if (node instanceof FieldAccess && (result = (access = (FieldAccess)node).resolveFieldBinding()) != null) {
                                ConvertIterableLoopOperation.this.fOccurrences.add(node);
                                ConvertIterableLoopOperation.this.fElement = result;
                                return false;
                            }
                        }
                        return true;
                    }

                    private boolean visit(Expression left, Expression right) {
                        if (ConvertIterableLoopOperation.this.fElement != null && left instanceof SimpleName) {
                            IBinding binding = ((SimpleName)left).resolveBinding();
                            if (ConvertIterableLoopOperation.this.fElement.equals(binding)) {
                                ConvertIterableLoopOperation.this.fMakeFinal = false;
                            }
                        }
                        if (right instanceof MethodInvocation) {
                            MethodInvocation invocation = (MethodInvocation)right;
                            IMethodBinding binding = invocation.resolveMethodBinding();
                            if (binding != null && (binding.getName().equals("next") || binding.getName().equals("nextElement"))) {
                                FieldAccess qualifier;
                                IVariableBinding result;
                                Expression expression = invocation.getExpression();
                                if (expression instanceof Name) {
                                    Name qualifier2 = (Name)expression;
                                    IBinding result2 = qualifier2.resolveBinding();
                                    if (result2 != null && result2.equals(ConvertIterableLoopOperation.this.fIterator)) {
                                        nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                        return this.visit(left);
                                    }
                                } else if (expression instanceof FieldAccess && (result = (qualifier = (FieldAccess)expression).resolveFieldBinding()) != null && result.equals(ConvertIterableLoopOperation.this.fIterator)) {
                                    nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                    return this.visit(left);
                                }
                            } else {
                                return this.visit(invocation);
                            }
                        }
                        return true;
                    }

                    public boolean visit(MethodInvocation invocation) {
                        IMethodBinding binding = invocation.resolveMethodBinding();
                        if (binding != null) {
                            FieldAccess qualifier;
                            IVariableBinding result;
                            Expression expression = invocation.getExpression();
                            if (expression instanceof Name) {
                                Name qualifier2 = (Name)expression;
                                IBinding result2 = qualifier2.resolveBinding();
                                if (result2 != null && result2.equals(ConvertIterableLoopOperation.this.fIterator)) {
                                    if (!binding.getName().equals("next") && !binding.getName().equals("nextElement")) {
                                        otherInvocationThenNext[0] = true;
                                    } else {
                                        nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                    }
                                }
                            } else if (expression instanceof FieldAccess && (result = (qualifier = (FieldAccess)expression).resolveFieldBinding()) != null && result.equals(ConvertIterableLoopOperation.this.fIterator)) {
                                if (!binding.getName().equals("next") && !binding.getName().equals("nextElement")) {
                                    otherInvocationThenNext[0] = true;
                                } else {
                                    nextInvocationCount[0] = nextInvocationCount[0] + 1;
                                }
                            }
                        }
                        return true;
                    }

                    public final boolean visit(VariableDeclarationFragment node) {
                        return this.visit(node.getName(), node.getInitializer());
                    }
                });
                if (otherInvocationThenNext[0]) {
                    return ERROR_STATUS;
                }
                if (nextInvocationCount[0] > 1) {
                    return ERROR_STATUS;
                }
                if (this.fElement != null) {
                    statement.accept(new ASTVisitor(){

                        public final boolean visit(VariableDeclarationFragment node) {
                            SimpleName name;
                            if (node.getInitializer() instanceof NullLiteral && iterable.equals((name = node.getName()).resolveTypeBinding()) && ConvertIterableLoopOperation.this.fElement.equals(name.resolveBinding())) {
                                ConvertIterableLoopOperation.this.fOccurrences.add(name);
                            }
                            return true;
                        }
                    });
                }
            }
            if ((root = this.getForStatement().getRoot()) != null) {
                root.accept(new ASTVisitor(){

                    public final boolean visit(ForStatement node) {
                        return false;
                    }

                    public final boolean visit(SimpleName node) {
                        IBinding binding = node.resolveBinding();
                        if (binding != null && binding.equals(ConvertIterableLoopOperation.this.fElement)) {
                            ConvertIterableLoopOperation.this.fAssigned = true;
                        }
                        return false;
                    }
                });
            }
        }
        if ((this.fExpression != null || this.fThis) && this.fIterable != null && this.fIterator != null && !this.fAssigned) {
            return resultStatus;
        }
        return ERROR_STATUS;
    }

    private IStatus checkExpressionCondition() {
        Expression expression = this.getForStatement().getExpression();
        if (!(expression instanceof MethodInvocation)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        MethodInvocation invoc = (MethodInvocation)expression;
        IMethodBinding methodBinding = invoc.resolveMethodBinding();
        if (methodBinding == null) {
            return ERROR_STATUS;
        }
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        if (declaringClass == null) {
            return ERROR_STATUS;
        }
        String qualifiedName = declaringClass.getQualifiedName();
        String methodName = invoc.getName().getIdentifier();
        if (qualifiedName.startsWith("java.util.Enumeration")) {
            if (!methodName.equals("hasMoreElements")) {
                return SEMANTIC_CHANGE_WARNING_STATUS;
            }
        } else {
            if (qualifiedName.startsWith("java.util.Iterator")) {
                if (!methodName.equals("hasNext")) {
                    return SEMANTIC_CHANGE_WARNING_STATUS;
                }
                return this.checkIteratorCondition();
            }
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        return StatusInfo.OK_STATUS;
    }

    private IStatus checkIteratorCondition() {
        List initializers = this.getForStatement().initializers();
        if (initializers.size() != 1) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        Expression expression = (Expression)initializers.get(0);
        if (!(expression instanceof VariableDeclarationExpression)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        VariableDeclarationExpression declaration = (VariableDeclarationExpression)expression;
        List variableDeclarationFragments = declaration.fragments();
        if (variableDeclarationFragments.size() != 1) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)variableDeclarationFragments.get(0);
        Expression initializer = declarationFragment.getInitializer();
        if (!(initializer instanceof MethodInvocation)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        MethodInvocation methodInvocation = (MethodInvocation)initializer;
        String methodName = methodInvocation.getName().getIdentifier();
        if (!"iterator".equals(methodName)) {
            return SEMANTIC_CHANGE_WARNING_STATUS;
        }
        return StatusInfo.OK_STATUS;
    }
}

