/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class ExpressionsFix
extends CompilationUnitRewriteOperationsFix {
    public static ExpressionsFix createAddParanoidalParenthesisFix(CompilationUnit compilationUnit, ASTNode[] coveredNodes) {
        if (coveredNodes == null) {
            return null;
        }
        if (coveredNodes.length == 0) {
            return null;
        }
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < coveredNodes.length) {
            ASTNode covered = coveredNodes[i];
            if (covered instanceof InfixExpression) {
                covered.accept(new MissingParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty() || changedNodes.size() == 1 && ((ASTNode)changedNodes.get(0)).equals(coveredNodes[0])) {
            return null;
        }
        AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
        return new ExpressionsFix(FixMessages.ExpressionsFix_addParanoiacParentheses_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static ExpressionsFix createRemoveUnnecessaryParenthesisFix(CompilationUnit compilationUnit, ASTNode[] nodes) {
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            ASTNode covered = nodes[i];
            if (covered instanceof ParenthesizedExpression || covered instanceof InfixExpression) {
                covered.accept(new UnnecessaryParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty()) {
            return null;
        }
        HashSet<ParenthesizedExpression> expressions = new HashSet<ParenthesizedExpression>(changedNodes);
        RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
        return new ExpressionsFix(FixMessages.ExpressionsFix_removeUnnecessaryParentheses_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addParanoicParentesis, boolean removeUnnecessaryParenthesis) {
        if (addParanoicParentesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept(new MissingParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
            return new ExpressionsFix(FixMessages.ExpressionsFix_add_parentheses_change_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        if (removeUnnecessaryParenthesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept(new UnnecessaryParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            HashSet<ParenthesizedExpression> expressions = new HashSet<ParenthesizedExpression>(changedNodes);
            RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
            return new ExpressionsFix(FixMessages.ExpressionsFix_remove_parentheses_change_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        return null;
    }

    protected ExpressionsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class AddParenthesisOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final Expression[] fExpressions;

        public AddParenthesisOperation(Expression[] expressions) {
            this.fExpressions = expressions;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_addParanoiacParentheses_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            int i = 0;
            while (i < this.fExpressions.length) {
                Expression expression = this.fExpressions[i];
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)rewrite.createCopyTarget(expression));
                rewrite.replace(expression, parenthesizedExpression, group);
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MissingParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList<ASTNode> fNodes;

        private MissingParenthesisVisitor(ArrayList<ASTNode> nodes) {
            this.fNodes = nodes;
        }

        @Override
        public void postVisit(ASTNode node) {
            if (this.needsParentesis(node)) {
                this.fNodes.add(node);
            }
        }

        private boolean needsParentesis(ASTNode node) {
            if (!(node.getParent() instanceof InfixExpression)) {
                return false;
            }
            if (node instanceof InstanceofExpression) {
                return true;
            }
            if (node instanceof InfixExpression) {
                InfixExpression expression = (InfixExpression)node;
                InfixExpression.Operator operator = expression.getOperator();
                InfixExpression parentExpression = (InfixExpression)node.getParent();
                InfixExpression.Operator parentOperator = parentExpression.getOperator();
                return parentOperator != operator;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveParenthesisOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final HashSet<ParenthesizedExpression> fExpressions;

        public RemoveParenthesisOperation(HashSet<ParenthesizedExpression> expressions) {
            this.fExpressions = expressions;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_removeUnnecessaryParentheses_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            rewrite.setTargetSourceRangeComputer(new NoCommentSourceRangeComputer());
            while (this.fExpressions.size() > 0) {
                ParenthesizedExpression parenthesizedExpression = this.fExpressions.iterator().next();
                this.fExpressions.remove(parenthesizedExpression);
                ParenthesizedExpression down = parenthesizedExpression;
                while (this.fExpressions.contains(down.getExpression())) {
                    down = (ParenthesizedExpression)down.getExpression();
                    this.fExpressions.remove(down);
                }
                ASTNode move = rewrite.createMoveTarget(down.getExpression());
                ParenthesizedExpression top = parenthesizedExpression;
                while (this.fExpressions.contains(top.getParent())) {
                    top = (ParenthesizedExpression)top.getParent();
                    this.fExpressions.remove(top);
                }
                rewrite.replace(top, move, group);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnnecessaryParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList<ParenthesizedExpression> fNodes;

        private UnnecessaryParenthesisVisitor(ArrayList<ParenthesizedExpression> nodes) {
            this.fNodes = nodes;
        }

        @Override
        public boolean visit(ParenthesizedExpression node) {
            if (NecessaryParenthesesChecker.canRemoveParentheses(node)) {
                this.fNodes.add(node);
            }
            return true;
        }
    }
}

