/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;

public final class SerialVersionDefaultOperation
extends AbstractSerialVersionOperation {
    private static final String GROUP_INITIALIZER = "initializer";

    public SerialVersionDefaultOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
    }

    protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull(fragment);
        NumberLiteral expression = fragment.getAST().newNumberLiteral("1L");
        if (expression != null) {
            fragment.setInitializer(expression);
        }
        return true;
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(fragment);
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            LinkedProposalPositionGroup group = new LinkedProposalPositionGroup(GROUP_INITIALIZER);
            group.addPosition(rewrite.track(initializer), true);
            positionGroups.addPositionGroup(group);
        }
    }
}

