/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.util.SearchUtils;

public class CuCollectingSearchRequestor
extends CollectingSearchRequestor {
    private IJavaProject fProjectCache;
    private IScanner fScannerCache;

    public CuCollectingSearchRequestor() {
        this(null);
    }

    public CuCollectingSearchRequestor(ReferencesInBinaryContext binaryRefs) {
        super(binaryRefs);
    }

    protected IScanner getScanner(ICompilationUnit unit) {
        IJavaProject project = unit.getJavaProject();
        if (project.equals(this.fProjectCache)) {
            return this.fScannerCache;
        }
        this.fProjectCache = project;
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        this.fScannerCache = ToolFactory.createScanner(false, false, false, sourceLevel, complianceLevel);
        return this.fScannerCache;
    }

    public final void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (this.filterMatch(match)) {
            return;
        }
        ICompilationUnit unit = SearchUtils.getCompilationUnit(match);
        if (unit != null) {
            this.acceptSearchMatch(unit, match);
        }
    }

    protected void acceptSearchMatch(ICompilationUnit unit, SearchMatch match) throws CoreException {
        this.collectMatch(match);
    }

    public void endReporting() {
        this.fProjectCache = null;
        this.fScannerCache = null;
    }
}

