/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public final class JDTRefactoringDescriptorComment {
    private static final String ELEMENT_DELIMITER = RefactoringCoreMessages.JavaRefactoringDescriptorComment_element_delimiter;
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    private final String fHeader;
    private final String fProject;
    private final List<String> fSettings = new ArrayList<String>(6);

    public static String createCompositeSetting(String caption, String[] settings) {
        Assert.isNotNull(caption);
        Assert.isNotNull(settings);
        StringBuffer buffer = new StringBuffer(128);
        int index = 0;
        while (index < settings.length) {
            if (settings[index] != null && !"".equals(settings[index])) {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(settings[index]);
            } else {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
            }
            ++index;
        }
        if (buffer.length() > 0) {
            buffer.insert(0, caption);
        }
        return buffer.toString();
    }

    public JDTRefactoringDescriptorComment(String project, Object object, String header) {
        Assert.isNotNull(object);
        Assert.isNotNull(header);
        this.fProject = project;
        this.fHeader = header;
        this.initializeInferredSettings(object);
    }

    public void addSetting(int index, String setting) {
        Assert.isTrue(index >= 0);
        Assert.isNotNull(setting);
        Assert.isTrue(!"".equals(setting));
        this.fSettings.add(index, setting);
    }

    public void addSetting(String setting) {
        if (setting != null && !"".equals(setting)) {
            this.fSettings.add(setting);
        }
    }

    public String asString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.fHeader);
        if (this.fProject != null && !"".equals(this.fProject)) {
            buffer.append(LINE_DELIMITER);
            buffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_original_project, BasicElementLabels.getResourceName(this.fProject)));
        }
        for (String setting : this.fSettings) {
            buffer.append(LINE_DELIMITER);
            buffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_inferred_setting_pattern, setting));
        }
        return buffer.toString();
    }

    public int getCount() {
        return this.fSettings.size();
    }

    private void initializeInferredSettings(Object object) {
        Object updating;
        block40: {
            if (object instanceof INameUpdating) {
                updating = (INameUpdating)object;
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(updating.getElements()[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
                try {
                    Object element = updating.getNewElement();
                    if (element != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED)));
                        break block40;
                    }
                    String newLabel = BasicElementLabels.getJavaElementName(updating.getCurrentElementName());
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, newLabel));
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            } else if (object instanceof RefactoringProcessor) {
                RefactoringProcessor processor = (RefactoringProcessor)object;
                Object[] elements = processor.getElements();
                if (elements != null) {
                    if (elements.length == 1 && elements[0] != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(elements[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
                    } else if (elements.length > 1) {
                        StringBuffer buffer = new StringBuffer(128);
                        buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] != null) {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(JavaElementLabels.getTextLabel(elements[index], JavaElementLabels.ALL_FULLY_QUALIFIED));
                            } else {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                            }
                            ++index;
                        }
                        this.fSettings.add(buffer.toString());
                    }
                }
            } else if (object instanceof IReorgPolicy) {
                IReorgPolicy.IMovePolicy extended;
                IReorgPolicy policy = (IReorgPolicy)object;
                IAdaptable destination = policy.getJavaElementDestination();
                if (destination != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)));
                } else {
                    destination = policy.getResourceDestination();
                    if (destination != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED)));
                    }
                }
                ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
                list.addAll(Arrays.asList(policy.getJavaElements()));
                list.addAll(Arrays.asList(policy.getResources()));
                Object[] elements = list.toArray();
                if (elements != null) {
                    if (elements.length == 1 && elements[0] != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabels.getTextLabel(elements[0], JavaElementLabels.ALL_FULLY_QUALIFIED)));
                    } else if (elements.length > 1) {
                        StringBuffer buffer = new StringBuffer(128);
                        buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] != null) {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(JavaElementLabels.getTextLabel(elements[index], JavaElementLabels.ALL_FULLY_QUALIFIED));
                            } else {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                            }
                            ++index;
                        }
                        this.fSettings.add(buffer.toString());
                    }
                }
                if (object instanceof IReorgPolicy.IMovePolicy && (extended = (IReorgPolicy.IMovePolicy)object).isTextualMove()) {
                    this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptorComment_textual_move_only);
                }
            }
        }
        if (object instanceof IReferenceUpdating && (updating = (IReferenceUpdating)object).getUpdateReferences()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        if (object instanceof ISimilarDeclarationUpdating && (updating = (ISimilarDeclarationUpdating)object).canEnableSimilarDeclarationUpdating() && updating.getUpdateSimilarDeclarations()) {
            int strategy = updating.getMatchStrategy();
            if (strategy == 1) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar);
            } else if (strategy == 2) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_embedded);
            } else if (strategy == 3) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_suffix);
            }
        }
        if (object instanceof IQualifiedNameUpdating && (updating = (IQualifiedNameUpdating)object).canEnableQualifiedNameUpdating() && updating.getUpdateQualifiedNames()) {
            String patterns = updating.getFilePatterns();
            if (patterns != null && !"".equals(patterns)) {
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names_pattern, BasicElementLabels.getFilePattern(patterns.trim())));
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names);
            }
        }
        if (object instanceof ITextUpdating && (updating = (ITextUpdating)object).canEnableTextUpdating()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_textual_occurrences);
        }
        if (object instanceof IDelegateUpdating && (updating = (IDelegateUpdating)object).canEnableDelegateUpdating() && updating.getDelegateUpdating()) {
            if (updating.getDeprecateDelegates()) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original_deprecated);
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original);
            }
        }
    }

    public void removeSetting(int index) {
        Assert.isTrue(index >= 0);
        this.fSettings.remove(index);
    }
}

