/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.ReturnTypeInfo;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeContextChecker {
    private static Type parseType(String typeString, IJavaProject javaProject, List<String> problemsCollector) {
        String typeNodeRange;
        if ("".equals(typeString.trim())) {
            return null;
        }
        if (!typeString.trim().equals(typeString)) {
            return null;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append("interface A{");
        int offset = cuBuff.length();
        cuBuff.append(typeString).append(" m();}");
        ASTParser p = ASTParser.newParser(4);
        p.setSource(cuBuff.toString().toCharArray());
        p.setProject(javaProject);
        CompilationUnit cu = (CompilationUnit)p.createAST(null);
        Selection selection = Selection.createFromStartLength(offset, typeString.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept(analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (!(selected instanceof Type)) {
            return null;
        }
        Type type = (Type)selected;
        if (MethodTypesSyntaxChecker.isVoidArrayType(type)) {
            return null;
        }
        IProblem[] problems = ASTNodes.getProblems(type, 0, 3);
        if (problems.length > 0) {
            int i = 0;
            while (i < problems.length) {
                problemsCollector.add(problems[i].getMessage());
                ++i;
            }
        }
        if (typeString.equals(typeNodeRange = cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd(type)))) {
            return type;
        }
        return null;
    }

    private static ITypeBinding handleBug84585(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isGenericType() && !typeBinding.isRawType() && !typeBinding.isParameterizedType()) {
            return null;
        }
        return typeBinding;
    }

    public static RefactoringStatus[] checkAndResolveMethodTypes(IMethod method, StubTypeContext stubTypeContext, List<ParameterInfo> parameterInfos, ReturnTypeInfo returnTypeInfo) throws CoreException {
        MethodTypesChecker checker = new MethodTypesChecker(method, stubTypeContext, parameterInfos, returnTypeInfo);
        return checker.checkAndResolveMethodTypes();
    }

    public static RefactoringStatus[] checkMethodTypesSyntax(IMethod method, List<ParameterInfo> parameterInfos, ReturnTypeInfo returnTypeInfo) {
        MethodTypesSyntaxChecker checker = new MethodTypesSyntaxChecker(method, parameterInfos, returnTypeInfo);
        return checker.checkSyntax();
    }

    public static RefactoringStatus checkParameterTypeSyntax(String type, IJavaProject project) {
        boolean valid;
        String newTypeName = ParameterInfo.stripEllipsis(type.trim()).trim();
        String typeLabel = BasicElementLabels.getJavaElementName(type);
        if ("".equals(newTypeName.trim())) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_parameter_type, typeLabel);
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        if (ParameterInfo.isVarargs(type) && !JavaModelUtil.is50OrHigher(project)) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_no_vararg_below_50, typeLabel);
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        ArrayList<String> problemsCollector = new ArrayList<String>(0);
        Type parsedType = TypeContextChecker.parseType(newTypeName, project, problemsCollector);
        boolean bl = valid = parsedType != null;
        if (valid && parsedType instanceof PrimitiveType) {
            boolean bl2 = valid = !PrimitiveType.VOID.equals(((PrimitiveType)parsedType).getPrimitiveTypeCode());
        }
        if (!valid) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_name, BasicElementLabels.getJavaElementName(newTypeName));
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        if (problemsCollector.size() == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = problemsCollector.iterator();
        while (iter.hasNext()) {
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_type_syntax, new String[]{BasicElementLabels.getJavaElementName(newTypeName), BasicElementLabels.getJavaElementName((String)iter.next())});
            result.addError(msg);
        }
        return result;
    }

    public static StubTypeContext createStubTypeContext(ICompilationUnit cu, CompilationUnit root, int focalPosition) throws CoreException {
        List imports;
        StringBuffer bufBefore = new StringBuffer();
        StringBuffer bufAfter = new StringBuffer();
        int introEnd = 0;
        PackageDeclaration pack = root.getPackage();
        if (pack != null) {
            introEnd = pack.getStartPosition() + pack.getLength();
        }
        if ((imports = root.imports()).size() > 0) {
            ImportDeclaration lastImport = (ImportDeclaration)imports.get(imports.size() - 1);
            introEnd = lastImport.getStartPosition() + lastImport.getLength();
        }
        bufBefore.append(cu.getBuffer().getText(0, introEnd));
        TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, root.types());
        bufBefore.append(' ');
        bufAfter.insert(0, ' ');
        return new StubTypeContext(cu, bufBefore.toString(), bufAfter.toString());
    }

    private static void fillWithTypeStubs(final StringBuffer bufBefore, final StringBuffer bufAfter, final int focalPosition, List<? extends BodyDeclaration> types) {
        for (BodyDeclaration bodyDeclaration : types) {
            List superInterfaces;
            StringBuffer buf;
            if (!(bodyDeclaration instanceof AbstractTypeDeclaration)) {
                if (!(bodyDeclaration instanceof MethodDeclaration)) continue;
                int bodyStart = bodyDeclaration.getStartPosition();
                int bodyEnd = bodyDeclaration.getStartPosition() + bodyDeclaration.getLength();
                if (bodyStart >= focalPosition || focalPosition >= bodyEnd) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                buf = bufBefore;
                TypeContextChecker.appendModifiers(buf, methodDeclaration.modifiers());
                TypeContextChecker.appendTypeParameters(buf, methodDeclaration.typeParameters());
                buf.append(" void ");
                buf.append(methodDeclaration.getName().getIdentifier());
                buf.append("(){\n");
                Block body = methodDeclaration.getBody();
                body.accept(new HierarchicalASTVisitor(){

                    public boolean visit(AbstractTypeDeclaration node) {
                        TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, Collections.singletonList(node));
                        return false;
                    }

                    public boolean visit(ClassInstanceCreation node) {
                        AnonymousClassDeclaration anonDecl = node.getAnonymousClassDeclaration();
                        if (anonDecl == null) {
                            return false;
                        }
                        int anonStart = anonDecl.getStartPosition();
                        int anonEnd = anonDecl.getStartPosition() + anonDecl.getLength();
                        if (anonStart >= focalPosition || focalPosition >= anonEnd) {
                            return false;
                        }
                        bufBefore.append(" new ");
                        bufBefore.append(node.getType().toString());
                        bufBefore.append("(){\n");
                        TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, anonDecl.bodyDeclarations());
                        bufAfter.append("};\n");
                        return false;
                    }
                });
                buf = bufAfter;
                buf.append("}\n");
                continue;
            }
            AbstractTypeDeclaration decl = (AbstractTypeDeclaration)bodyDeclaration;
            buf = decl.getStartPosition() < focalPosition ? bufBefore : bufAfter;
            TypeContextChecker.appendModifiers(buf, decl.modifiers());
            if (decl instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)decl;
                buf.append(type.isInterface() ? "interface " : "class ");
                buf.append(type.getName().getIdentifier());
                TypeContextChecker.appendTypeParameters(buf, type.typeParameters());
                if (type.getSuperclassType() != null) {
                    buf.append(" extends ");
                    buf.append(ASTNodes.asString(type.getSuperclassType()));
                }
                superInterfaces = type.superInterfaceTypes();
                TypeContextChecker.appendSuperInterfaces(buf, superInterfaces);
            } else if (decl instanceof AnnotationTypeDeclaration) {
                AnnotationTypeDeclaration annotation = (AnnotationTypeDeclaration)decl;
                buf.append("@interface ");
                buf.append(annotation.getName().getIdentifier());
            } else if (decl instanceof EnumDeclaration) {
                EnumDeclaration enumDecl = (EnumDeclaration)decl;
                buf.append("enum ");
                buf.append(enumDecl.getName().getIdentifier());
                superInterfaces = enumDecl.superInterfaceTypes();
                TypeContextChecker.appendSuperInterfaces(buf, superInterfaces);
            }
            buf.append("{\n");
            if (decl instanceof EnumDeclaration) {
                buf.append(";\n");
            }
            TypeContextChecker.fillWithTypeStubs(bufBefore, bufAfter, focalPosition, decl.bodyDeclarations());
            buf = decl.getStartPosition() + decl.getLength() < focalPosition ? bufBefore : bufAfter;
            buf.append("}\n");
        }
    }

    private static void appendTypeParameters(StringBuffer buf, List<TypeParameter> typeParameters) {
        int typeParametersCount = typeParameters.size();
        if (typeParametersCount > 0) {
            buf.append('<');
            int i = 0;
            while (i < typeParametersCount) {
                TypeParameter typeParameter = typeParameters.get(i);
                buf.append(ASTNodes.asString(typeParameter));
                if (i < typeParametersCount - 1) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append('>');
        }
    }

    private static void appendModifiers(StringBuffer buf, List<IExtendedModifier> modifiers) {
        for (IExtendedModifier extendedModifier : modifiers) {
            if (!extendedModifier.isModifier()) continue;
            Modifier modifier = (Modifier)extendedModifier;
            buf.append(modifier.getKeyword().toString()).append(' ');
        }
    }

    private static void appendSuperInterfaces(StringBuffer buf, List<Type> superInterfaces) {
        int superInterfaceCount = superInterfaces.size();
        if (superInterfaceCount > 0) {
            buf.append(" implements ");
            int i = 0;
            while (i < superInterfaceCount) {
                Type superInterface = superInterfaces.get(i);
                buf.append(ASTNodes.asString(superInterface));
                if (i < superInterfaceCount - 1) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    public static StubTypeContext createSuperInterfaceStubTypeContext(String typeName, IType enclosingType, IPackageFragment packageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(typeName, true, enclosingType, packageFragment);
    }

    public static StubTypeContext createSuperClassStubTypeContext(String typeName, IType enclosingType, IPackageFragment packageFragment) {
        return TypeContextChecker.createSupertypeStubTypeContext(typeName, false, enclosingType, packageFragment);
    }

    private static StubTypeContext createSupertypeStubTypeContext(String typeName, boolean isInterface, IType enclosingType, IPackageFragment packageFragment) {
        StubTypeContext stubTypeContext;
        String prolog = "class " + typeName + (isInterface ? " implements " : " extends ");
        String epilog = " {} ";
        if (enclosingType != null) {
            try {
                ICompilationUnit cu = enclosingType.getCompilationUnit();
                ISourceRange typeSourceRange = enclosingType.getSourceRange();
                int focalPosition = typeSourceRange.getOffset() + typeSourceRange.getLength() - 1;
                ASTParser parser = ASTParser.newParser(4);
                parser.setSource(cu);
                parser.setFocalPosition(focalPosition);
                CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                stubTypeContext = TypeContextChecker.createStubTypeContext(cu, compilationUnit, focalPosition);
                stubTypeContext = new StubTypeContext(stubTypeContext.getCuHandle(), String.valueOf(stubTypeContext.getBeforeString()) + prolog, String.valueOf(epilog) + stubTypeContext.getAfterString());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                stubTypeContext = new StubTypeContext(null, null, null);
            }
        } else if (packageFragment != null) {
            ICompilationUnit cu = packageFragment.getCompilationUnit("$$__$$.java");
            stubTypeContext = new StubTypeContext(cu, "package " + packageFragment.getElementName() + ";" + prolog, epilog);
        } else {
            stubTypeContext = new StubTypeContext(null, null, null);
        }
        return stubTypeContext;
    }

    public static Type parseSuperClass(String superClass) {
        return TypeContextChecker.parseSuperType(superClass, false);
    }

    public static Type parseSuperInterface(String superInterface) {
        return TypeContextChecker.parseSuperType(superInterface, true);
    }

    private static Type parseSuperType(String superType, boolean isInterface) {
        if (!superType.trim().equals(superType)) {
            return null;
        }
        StringBuffer cuBuff = new StringBuffer();
        if (isInterface) {
            cuBuff.append("class __X__ implements ");
        } else {
            cuBuff.append("class __X__ extends ");
        }
        int offset = cuBuff.length();
        cuBuff.append(superType).append(" {}");
        ASTParser p = ASTParser.newParser(4);
        p.setSource(cuBuff.toString().toCharArray());
        HashMap<String, String> options = new HashMap<String, String>();
        JavaModelUtil.setComplianceOptions(options, JavaModelUtil.VERSION_LATEST);
        p.setCompilerOptions(options);
        CompilationUnit cu = (CompilationUnit)p.createAST(null);
        ASTNode selected = NodeFinder.perform(cu, offset, superType.length());
        if (selected instanceof Name) {
            selected = selected.getParent();
        }
        if (selected.getStartPosition() != offset || selected.getLength() != superType.length() || !(selected instanceof Type) || selected instanceof PrimitiveType) {
            return null;
        }
        Type type = (Type)selected;
        String typeNodeRange = cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd(type));
        if (!superType.equals(typeNodeRange)) {
            return null;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypeBinding resolveSuperClass(String superclass, IType typeHandle, StubTypeContext superClassContext) {
        StringBuffer cuString = new StringBuffer();
        cuString.append(superClassContext.getBeforeString());
        cuString.append(superclass);
        cuString.append(superClassContext.getAfterString());
        try {
            ICompilationUnit wc = typeHandle.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                CompilationUnit compilationUnit = new RefactoringASTParser(4).parse(wc, true);
                ASTNode type = NodeFinder.perform(compilationUnit, superClassContext.getBeforeString().length(), superclass.length());
                if (type instanceof Type) {
                    ITypeBinding iTypeBinding = TypeContextChecker.handleBug84585(((Type)type).resolveBinding());
                    return iTypeBinding;
                }
                if (!(type instanceof Name)) throw new IllegalStateException();
                ASTNode parent = type.getParent();
                if (!(parent instanceof Type)) throw new IllegalStateException();
                ITypeBinding iTypeBinding = TypeContextChecker.handleBug84585(((Type)parent).resolveBinding());
                return iTypeBinding;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITypeBinding[] resolveSuperInterfaces(String[] interfaces, IType typeHandle, StubTypeContext superInterfaceContext) {
        ITypeBinding[] result = new ITypeBinding[interfaces.length];
        int[] interfaceOffsets = new int[interfaces.length];
        StringBuffer cuString = new StringBuffer();
        cuString.append(superInterfaceContext.getBeforeString());
        int last = interfaces.length - 1;
        int i = 0;
        while (i <= last) {
            interfaceOffsets[i] = cuString.length();
            cuString.append(interfaces[i]);
            if (i != last) {
                cuString.append(", ");
            }
            ++i;
        }
        cuString.append(superInterfaceContext.getAfterString());
        try {
            ICompilationUnit wc = typeHandle.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                CompilationUnit compilationUnit = new RefactoringASTParser(4).parse(wc, true);
                int i2 = 0;
                while (i2 <= last) {
                    ASTNode type = NodeFinder.perform(compilationUnit, interfaceOffsets[i2], interfaces[i2].length());
                    if (type instanceof Type) {
                        result[i2] = TypeContextChecker.handleBug84585(((Type)type).resolveBinding());
                    } else {
                        if (!(type instanceof Name)) throw new IllegalStateException();
                        ASTNode parent = type.getParent();
                        if (!(parent instanceof Type)) throw new IllegalStateException();
                        result[i2] = TypeContextChecker.handleBug84585(((Type)parent).resolveBinding());
                    }
                    ++i2;
                }
                return result;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodTypesChecker {
        private static final String METHOD_NAME = "__$$__";
        private final IMethod fMethod;
        private final StubTypeContext fStubTypeContext;
        private final List<ParameterInfo> fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;

        public MethodTypesChecker(IMethod method, StubTypeContext stubTypeContext, List<ParameterInfo> parameterInfos, ReturnTypeInfo returnTypeInfo) {
            this.fMethod = method;
            this.fStubTypeContext = stubTypeContext;
            this.fParameterInfos = parameterInfos;
            this.fReturnTypeInfo = returnTypeInfo;
        }

        public RefactoringStatus[] checkAndResolveMethodTypes() throws CoreException {
            RefactoringStatus[] results = new MethodTypesSyntaxChecker(this.fMethod, this.fParameterInfos, this.fReturnTypeInfo).checkSyntax();
            int i = 0;
            while (i < results.length) {
                if (results[i] != null && results[i].hasFatalError()) {
                    return results;
                }
                ++i;
            }
            int parameterCount = this.fParameterInfos.size();
            String[] types = new String[parameterCount + 1];
            int i2 = 0;
            while (i2 < parameterCount) {
                types[i2] = ParameterInfo.stripEllipsis(this.fParameterInfos.get(i2).getNewTypeName());
                ++i2;
            }
            types[parameterCount] = this.fReturnTypeInfo.getNewTypeName();
            RefactoringStatus[] semanticsResults = new RefactoringStatus[parameterCount + 1];
            ITypeBinding[] typeBindings = this.resolveBindings(types, semanticsResults, true);
            boolean needsSecondPass = false;
            int i3 = 0;
            while (i3 < types.length) {
                if (typeBindings[i3] == null || !semanticsResults[i3].isOK()) {
                    needsSecondPass = true;
                }
                ++i3;
            }
            RefactoringStatus[] semanticsResults2 = new RefactoringStatus[parameterCount + 1];
            if (needsSecondPass) {
                typeBindings = this.resolveBindings(types, semanticsResults2, false);
            }
            int i4 = 0;
            while (i4 < this.fParameterInfos.size()) {
                ParameterInfo parameterInfo = this.fParameterInfos.get(i4);
                if (parameterInfo.isResolve()) {
                    if (parameterInfo.getOldTypeBinding() != null && !parameterInfo.isTypeNameChanged()) {
                        parameterInfo.setNewTypeBinding(parameterInfo.getOldTypeBinding());
                    } else {
                        parameterInfo.setNewTypeBinding(typeBindings[i4]);
                        if (typeBindings[i4] == null || needsSecondPass && !semanticsResults2[i4].isOK()) {
                            if (results[i4] == null) {
                                results[i4] = semanticsResults2[i4];
                            } else {
                                results[i4].merge(semanticsResults2[i4]);
                            }
                        }
                    }
                }
                ++i4;
            }
            this.fReturnTypeInfo.setNewTypeBinding(typeBindings[this.fParameterInfos.size()]);
            if (typeBindings[parameterCount] == null || needsSecondPass && !semanticsResults2[parameterCount].isOK()) {
                if (results[parameterCount] == null) {
                    results[parameterCount] = semanticsResults2[parameterCount];
                } else {
                    results[parameterCount].merge(semanticsResults2[parameterCount]);
                }
            }
            return results;
        }

        private ITypeBinding[] resolveBindings(String[] types, RefactoringStatus[] results, boolean firstPass) throws CoreException {
            int parameterCount = types.length - 1;
            ITypeBinding[] typeBindings = new ITypeBinding[types.length];
            StringBuffer cuString = new StringBuffer();
            cuString.append(this.fStubTypeContext.getBeforeString());
            int offsetBeforeMethodName = this.appendMethodDeclaration(cuString, types, parameterCount);
            cuString.append(this.fStubTypeContext.getAfterString());
            ICompilationUnit wc = this.fMethod.getCompilationUnit().getWorkingCopy(new WorkingCopyOwner(){}, new NullProgressMonitor());
            try {
                wc.getBuffer().setContents(cuString.toString());
                CompilationUnit compilationUnit = new RefactoringASTParser(4).parse(wc, true);
                ASTNode method = NodeFinder.perform(compilationUnit, offsetBeforeMethodName, METHOD_NAME.length()).getParent();
                Type[] typeNodes = new Type[types.length];
                if (method instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)method;
                    typeNodes[parameterCount] = methodDeclaration.getReturnType2();
                    List parameters = methodDeclaration.parameters();
                    int i = 0;
                    while (i < parameterCount) {
                        typeNodes[i] = ((SingleVariableDeclaration)parameters.get(i)).getType();
                        ++i;
                    }
                } else if (method instanceof AnnotationTypeMemberDeclaration) {
                    typeNodes[0] = ((AnnotationTypeMemberDeclaration)method).getType();
                }
                int i = 0;
                while (i < types.length) {
                    Type type = typeNodes[i];
                    if (type == null) {
                        String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_couldNotResolveType, BasicElementLabels.getJavaElementName(types[i]));
                        results[i] = RefactoringStatus.createErrorStatus((String)msg);
                    } else {
                        results[i] = new RefactoringStatus();
                        IProblem[] problems = ASTNodes.getProblems(type, 0, 3);
                        if (problems.length > 0) {
                            int p = 0;
                            while (p < problems.length) {
                                if (this.isError(problems[p], type)) {
                                    results[i].addError(problems[p].getMessage());
                                }
                                ++p;
                            }
                        }
                        ITypeBinding binding = TypeContextChecker.handleBug84585(type.resolveBinding());
                        if (firstPass && (binding == null || binding.isRecovered())) {
                            types[i] = this.qualifyTypes(type, results[i]);
                        }
                        typeBindings[i] = binding;
                    }
                    ++i;
                }
                ITypeBinding[] iTypeBindingArray = typeBindings;
                return iTypeBindingArray;
            }
            finally {
                wc.discardWorkingCopy();
            }
        }

        private boolean isError(IProblem problem, Type type) {
            return true;
        }

        private int appendMethodDeclaration(StringBuffer cuString, String[] types, int parameterCount) throws JavaModelException {
            ITypeParameter[] methodTypeParameters;
            if (Flags.isStatic(this.fMethod.getFlags())) {
                cuString.append("static ");
            }
            if ((methodTypeParameters = this.fMethod.getTypeParameters()).length != 0) {
                cuString.append('<');
                int i = 0;
                while (i < methodTypeParameters.length) {
                    ITypeParameter typeParameter = methodTypeParameters[i];
                    if (i > 0) {
                        cuString.append(',');
                    }
                    cuString.append(typeParameter.getElementName());
                    ++i;
                }
                cuString.append("> ");
            }
            cuString.append(types[parameterCount]).append(' ');
            int offsetBeforeMethodName = cuString.length();
            cuString.append(METHOD_NAME).append('(');
            int i = 0;
            while (i < parameterCount) {
                if (i > 0) {
                    cuString.append(',');
                }
                cuString.append(types[i]).append(" p").append(i);
                ++i;
            }
            cuString.append(");");
            return offsetBeforeMethodName;
        }

        private String qualifyTypes(Type type, final RefactoringStatus result) throws CoreException {
            class NestedException
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                NestedException(CoreException e) {
                    super(e);
                }
            }
            ASTFlattener flattener = new ASTFlattener(){

                public boolean visit(SimpleName node) {
                    this.appendResolved(node.getIdentifier());
                    return false;
                }

                public boolean visit(QualifiedName node) {
                    this.appendResolved(node.getFullyQualifiedName());
                    return false;
                }

                public boolean visit(QualifiedType node) {
                    this.appendResolved(ASTNodes.asString(node));
                    return false;
                }

                private void appendResolved(String typeName) {
                    String resolvedType;
                    try {
                        resolvedType = MethodTypesChecker.resolveType(typeName, result, MethodTypesChecker.this.fMethod.getDeclaringType(), null);
                    }
                    catch (CoreException e) {
                        throw new NestedException(e);
                    }
                    this.fBuffer.append(resolvedType);
                }
            };
            try {
                type.accept(flattener);
            }
            catch (NestedException e) {
                throw (CoreException)e.getCause();
            }
            return flattener.getResult();
        }

        private static String resolveType(String elementTypeName, RefactoringStatus status, IType declaringType, IProgressMonitor pm) throws CoreException {
            List<TypeNameMatch> typeRefsFound;
            String[][] fqns = declaringType.resolveType(elementTypeName);
            if (fqns != null) {
                if (fqns.length == 1) {
                    return JavaModelUtil.concatenateName(fqns[0][0], fqns[0][1]);
                }
                if (fqns.length > 1) {
                    Object[] keys = new String[]{BasicElementLabels.getJavaElementName(elementTypeName), String.valueOf(fqns.length)};
                    String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, keys);
                    status.addError(msg);
                    return elementTypeName;
                }
            }
            if ((typeRefsFound = MethodTypesChecker.findTypeInfos(elementTypeName, declaringType, pm)).size() == 0) {
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_not_unique, BasicElementLabels.getJavaElementName(elementTypeName));
                status.addError(msg);
                return elementTypeName;
            }
            if (typeRefsFound.size() == 1) {
                TypeNameMatch typeInfo = typeRefsFound.get(0);
                return typeInfo.getFullyQualifiedName();
            }
            Assert.isTrue(typeRefsFound.size() > 1);
            Object[] keys = new String[]{BasicElementLabels.getJavaElementName(elementTypeName), String.valueOf(typeRefsFound.size())};
            String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_ambiguous, keys);
            status.addError(msg);
            return elementTypeName;
        }

        private static List<TypeNameMatch> findTypeInfos(String typeName, IType contextType, IProgressMonitor pm) throws JavaModelException {
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{contextType.getJavaProject()}, true);
            IPackageFragment currPackage = contextType.getPackageFragment();
            ArrayList<TypeNameMatch> collectedInfos = new ArrayList<TypeNameMatch>();
            TypeNameMatchCollector requestor = new TypeNameMatchCollector(collectedInfos);
            int matchMode = 8;
            new SearchEngine().searchAllTypeNames(null, matchMode, typeName.toCharArray(), matchMode, 0, scope, requestor, 3, pm);
            ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>();
            for (TypeNameMatch curr : collectedInfos) {
                IType type = curr.getType();
                if (type == null) continue;
                boolean visible = true;
                try {
                    visible = JavaModelUtil.isVisible(type, currPackage);
                }
                catch (JavaModelException javaModelException) {}
                if (!visible) continue;
                result.add(curr);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodTypesSyntaxChecker {
        private final IMethod fMethod;
        private final List<ParameterInfo> fParameterInfos;
        private final ReturnTypeInfo fReturnTypeInfo;

        public MethodTypesSyntaxChecker(IMethod method, List<ParameterInfo> parameterInfos, ReturnTypeInfo returnTypeInfo) {
            this.fMethod = method;
            this.fParameterInfos = parameterInfos;
            this.fReturnTypeInfo = returnTypeInfo;
        }

        public RefactoringStatus[] checkSyntax() {
            int parameterCount = this.fParameterInfos.size();
            RefactoringStatus[] results = new RefactoringStatus[parameterCount + 1];
            results[parameterCount] = this.checkReturnTypeSyntax();
            int i = 0;
            while (i < parameterCount) {
                ParameterInfo info = this.fParameterInfos.get(i);
                if (!info.isDeleted()) {
                    results[i] = this.checkParameterTypeSyntax(info);
                }
                ++i;
            }
            return results;
        }

        private RefactoringStatus checkParameterTypeSyntax(ParameterInfo info) {
            if (!(info.isAdded() || info.isTypeNameChanged() || info.isDeleted())) {
                return null;
            }
            return TypeContextChecker.checkParameterTypeSyntax(info.getNewTypeName(), this.fMethod.getJavaProject());
        }

        private RefactoringStatus checkReturnTypeSyntax() {
            String newTypeName = this.fReturnTypeInfo.getNewTypeName();
            if ("".equals(newTypeName.trim())) {
                String msg = RefactoringCoreMessages.TypeContextChecker_return_type_not_empty;
                return RefactoringStatus.createFatalErrorStatus((String)msg);
            }
            ArrayList problemsCollector = new ArrayList(0);
            Type parsedType = TypeContextChecker.parseType(newTypeName, this.fMethod.getJavaProject(), problemsCollector);
            if (parsedType == null) {
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type, BasicElementLabels.getJavaElementName(newTypeName));
                return RefactoringStatus.createFatalErrorStatus((String)msg);
            }
            if (problemsCollector.size() == 0) {
                return null;
            }
            RefactoringStatus result = new RefactoringStatus();
            Iterator iter = problemsCollector.iterator();
            while (iter.hasNext()) {
                Object[] keys = new String[]{BasicElementLabels.getJavaElementName(newTypeName), BasicElementLabels.getJavaElementName((String)iter.next())};
                String msg = Messages.format(RefactoringCoreMessages.TypeContextChecker_invalid_return_type_syntax, keys);
                result.addError(msg);
            }
            return result;
        }

        private static boolean isVoidArrayType(Type type) {
            if (!type.isArrayType()) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            if (!arrayType.getComponentType().isPrimitiveType()) {
                return false;
            }
            PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
            return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
        }
    }
}

