/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.binary;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreator {
    protected StringBuffer fBuffer;
    protected final boolean fStubInvisible;

    public StubCreator(boolean stubInvisible) {
        this.fStubInvisible = stubInvisible;
    }

    protected void appendEnumConstants(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        ArrayList<IField> list = new ArrayList<IField>(fields.length);
        int index = 0;
        while (index < fields.length) {
            IField field = fields[index];
            if (Flags.isEnum(field.getFlags())) {
                list.add(field);
            }
            ++index;
        }
        index = 0;
        while (index < list.size()) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)list.get(index)).getElementName());
            ++index;
        }
        this.fBuffer.append(";");
    }

    protected void appendExpression(String signature) {
        switch (signature.charAt(0)) {
            case 'Z': {
                this.fBuffer.append("false");
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                this.fBuffer.append("0");
                break;
            }
            default: {
                this.fBuffer.append("(");
                this.fBuffer.append(Signature.toString(signature));
                this.fBuffer.append(")");
                this.fBuffer.append("null");
            }
        }
    }

    protected void appendFieldDeclaration(IField field) throws JavaModelException {
        this.appendFlags(field);
        this.fBuffer.append(" ");
        String signature = field.getTypeSignature();
        this.fBuffer.append(Signature.toString(signature));
        this.fBuffer.append(" ");
        this.fBuffer.append(field.getElementName());
        if (Flags.isFinal(field.getFlags())) {
            this.fBuffer.append("=");
            this.appendExpression(signature);
        }
        this.fBuffer.append(";");
    }

    protected void appendFlags(IMember member) throws JavaModelException {
        if (member instanceof IAnnotatable) {
            IAnnotation[] iAnnotationArray = ((IAnnotatable)((Object)member)).getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                this.appendAnnotation(annotation);
                ++n2;
            }
        }
        int flags = member.getFlags();
        int kind = member.getElementType();
        if (kind == 7) {
            flags &= 0xFFFFFFDF;
            IType type = (IType)member;
            if (!type.isMember()) {
                flags &= 0xFFFFFFFD;
            }
        }
        if (Flags.isEnum(flags)) {
            flags &= 0xFFFFFFEF;
        }
        if (kind == 9) {
            flags &= 0xFFFFFF7F;
            flags &= 0xFFFFFFBF;
        }
        if (flags != 0) {
            this.fBuffer.append(Flags.toString(flags));
        }
    }

    private void appendAnnotation(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] memberValuePairs;
        this.fBuffer.append('@');
        this.fBuffer.append(annotation.getElementName());
        this.fBuffer.append('(');
        IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
        int n = memberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            this.fBuffer.append(pair.getMemberName());
            this.fBuffer.append('=');
            this.appendAnnotationValue(pair.getValue(), pair.getValueKind());
            this.fBuffer.append(',');
            ++n2;
        }
        if (memberValuePairs.length > 0) {
            this.fBuffer.deleteCharAt(this.fBuffer.length() - 1);
        }
        this.fBuffer.append(')').append('\n');
    }

    private void appendAnnotationValue(Object value, int valueKind) throws JavaModelException {
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            this.fBuffer.append('{');
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.appendAnnotationValue(object, valueKind);
                this.fBuffer.append(',');
                ++n2;
            }
            if (objects.length > 0) {
                this.fBuffer.deleteCharAt(this.fBuffer.length() - 1);
            }
            this.fBuffer.append('}');
        } else {
            switch (valueKind) {
                case 10: {
                    this.appendAnnotation((IAnnotation)value);
                    break;
                }
                case 9: {
                    this.fBuffer.append('\"').append(value).append('\"');
                    break;
                }
                default: {
                    this.fBuffer.append(value);
                }
            }
        }
    }

    protected void appendMembers(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaElement[] children = type.getChildren();
            int index = 0;
            while (index < children.length) {
                block16: {
                    block14: {
                        boolean skip;
                        int count;
                        boolean stub;
                        int flags;
                        IMember child;
                        block15: {
                            block13: {
                                child = (IMember)children[index];
                                flags = child.getFlags();
                                boolean isPrivate = Flags.isPrivate(flags);
                                boolean isDefault = !Flags.isPublic(flags) && !Flags.isProtected(flags) && !isPrivate;
                                boolean bl = stub = this.fStubInvisible || !isPrivate && !isDefault;
                                if (!(child instanceof IType)) break block13;
                                if (stub) {
                                    this.appendTypeDeclaration((IType)child, new SubProgressMonitor(monitor, 1));
                                }
                                break block14;
                            }
                            if (!(child instanceof IField)) break block15;
                            if (stub && !Flags.isEnum(flags) && !Flags.isSynthetic(flags)) {
                                this.appendFieldDeclaration((IField)child);
                            }
                            break block14;
                        }
                        if (!(child instanceof IMethod)) break block14;
                        IMethod method = (IMethod)child;
                        String name = method.getElementName();
                        if (method.getDeclaringType().isEnum() && ((count = method.getNumberOfParameters()) == 0 && "values".equals(name) || count == 1 && "valueOf".equals(name) && "Ljava.lang.String;".equals(method.getParameterTypes()[0]) || method.isConstructor())) break block16;
                        boolean bl = skip = !stub || name.equals("<clinit>");
                        if (method.isConstructor()) {
                            skip = false;
                        }
                        boolean bl2 = skip = skip || Flags.isSynthetic(flags) || Flags.isBridge(flags);
                        if (!skip) {
                            this.appendMethodDeclaration(method);
                        }
                    }
                    this.fBuffer.append("\n");
                }
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void appendMethodBody(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            IType declaringType = method.getDeclaringType();
            String superSignature = declaringType.getSuperclassTypeSignature();
            if (superSignature != null) {
                superSignature = Signature.getTypeErasure(superSignature);
                IType superclass = declaringType.getJavaProject().findType(Signature.getSignatureQualifier(superSignature), Signature.getSignatureSimpleName(superSignature));
                if (superclass != null) {
                    String[] superParameters;
                    int paramLength;
                    IMethod[] superMethods = superclass.getMethods();
                    IMethod superConstructor = null;
                    int length = superMethods.length;
                    int index = 0;
                    while (index < length) {
                        IMethod superMethod = superMethods[index];
                        if (superMethod.isConstructor() && !Flags.isPrivate(superMethod.getFlags()) && (superConstructor = superMethod).getExceptionTypes().length == 0) break;
                        ++index;
                    }
                    if (superConstructor != null && (paramLength = (superParameters = superConstructor.getParameterTypes()).length) != 0) {
                        this.fBuffer.append("super(");
                        int index2 = 0;
                        while (index2 < paramLength) {
                            if (index2 > 0) {
                                this.fBuffer.append(",");
                            }
                            this.appendExpression(superParameters[index2]);
                            ++index2;
                        }
                        this.fBuffer.append(");");
                    }
                }
            }
        } else {
            String returnType = method.getReturnType();
            if (!"V".equals(returnType)) {
                this.fBuffer.append("return ");
                this.appendExpression(returnType);
                this.fBuffer.append(";");
            }
        }
    }

    protected void appendMethodDeclaration(IMethod method) throws JavaModelException {
        this.appendFlags(method);
        this.fBuffer.append(" ");
        ITypeParameter[] parameters = method.getTypeParameters();
        if (parameters.length > 0) {
            this.appendTypeParameters(parameters);
            this.fBuffer.append(" ");
        }
        String returnType = method.getReturnType();
        if (!method.isConstructor()) {
            this.fBuffer.append(Signature.toString(returnType));
            this.fBuffer.append(" ");
        }
        this.fBuffer.append(method.getElementName());
        this.fBuffer.append("(");
        String[] parameterTypes = method.getParameterTypes();
        int flags = method.getFlags();
        boolean varargs = Flags.isVarargs(flags);
        int parameterLength = parameterTypes.length;
        int index = 0;
        while (index < parameterLength) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString(parameterTypes[index]));
            if (varargs && index == parameterLength - 1) {
                int length = this.fBuffer.length();
                if (length >= 2 && this.fBuffer.indexOf("[]", length - 2) >= 0) {
                    this.fBuffer.setLength(length - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" ");
            this.appendMethodParameterName(method, index);
            ++index;
        }
        this.fBuffer.append(")");
        String[] exceptionTypes = method.getExceptionTypes();
        int exceptionLength = exceptionTypes.length;
        if (exceptionLength > 0) {
            this.fBuffer.append(" throws ");
        }
        int index2 = 0;
        while (index2 < exceptionLength) {
            if (index2 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString(exceptionTypes[index2]));
            ++index2;
        }
        if (Flags.isAbstract(flags) || Flags.isNative(flags)) {
            this.fBuffer.append(";");
        } else {
            this.fBuffer.append("{\n");
            this.appendMethodBody(method);
            this.fBuffer.append("}");
        }
    }

    protected void appendMethodParameterName(IMethod method, int index) {
        this.fBuffer.append("a");
        this.fBuffer.append(index);
    }

    protected void appendSuperInterfaceTypes(IType type) throws JavaModelException {
        String[] signatures = type.getSuperInterfaceTypeSignatures();
        if (signatures.length > 0) {
            if (type.isInterface()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" implements ");
            }
        }
        int index = 0;
        while (index < signatures.length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString(signatures[index]));
            ++index;
        }
    }

    protected void appendTopLevelType(IType type, IProgressMonitor subProgressMonitor) throws JavaModelException {
        String packageName = type.getPackageFragment().getElementName();
        if (packageName.length() > 0) {
            this.fBuffer.append("package ");
            this.fBuffer.append(packageName);
            this.fBuffer.append(";\n");
        }
        this.appendTypeDeclaration(type, subProgressMonitor);
    }

    protected void appendTypeDeclaration(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (type.isAnnotation()) {
                this.appendFlags(type);
                this.fBuffer.append(" @interface ");
                this.fBuffer.append(type.getElementName());
                this.fBuffer.append("{\n");
                this.appendMembers(type, new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isInterface()) {
                this.appendFlags(type);
                this.fBuffer.append(" interface ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isClass()) {
                this.appendFlags(type);
                this.fBuffer.append(" class ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                String signature = type.getSuperclassTypeSignature();
                if (signature != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString(signature));
                }
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isEnum()) {
                this.appendFlags(type);
                this.fBuffer.append(" enum ");
                this.fBuffer.append(type.getElementName());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendEnumConstants(type);
                this.appendMembers(type, new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void appendTypeParameters(ITypeParameter[] parameters) throws JavaModelException {
        int length = parameters.length;
        if (length > 0) {
            this.fBuffer.append("<");
        }
        int index = 0;
        while (index < length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            ITypeParameter parameter = parameters[index];
            this.fBuffer.append(parameter.getElementName());
            String[] bounds = parameter.getBounds();
            int size = bounds.length;
            if (size > 0) {
                this.fBuffer.append(" extends ");
            }
            int offset = 0;
            while (offset < size) {
                if (offset > 0) {
                    this.fBuffer.append(" & ");
                }
                this.fBuffer.append(bounds[offset]);
                ++offset;
            }
            ++index;
        }
        if (length > 0) {
            this.fBuffer.append(">");
        }
    }

    public String createStub(IType topLevelType, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue(Checks.isTopLevel(topLevelType));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBuffer = new StringBuffer(2046);
        this.appendTopLevelType(topLevelType, monitor);
        String result = this.fBuffer.toString();
        this.fBuffer = null;
        return result;
    }
}

