/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class ClasspathChange
extends ResourceChange {
    private IJavaProject fProject;
    private IClasspathEntry[] fNewClasspath;
    private final IPath fOutputLocation;

    public static ClasspathChange addEntryChange(IJavaProject project, IClasspathEntry entryToAdd) throws JavaModelException {
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[rawClasspath.length + 1];
        System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
        newClasspath[rawClasspath.length] = entryToAdd;
        IPath outputLocation = project.getOutputLocation();
        return ClasspathChange.newChange(project, newClasspath, outputLocation);
    }

    public static ClasspathChange removeEntryChange(IJavaProject project, IClasspathEntry entryToRemove) throws JavaModelException {
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry curr = rawClasspath[i];
            if (curr.getEntryKind() != entryToRemove.getEntryKind() || !curr.getPath().equals(entryToRemove.getPath())) {
                newClasspath.add(curr);
            }
            ++i;
        }
        IClasspathEntry[] entries = newClasspath.toArray(new IClasspathEntry[newClasspath.size()]);
        IPath outputLocation = project.getOutputLocation();
        return ClasspathChange.newChange(project, entries, outputLocation);
    }

    public static ClasspathChange newChange(IJavaProject project, IClasspathEntry[] newClasspath, IPath outputLocation) {
        if (!JavaConventions.validateClasspath(project, newClasspath, outputLocation).matches(4)) {
            return new ClasspathChange(project, newClasspath, outputLocation);
        }
        return null;
    }

    public ClasspathChange(IJavaProject project, IClasspathEntry[] newClasspath, IPath outputLocation) {
        this.fProject = project;
        this.fNewClasspath = newClasspath;
        this.fOutputLocation = outputLocation;
        this.setValidationMethod(3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ClasspathChange_progress_message, 1);
        try {
            if (!JavaConventions.validateClasspath(this.fProject, this.fNewClasspath, this.fOutputLocation).matches(4)) {
                IClasspathEntry[] oldClasspath = this.fProject.getRawClasspath();
                IPath oldOutputLocation = this.fProject.getOutputLocation();
                this.fProject.setRawClasspath(this.fNewClasspath, this.fOutputLocation, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ClasspathChange classpathChange = new ClasspathChange(this.fProject, oldClasspath, oldOutputLocation);
                return classpathChange;
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return RefactoringCoreMessages.ClasspathChange_change_name;
    }

    protected IResource getModifiedResource() {
        return this.fProject.getResource();
    }

    public Object getModifiedElement() {
        return this.fProject;
    }
}

