/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

abstract class PackageReorgChange
extends ResourceChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;

    PackageReorgChange(IPackageFragment pack, IPackageFragmentRoot dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
        this.setValidationMethod(0);
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaModelException, OperationCanceledException;

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(this.getName(), 1);
        try {
            IPackageFragment pack = this.getPackage();
            ResourceMapping mapping = JavaElementResourceMapping.create(pack);
            Change result = this.doPerformReorg(pm);
            this.markAsExecuted(pack, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    protected IResource getModifiedResource() {
        IPackageFragment pack = this.getPackage();
        if (pack != null) {
            return pack.getResource();
        }
        return null;
    }

    IPackageFragmentRoot getDestination() {
        return (IPackageFragmentRoot)JavaCore.create(this.fDestinationHandle);
    }

    IPackageFragment getPackage() {
        return (IPackageFragment)JavaCore.create(this.fPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IPackageFragment pack, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)pack);
            log.markAsProcessed((Object)mapping);
        }
    }
}

