/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceIndirectionDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceIndirectionRefactoring
extends Refactoring {
    private ICompilationUnit fSelectionCompilationUnit;
    private IClassFile fSelectionClassFile;
    private int fSelectionStart;
    private int fSelectionLength;
    private MethodInvocation fSelectionMethodInvocation;
    private IType fIntermediaryClass;
    private ITypeBinding fIntermediaryClassBinding;
    private String fIntermediaryMethodName;
    private ITypeBinding fIntermediaryFirstParameterType;
    private IMethod fTargetMethod;
    private IMethodBinding fTargetMethodBinding;
    private boolean fUpdateReferences;
    private Map<ICompilationUnit, CompilationUnitRewrite> fRewrites;
    private TextChangeManager fTextChangeManager;
    private MemberVisibilityAdjustor fAdjustor;
    private Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> fIntermediaryAdjustments;

    public IntroduceIndirectionRefactoring(ICompilationUnit unit, int offset, int length) {
        this.fSelectionCompilationUnit = unit;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IClassFile file, int offset, int length) {
        this.fSelectionClassFile = file;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IMethod method) {
        this.fTargetMethod = method;
        this.initialize(0, 0);
    }

    public IntroduceIndirectionRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void initialize(int offset, int length) {
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        this.fUpdateReferences = true;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection_name;
    }

    public IJavaProject getProject() {
        if (this.fSelectionCompilationUnit != null) {
            return this.fSelectionCompilationUnit.getJavaProject();
        }
        if (this.fSelectionClassFile != null) {
            return this.fSelectionClassFile.getJavaProject();
        }
        if (this.fTargetMethod != null) {
            return this.fTargetMethod.getJavaProject();
        }
        return null;
    }

    public IPackageFragment getInvocationPackage() {
        return this.fSelectionCompilationUnit != null ? (IPackageFragment)this.fSelectionCompilationUnit.getAncestor(4) : null;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setEnableUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus setIntermediaryMethodName(String newMethodName) {
        Assert.isNotNull(newMethodName);
        this.fIntermediaryMethodName = newMethodName;
        IAnnotatable context = this.fIntermediaryClass != null ? this.fIntermediaryClass : this.fTargetMethod;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName, context);
        stat.merge(this.checkOverloading());
        return stat;
    }

    private RefactoringStatus checkOverloading() {
        try {
            if (this.fIntermediaryClass != null) {
                IMethod[] toCheck = this.fIntermediaryClass.getMethods();
                int i = 0;
                while (i < toCheck.length) {
                    IMethod method = toCheck[i];
                    if (method.getElementName().equals(this.fIntermediaryMethodName)) {
                        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_duplicate_method_name_in_declaring_class_error, BasicElementLabels.getJavaElementName(this.fIntermediaryMethodName)));
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_could_not_parse_declaring_class_error);
        }
        return new RefactoringStatus();
    }

    public String getIntermediaryMethodName() {
        return this.fIntermediaryMethodName;
    }

    public RefactoringStatus setIntermediaryClassName(String fullyQualifiedTypeName) {
        IType target = null;
        try {
            if (fullyQualifiedTypeName.length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_not_selected_error);
            }
            target = this.getProject().findType(fullyQualifiedTypeName, new NullProgressMonitor());
            if (target == null || !target.exists()) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_does_not_exist_error, BasicElementLabels.getJavaElementName(fullyQualifiedTypeName)));
            }
            if (target.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_annotation);
            }
            if (target.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_on_interface);
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_unable_determine_declaring_type);
        }
        if (target.isReadOnly()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_readonly);
        }
        if (target.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_binary);
        }
        this.fIntermediaryClass = target;
        return new RefactoringStatus();
    }

    public String getIntermediaryClassName() {
        return this.fIntermediaryClass != null ? this.fIntermediaryClass.getFullyQualifiedName('.') : "";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_activation, 1);
            this.fRewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
            if (this.fTargetMethod == null) {
                ASTNode selectionNode;
                if (this.fSelectionStart == 0) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
                if (this.fSelectionCompilationUnit != null) {
                    CompilationUnit selectionCURoot = this.getCachedCURewrite(this.fSelectionCompilationUnit).getRoot();
                    selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(this.fSelectionCompilationUnit, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                } else {
                    ASTParser parser = ASTParser.newParser(4);
                    parser.setResolveBindings(true);
                    parser.setSource(this.fSelectionClassFile);
                    CompilationUnit selectionCURoot = (CompilationUnit)parser.createAST(null);
                    selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(null, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                }
                if (selectionNode == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
                IMethodBinding targetMethodBinding = null;
                if (selectionNode.getNodeType() == 32) {
                    targetMethodBinding = ((MethodInvocation)selectionNode).resolveMethodBinding();
                } else if (selectionNode.getNodeType() == 31) {
                    targetMethodBinding = ((MethodDeclaration)selectionNode).resolveBinding();
                } else if (selectionNode.getNodeType() == 48) {
                    targetMethodBinding = ((SuperMethodInvocation)selectionNode).resolveMethodBinding();
                } else {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
                this.fTargetMethodBinding = targetMethodBinding.getMethodDeclaration();
                this.fTargetMethod = (IMethod)this.fTargetMethodBinding.getJavaElement();
                if (selectionNode instanceof MethodInvocation && this.fSelectionCompilationUnit != null) {
                    this.fSelectionMethodInvocation = (MethodInvocation)selectionNode;
                }
            } else {
                if (this.fTargetMethod.getDeclaringType().isAnnotation()) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_annotation);
                    return refactoringStatus;
                }
                if (this.fTargetMethod.getCompilationUnit() != null) {
                    CompilationUnit selectionCURoot = this.getCachedCURewrite(this.fTargetMethod.getCompilationUnit()).getRoot();
                    MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fTargetMethod, selectionCURoot);
                    this.fTargetMethodBinding = declaration.resolveBinding().getMethodDeclaration();
                } else {
                    ASTParser parser = ASTParser.newParser(4);
                    parser.setProject(this.fTargetMethod.getJavaProject());
                    IBinding[] bindings = parser.createBindings(new IJavaElement[]{this.fTargetMethod}, null);
                    this.fTargetMethodBinding = ((IMethodBinding)bindings[0]).getMethodDeclaration();
                }
            }
            if (this.fTargetMethod == null || this.fTargetMethodBinding == null || !RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(this.fTargetMethod)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                return refactoringStatus;
            }
            if (this.fTargetMethod.getDeclaringType().isLocal() || this.fTargetMethod.getDeclaringType().isAnonymous()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_local_or_anonymous_types);
                return refactoringStatus;
            }
            if (this.fTargetMethod.isConstructor()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_constructors);
                return refactoringStatus;
            }
            if (this.fIntermediaryMethodName == null) {
                this.fIntermediaryMethodName = this.fTargetMethod.getElementName();
            }
            if (this.fIntermediaryClass == null) {
                if (this.fSelectionCompilationUnit != null && !this.fSelectionCompilationUnit.isReadOnly()) {
                    this.fIntermediaryClass = this.getEnclosingInitialSelectionMember().getDeclaringType();
                } else if (!this.fTargetMethod.isBinary() && !this.fTargetMethod.isReadOnly()) {
                    this.fIntermediaryClass = this.fTargetMethod.getDeclaringType();
                }
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.fTextChangeManager = new TextChangeManager();
        this.fIntermediaryFirstParameterType = null;
        this.fIntermediaryClassBinding = null;
        Iterator<CompilationUnitRewrite> iter = this.fRewrites.values().iterator();
        while (iter.hasNext()) {
            iter.next().clearASTAndImportRewrites();
        }
        int startupTicks = 5;
        int hierarchyTicks = 5;
        int visibilityTicks = 5;
        int referenceTicks = this.fUpdateReferences ? 30 : 5;
        int creationTicks = 5;
        pm.beginTask("", startupTicks + hierarchyTicks + visibilityTicks + referenceTicks + creationTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        result.merge(Checks.checkMethodName(this.fIntermediaryMethodName, this.fIntermediaryClass));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fIntermediaryClass == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_run_without_intermediary_type);
        }
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getCompilationUnit());
        this.fIntermediaryClassBinding = this.typeToBinding(this.fIntermediaryClass, imRewrite.getRoot());
        this.fAdjustor = new MemberVisibilityAdjustor(this.fIntermediaryClass, this.fIntermediaryClass);
        this.fIntermediaryAdjustments = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
        if (this.fIntermediaryClassBinding.isNested() && !Modifier.isStatic(this.fIntermediaryClassBinding.getModifiers())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_nested_nonstatic, (RefactoringStatusContext)JavaStatusContext.create(this.fIntermediaryClass));
        }
        pm.worked(startupTicks);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fUpdateReferences) {
            pm.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_looking_for_references);
            result.merge(this.updateReferences(new NoOverrideProgressMonitor(pm, referenceTicks)));
            pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        } else {
            if (this.fSelectionMethodInvocation != null) {
                this.fIntermediaryFirstParameterType = this.getExpressionType(this.fSelectionMethodInvocation);
                IMember enclosing = this.getEnclosingInitialSelectionMember();
                result.merge(this.updateMethodInvocation(this.fSelectionMethodInvocation, enclosing, this.getCachedCURewrite(this.fSelectionCompilationUnit)));
                if (!this.isRewriteKept(this.fSelectionCompilationUnit)) {
                    this.createChangeAndDiscardRewrite(this.fSelectionCompilationUnit);
                }
                result.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, enclosing.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(pm, 0)));
            }
            pm.worked(referenceTicks);
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fIntermediaryFirstParameterType == null) {
            this.fIntermediaryFirstParameterType = this.fTargetMethodBinding.getDeclaringClass();
        }
        IType actualTargetType = (IType)this.fIntermediaryFirstParameterType.getJavaElement();
        if (!this.fTargetMethod.getDeclaringType().equals(actualTargetType)) {
            IMethod actualTargetMethod;
            this.fTargetMethod = actualTargetMethod = new MethodOverrideTester(actualTargetType, actualTargetType.newSupertypeHierarchy(null)).findOverriddenMethodInHierarchy(actualTargetType, this.fTargetMethod);
            this.fTargetMethodBinding = this.findMethodBindingInHierarchy(this.fIntermediaryFirstParameterType, actualTargetMethod);
            Assert.isNotNull(this.fTargetMethodBinding);
        }
        result.merge(this.checkCanCreateIntermediaryMethod());
        this.createIntermediaryMethod();
        pm.worked(creationTicks);
        pm.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_adjusting_visibility);
        result.merge(this.updateTargetVisibility(new NoOverrideProgressMonitor(pm, 0)));
        result.merge(this.updateIntermediaryVisibility(new NoOverrideProgressMonitor(pm, 0)));
        pm.worked(visibilityTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        this.createChangeAndDiscardRewrite(this.fIntermediaryClass.getCompilationUnit());
        result.merge(Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext()));
        pm.done();
        return result;
    }

    private RefactoringStatus updateTargetVisibility(IProgressMonitor monitor) throws JavaModelException, CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.adjustVisibility((IMember)((IType)this.fIntermediaryFirstParameterType.getJavaElement()), this.fIntermediaryClass, monitor));
        if (result.hasError()) {
            return result;
        }
        Modifier.ModifierKeyword neededVisibility = this.getNeededVisibility(this.fTargetMethod, this.fIntermediaryClass);
        if (neededVisibility != null) {
            result.merge(this.adjustVisibility((IMember)this.fTargetMethod, neededVisibility, monitor));
            if (result.hasError()) {
                return result;
            }
            ITypeHierarchy hierarchy = this.fTargetMethod.getDeclaringType().newTypeHierarchy(null);
            MethodOverrideTester tester = new MethodOverrideTester(this.fTargetMethod.getDeclaringType(), hierarchy);
            IType[] subtypes = hierarchy.getAllSubtypes(this.fTargetMethod.getDeclaringType());
            int i = 0;
            while (i < subtypes.length) {
                IMethod method = tester.findOverridingMethodInType(subtypes[i], this.fTargetMethod);
                if (method != null && method.exists()) {
                    result.merge(this.adjustVisibility((IMember)method, neededVisibility, monitor));
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (result.hasError()) {
                        return result;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private RefactoringStatus updateIntermediaryVisibility(NoOverrideProgressMonitor monitor) throws JavaModelException {
        return this.rewriteVisibility(this.fIntermediaryAdjustments, this.fRewrites, monitor);
    }

    private RefactoringStatus updateReferences(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask("", 90);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IMethod[] ripple = RippleMethodFinder2.getRelatedMethods(this.fTargetMethod, false, (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 10), null);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SearchResultGroup[] references = Checks.excludeCompilationUnits(this.getReferences(ripple, new NoOverrideProgressMonitor(monitor, 10), result), result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(references));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int ticksPerCU = references.length == 0 ? 0 : 70 / references.length;
        int i = 0;
        while (i < references.length) {
            SearchResultGroup group = references[i];
            SearchMatch[] searchResults = group.getSearchResults();
            CompilationUnitRewrite currentCURewrite = this.getCachedCURewrite(group.getCompilationUnit());
            int j = 0;
            while (j < searchResults.length) {
                SearchMatch match = searchResults[j];
                if (!match.isInsideDocComment()) {
                    IMember enclosingMember = (IMember)match.getElement();
                    ASTNode target = IntroduceIndirectionRefactoring.getSelectedNode(group.getCompilationUnit(), currentCURewrite.getRoot(), match.getOffset(), match.getLength());
                    if (target instanceof SuperMethodInvocation) {
                        result.merge(this.createWarningAboutCall(enclosingMember, target, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_super_keyword));
                    } else {
                        Assert.isTrue(target instanceof MethodInvocation, "Element of call should be a MethodInvocation.");
                        MethodInvocation invocation = (MethodInvocation)target;
                        ITypeBinding typeBinding = this.getExpressionType(invocation);
                        if (this.fIntermediaryFirstParameterType == null) {
                            this.fIntermediaryFirstParameterType = typeBinding.getTypeDeclaration();
                        } else {
                            result.merge(this.findCommonParent(typeBinding.getTypeDeclaration()));
                        }
                        if (result.hasFatalError()) {
                            return result;
                        }
                        result.merge(this.updateMethodInvocation(invocation, enclosingMember, currentCURewrite));
                        result.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, enclosingMember.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 0)));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                ++j;
            }
            if (!this.isRewriteKept(group.getCompilationUnit())) {
                this.createChangeAndDiscardRewrite(group.getCompilationUnit());
            }
            monitor.worked(ticksPerCU);
            ++i;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus findCommonParent(ITypeBinding typeBinding) {
        RefactoringStatus status = new RefactoringStatus();
        ITypeBinding current = typeBinding;
        ITypeBinding highest = this.fIntermediaryFirstParameterType;
        if (current.equals(highest) || Bindings.isSuperType(highest, current)) {
            return status;
        }
        ITypeBinding[] currentAndSupers = this.getTypeAndAllSuperTypes(current);
        ITypeBinding[] highestAndSupers = this.getTypeAndAllSuperTypes(highest);
        ITypeBinding foundBinding = null;
        int i1 = 0;
        while (i1 < currentAndSupers.length) {
            int i2 = 0;
            while (i2 < highestAndSupers.length) {
                if (highestAndSupers[i2].isEqualTo(currentAndSupers[i1]) && Bindings.findMethodInHierarchy(highestAndSupers[i2], this.fTargetMethodBinding.getName(), this.fTargetMethodBinding.getParameterTypes()) != null) {
                    foundBinding = highestAndSupers[i2];
                    break;
                }
                ++i2;
            }
            if (foundBinding != null) break;
            ++i1;
        }
        if (foundBinding != null) {
            this.fIntermediaryFirstParameterType = foundBinding;
        } else {
            String type1 = BasicElementLabels.getJavaElementName(this.fIntermediaryFirstParameterType.getQualifiedName());
            String type2 = BasicElementLabels.getJavaElementName(current.getQualifiedName());
            status.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_open_hierarchy_error, new String[]{type1, type2}));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fTargetMethod.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589830;
        IType declaring = this.fTargetMethod.getDeclaringType();
        try {
            if (declaring.isLocal() || declaring.isAnonymous()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTargetMethod.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description, new String[]{JavaElementLabels.getTextLabel(this.fTargetMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(declaring, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_original_pattern, JavaElementLabels.getTextLabel(this.fTargetMethod, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_method_pattern, BasicElementLabels.getJavaElementName(this.fIntermediaryMethodName)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_declaring_pattern, JavaElementLabels.getTextLabel(this.fIntermediaryClass, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fUpdateReferences) {
            comment.addSetting(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        IntroduceIndirectionDescriptor descriptor = RefactoringSignatureDescriptorFactory.createIntroduceIndirectionDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, this.fTargetMethod));
        arguments.put("name", this.fIntermediaryMethodName);
        arguments.put("element1", JavaRefactoringDescriptorUtil.elementToHandle(project, this.fIntermediaryClass));
        arguments.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
        return new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection, (Change[])this.fTextChangeManager.getAllChanges());
    }

    private RefactoringStatus checkCanCreateIntermediaryMethod() throws JavaModelException {
        ArrayList<ITypeBinding> parameterBindings = new ArrayList<ITypeBinding>();
        if (!this.isStaticTarget()) {
            parameterBindings.add(this.fIntermediaryFirstParameterType);
        }
        parameterBindings.addAll(Arrays.asList(this.fTargetMethodBinding.getParameterTypes()));
        return Checks.checkMethodInType(this.fIntermediaryClassBinding, this.fIntermediaryMethodName, parameterBindings.toArray(new ITypeBinding[parameterBindings.size()]));
    }

    private void createIntermediaryMethod() throws CoreException {
        String comment;
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getCompilationUnit());
        AST ast = imRewrite.getAST();
        MethodDeclaration intermediary = ast.newMethodDeclaration();
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)this.typeToDeclaration(this.fIntermediaryClass, imRewrite.getRoot());
        intermediary.setName(ast.newSimpleName(this.fIntermediaryMethodName));
        List modifiers = intermediary.modifiers();
        modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        String targetParameterName = StubUtility.suggestArgumentName(this.getProject(), this.fIntermediaryFirstParameterType.getName(), this.fTargetMethod.getParameterNames());
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(type, imRewrite.getImportRewrite());
        if (!this.isStaticTarget()) {
            SingleVariableDeclaration parameter = imRewrite.getAST().newSingleVariableDeclaration();
            Type t = imRewrite.getImportRewrite().addImport(this.fIntermediaryFirstParameterType, imRewrite.getAST(), context);
            if (this.fIntermediaryFirstParameterType.isGenericType()) {
                ParameterizedType parameterized = imRewrite.getAST().newParameterizedType(t);
                ITypeBinding[] typeParameters = this.fIntermediaryFirstParameterType.getTypeParameters();
                int i = 0;
                while (i < typeParameters.length) {
                    parameterized.typeArguments().add(imRewrite.getImportRewrite().addImport(typeParameters[i], imRewrite.getAST()));
                    ++i;
                }
                t = parameterized;
            }
            parameter.setType(t);
            parameter.setName(imRewrite.getAST().newSimpleName(targetParameterName));
            intermediary.parameters().add(parameter);
        }
        this.copyArguments(intermediary, imRewrite);
        if (!this.isStaticTarget() && this.fIntermediaryFirstParameterType.isGenericType()) {
            this.addTypeParameters(imRewrite, intermediary.typeParameters(), this.fIntermediaryFirstParameterType);
        }
        this.copyTypeParameters(intermediary, imRewrite);
        intermediary.setReturnType2(imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getReturnType(), ast, context));
        this.copyExceptions(intermediary, imRewrite);
        MethodInvocation invocation = imRewrite.getAST().newMethodInvocation();
        invocation.setName(imRewrite.getAST().newSimpleName(this.fTargetMethod.getElementName()));
        if (this.isStaticTarget()) {
            Type importedType = imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getDeclaringClass(), ast, context);
            invocation.setExpression(ASTNodeFactory.newName(ast, ASTNodes.asString(importedType)));
        } else {
            invocation.setExpression(imRewrite.getAST().newSimpleName(targetParameterName));
        }
        this.copyInvocationParameters(invocation, ast);
        Statement call = this.encapsulateInvocation(intermediary, invocation);
        Block body = imRewrite.getAST().newBlock();
        body.statements().add(call);
        intermediary.setBody(body);
        ICompilationUnit targetCU = imRewrite.getCu();
        if (StubUtility.doAddComments(targetCU.getJavaProject()) && (comment = CodeGeneration.getMethodComment(targetCU, this.getIntermediaryClassName(), intermediary, null, StubUtility.getLineDelimiterUsed(targetCU))) != null) {
            Javadoc javadoc = (Javadoc)imRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            intermediary.setJavadoc(javadoc);
        }
        ChildListPropertyDescriptor typeBodyDeclarationsProperty = this.typeToBodyDeclarationProperty(this.fIntermediaryClass, imRewrite.getRoot());
        ListRewrite bodyDeclarationsListRewrite = imRewrite.getASTRewrite().getListRewrite(type, typeBodyDeclarationsProperty);
        bodyDeclarationsListRewrite.insertAt(intermediary, ASTNodes.getInsertionIndex(intermediary, type.bodyDeclarations()), imRewrite.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_create_new_method));
    }

    private void addTypeParameters(CompilationUnitRewrite imRewrite, List<TypeParameter> list, ITypeBinding parent) {
        ITypeBinding enclosing = parent.getDeclaringClass();
        if (enclosing != null) {
            this.addTypeParameters(imRewrite, list, enclosing);
        }
        ITypeBinding[] typeParameters = parent.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            TypeParameter ntp = imRewrite.getAST().newTypeParameter();
            ntp.setName(imRewrite.getAST().newSimpleName(typeParameters[i].getName()));
            ITypeBinding[] bounds = typeParameters[i].getTypeBounds();
            int j = 0;
            while (j < bounds.length) {
                if (!"java.lang.Object".equals(bounds[j].getQualifiedName())) {
                    ntp.typeBounds().add(imRewrite.getImportRewrite().addImport(bounds[j], imRewrite.getAST()));
                }
                ++j;
            }
            list.add(ntp);
            ++i;
        }
    }

    private Statement encapsulateInvocation(MethodDeclaration declaration, MethodInvocation invocation) {
        Type type = declaration.getReturnType2();
        if (type == null || type instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode())) {
            return invocation.getAST().newExpressionStatement(invocation);
        }
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression(invocation);
        return statement;
    }

    private void copyInvocationParameters(MethodInvocation invocation, AST ast) throws JavaModelException {
        String[] names = this.fTargetMethod.getParameterNames();
        int i = 0;
        while (i < names.length) {
            invocation.arguments().add(ast.newSimpleName(names[i]));
            ++i;
        }
    }

    private void copyArguments(MethodDeclaration intermediary, CompilationUnitRewrite rew) throws JavaModelException {
        String[] names = this.fTargetMethod.getParameterNames();
        ITypeBinding[] types = this.fTargetMethodBinding.getParameterTypes();
        int i = 0;
        while (i < names.length) {
            ITypeBinding typeBinding = types[i];
            SingleVariableDeclaration newElement = rew.getAST().newSingleVariableDeclaration();
            newElement.setName(rew.getAST().newSimpleName(names[i]));
            if (i == names.length - 1 && this.fTargetMethodBinding.isVarargs()) {
                newElement.setVarargs(true);
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getComponentType();
                }
            }
            newElement.setType(rew.getImportRewrite().addImport(typeBinding, rew.getAST()));
            intermediary.parameters().add(newElement);
            ++i;
        }
    }

    private void copyTypeParameters(MethodDeclaration intermediary, CompilationUnitRewrite rew) {
        ITypeBinding[] typeParameters = this.fTargetMethodBinding.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            ITypeBinding current = typeParameters[i];
            TypeParameter parameter = rew.getAST().newTypeParameter();
            parameter.setName(rew.getAST().newSimpleName(current.getName()));
            ITypeBinding[] bounds = current.getTypeBounds();
            int j = 0;
            while (j < bounds.length) {
                if (!"java.lang.Object".equals(bounds[j].getQualifiedName())) {
                    parameter.typeBounds().add(rew.getImportRewrite().addImport(bounds[j], rew.getAST()));
                }
                ++j;
            }
            intermediary.typeParameters().add(parameter);
            ++i;
        }
    }

    private void copyExceptions(MethodDeclaration intermediary, CompilationUnitRewrite imRewrite) {
        ITypeBinding[] exceptionTypes = this.fTargetMethodBinding.getExceptionTypes();
        int i = 0;
        while (i < exceptionTypes.length) {
            String qualifiedName = imRewrite.getImportRewrite().addImport(exceptionTypes[i]);
            intermediary.thrownExceptions().add(ASTNodeFactory.newName(imRewrite.getAST(), qualifiedName));
            ++i;
        }
    }

    private RefactoringStatus updateMethodInvocation(MethodInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        if (originalInvocation.typeArguments().size() > 0) {
            return this.createWarningAboutCall(enclosing, originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_type_arguments);
        }
        MethodInvocation newInvocation = unitRewriter.getAST().newMethodInvocation();
        List newInvocationArgs = newInvocation.arguments();
        List originalInvocationArgs = originalInvocation.arguments();
        String qualifier = unitRewriter.getImportRewrite().addImport(this.fIntermediaryClassBinding);
        newInvocation.setExpression(ASTNodeFactory.newName(unitRewriter.getAST(), qualifier));
        newInvocation.setName(unitRewriter.getAST().newSimpleName(this.getIntermediaryMethodName()));
        Expression expression = originalInvocation.getExpression();
        if (!this.isStaticTarget()) {
            if (expression == null) {
                ThisExpression expr = unitRewriter.getAST().newThisExpression();
                RefactoringStatus qualifierStatus = this.qualifyThisExpression(expr, originalInvocation, enclosing, unitRewriter);
                status.merge(qualifierStatus);
                if (qualifierStatus.hasEntries()) {
                    return status;
                }
                newInvocationArgs.add(expr);
            } else {
                Expression expressionAsParam = (Expression)unitRewriter.getASTRewrite().createMoveTarget(expression);
                newInvocationArgs.add(expressionAsParam);
            }
        } else if (!(expression == null || expression instanceof Name && ASTNodes.getTypeBinding((Name)expression) != null)) {
            return this.createWarningAboutCall(enclosing, originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_static_expression_access);
        }
        int i = 0;
        while (i < originalInvocationArgs.size()) {
            Expression originalInvocationArg = (Expression)originalInvocationArgs.get(i);
            Expression movedArg = (Expression)unitRewriter.getASTRewrite().createMoveTarget(originalInvocationArg);
            newInvocationArgs.add(movedArg);
            ++i;
        }
        unitRewriter.getASTRewrite().replace(originalInvocation, newInvocation, unitRewriter.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_replace_call));
        return status;
    }

    private RefactoringStatus qualifyThisExpression(ThisExpression expr, MethodInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) {
        RefactoringStatus status = new RefactoringStatus();
        IMethodBinding methodBinding = originalInvocation.resolveMethodBinding();
        MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.findDeclaration(methodBinding, originalInvocation.getRoot());
        ITypeBinding currentTypeBinding = null;
        if (methodDeclaration != null) {
            currentTypeBinding = ASTNodes.isParent(originalInvocation, methodDeclaration.getParent()) ? methodBinding.getDeclaringClass() : ASTNodes.getEnclosingType(originalInvocation);
        } else {
            ASTNode currentTypeDeclaration = this.getEnclosingTypeDeclaration(originalInvocation);
            currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            while (currentTypeDeclaration != null && Bindings.findMethodInHierarchy(currentTypeBinding, methodBinding.getName(), methodBinding.getParameterTypes()) == null) {
                currentTypeDeclaration = this.getEnclosingTypeDeclaration(currentTypeDeclaration.getParent());
                currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            }
        }
        if (currentTypeBinding == null) {
            status.merge(this.createWarningAboutCall(enclosing, originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_declaring_type_not_found));
            return status;
        }
        currentTypeBinding = currentTypeBinding.getTypeDeclaration();
        ITypeBinding typeOfCall = ASTNodes.getEnclosingType(originalInvocation);
        if (!typeOfCall.equals(currentTypeBinding)) {
            if (currentTypeBinding.isAnonymous()) {
                status.merge(this.createWarningAboutCall(enclosing, originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_anonymous_cannot_qualify));
            } else {
                expr.setQualifier(unitRewriter.getAST().newSimpleName(currentTypeBinding.getName()));
            }
        }
        return status;
    }

    private IMethodBinding findMethodBindingInHierarchy(ITypeBinding currentTypeBinding, IMethod methodDeclaration) {
        IMethodBinding b;
        IMethodBinding[] bindings = currentTypeBinding.getDeclaredMethods();
        int i = 0;
        while (i < bindings.length) {
            if (methodDeclaration.equals(bindings[i].getJavaElement())) {
                return bindings[i];
            }
            ++i;
        }
        ITypeBinding superClass = currentTypeBinding.getSuperclass();
        if (superClass != null && (b = this.findMethodBindingInHierarchy(superClass, methodDeclaration)) != null) {
            return b;
        }
        ITypeBinding[] interfaces = currentTypeBinding.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            IMethodBinding b2 = this.findMethodBindingInHierarchy(interfaces[i2], methodDeclaration);
            if (b2 != null) {
                return b2;
            }
            ++i2;
        }
        return null;
    }

    private ITypeBinding[] getTypeAndAllSuperTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        this.collectSuperTypes(type, result);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void collectSuperTypes(ITypeBinding curr, List<ITypeBinding> list) {
        if (list.add(curr.getTypeDeclaration())) {
            ITypeBinding[] interfaces = curr.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                this.collectSuperTypes(interfaces[i], list);
                ++i;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                this.collectSuperTypes(superClass, list);
            }
        }
    }

    private CompilationUnitRewrite getCachedCURewrite(ICompilationUnit unit) {
        CompilationUnitRewrite rewrite = this.fRewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            this.fRewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private boolean isRewriteKept(ICompilationUnit compilationUnit) {
        return this.fIntermediaryClass.getCompilationUnit().equals(compilationUnit);
    }

    private void createChangeAndDiscardRewrite(ICompilationUnit compilationUnit) throws CoreException {
        CompilationUnitRewrite rewrite = this.fRewrites.get(compilationUnit);
        if (rewrite != null) {
            this.fTextChangeManager.manage(compilationUnit, (TextChange)rewrite.createChange(true));
            this.fRewrites.remove(compilationUnit);
        }
    }

    private SearchResultGroup[] getReferences(IMethod[] methods, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern(methods, 2);
        IJavaSearchScope scope = RefactoringScopeFactory.create(this.fIntermediaryClass, false);
        return RefactoringSearchEngine.search(pattern, scope, pm, status);
    }

    private ITypeBinding typeToBinding(IType type, CompilationUnit root) throws JavaModelException {
        ASTNode typeNode = this.typeToDeclaration(type, root);
        if (type.isAnonymous()) {
            return ((AnonymousClassDeclaration)typeNode).resolveBinding();
        }
        return ((AbstractTypeDeclaration)typeNode).resolveBinding();
    }

    private ASTNode typeToDeclaration(IType type, CompilationUnit root) throws JavaModelException {
        Name intermediateName = (Name)NodeFinder.perform(root, type.getNameRange());
        if (type.isAnonymous()) {
            return ASTNodes.getParent((ASTNode)intermediateName, AnonymousClassDeclaration.class);
        }
        return ASTNodes.getParent((ASTNode)intermediateName, AbstractTypeDeclaration.class);
    }

    private ASTNode getEnclosingTypeDeclaration(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return node;
            }
            if (node instanceof AnonymousClassDeclaration) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType type, CompilationUnit root) throws JavaModelException {
        ASTNode typeDeclaration = this.typeToDeclaration(type, root);
        if (typeDeclaration instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)typeDeclaration).getBodyDeclarationsProperty();
        }
        if (typeDeclaration instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue(false);
        return null;
    }

    private RefactoringStatus createWarningAboutCall(IMember enclosing, ASTNode concreteNode, String message) {
        String name = JavaElementLabels.getElementLabel(enclosing, JavaElementLabels.ALL_DEFAULT);
        String container = JavaElementLabels.getElementLabel(enclosing.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED);
        return RefactoringStatus.createWarningStatus((String)Messages.format(message, new String[]{name, container}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)enclosing.getCompilationUnit(), concreteNode));
    }

    private ITypeBinding getExpressionType(MethodInvocation invocation) {
        Expression expression = invocation.getExpression();
        ITypeBinding typeBinding = null;
        typeBinding = expression == null ? invocation.resolveMethodBinding().getDeclaringClass() : expression.resolveTypeBinding();
        Assert.isNotNull(typeBinding, "Type binding of target expression may not be null");
        return typeBinding;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<ICompilationUnit> cus = new ArrayList<ICompilationUnit>();
        cus.addAll(Arrays.asList(this.fTextChangeManager.getAllCompilationUnits()));
        return ResourceUtil.getFiles(cus.toArray(new ICompilationUnit[cus.size()]));
    }

    private boolean isStaticTarget() throws JavaModelException {
        return Flags.isStatic(this.fTargetMethod.getFlags());
    }

    private IMember getEnclosingInitialSelectionMember() throws JavaModelException {
        return (IMember)this.fSelectionCompilationUnit.getElementAt(this.fSelectionStart);
    }

    private static ASTNode getSelectedNode(ICompilationUnit unit, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = unit != null ? IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform(root, offset, length, unit)) : IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform(root, offset, length));
        }
        catch (JavaModelException javaModelException) {}
        if (node != null) {
            return node;
        }
        return IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform(root, offset, length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return node;
            }
        }
        return null;
    }

    private Modifier.ModifierKeyword getNeededVisibility(IMember whoToAdjust, IMember fromWhereToLook) throws JavaModelException {
        return this.fAdjustor.getVisibilityThreshold(fromWhereToLook, whoToAdjust, new NullProgressMonitor());
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, IMember fromWhereToLook, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, this.getNeededVisibility(whoToAdjust, fromWhereToLook), true, monitor);
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, neededVisibility, false, monitor);
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, boolean alsoIncreaseEnclosing, IProgressMonitor monitor) throws CoreException {
        boolean hasNewAdjustments;
        Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments = this.isRewriteKept(whoToAdjust.getCompilationUnit()) ? this.fIntermediaryAdjustments : new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
        int existingAdjustments = adjustments.size();
        this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
        if (alsoIncreaseEnclosing) {
            while (whoToAdjust.getDeclaringType() != null) {
                whoToAdjust = whoToAdjust.getDeclaringType();
                this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
            }
        }
        boolean bl = hasNewAdjustments = adjustments.size() - existingAdjustments > 0;
        if (hasNewAdjustments && (whoToAdjust.isReadOnly() || whoToAdjust.isBinary())) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_update_binary_target_visibility, new String[]{JavaElementLabels.getElementLabel(whoToAdjust, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust));
        }
        RefactoringStatus status = new RefactoringStatus();
        if (!hasNewAdjustments) {
            return status;
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting, 2);
            if (!this.isRewriteKept(whoToAdjust.getCompilationUnit())) {
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(whoToAdjust.getCompilationUnit());
                rewrite.setResolveBindings(false);
                HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
                rewrites.put(whoToAdjust.getCompilationUnit(), rewrite);
                status.merge(this.rewriteVisibility(adjustments, rewrites, new SubProgressMonitor(monitor, 1, 2)));
                rewrite.attachChange((CompilationUnitChange)this.fTextChangeManager.get(whoToAdjust.getCompilationUnit()), true, new SubProgressMonitor(monitor, 1, 2));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus rewriteVisibility(Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        this.fAdjustor.setRewrites(rewrites);
        this.fAdjustor.setAdjustments(adjustments);
        this.fAdjustor.setStatus(status);
        this.fAdjustor.rewriteVisibility(monitor);
        return status;
    }

    private void addAdjustment(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments) throws JavaModelException {
        Modifier.ModifierKeyword currentVisibility = Modifier.ModifierKeyword.fromFlagValue(JdtFlags.getVisibilityCode(whoToAdjust));
        if (MemberVisibilityAdjustor.hasLowerVisibility(currentVisibility, neededVisibility) && MemberVisibilityAdjustor.needsVisibilityAdjustments(whoToAdjust, neededVisibility, adjustments)) {
            adjustments.put(whoToAdjust, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(whoToAdjust, neededVisibility, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(whoToAdjust), new String[]{MemberVisibilityAdjustor.getLabel(whoToAdjust), MemberVisibilityAdjustor.getLabel(neededVisibility)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust))));
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 9) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.indirection");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fTargetMethod = (IMethod)element;
        handle = arguments.getAttribute("element1");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.indirection");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
        }
        this.fIntermediaryClass = (IType)element;
        String references = arguments.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String name = arguments.getAttribute("name");
        if (name != null && !"".equals(name)) {
            return this.setIntermediaryMethodName(name);
        }
        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }
}

