/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.BlockFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.BranchFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ConditionalFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.IfFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.LocalFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.MessageSendFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ReturnFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.SwitchFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.ThrowFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.TryFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.TypeVariableFlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.WhileFlowInfo;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FlowAnalyzer
extends GenericVisitor {
    private HashMap<ASTNode, FlowInfo> fData = new HashMap(100);
    FlowContext fFlowContext = null;

    public FlowAnalyzer(FlowContext context) {
        this.fFlowContext = context;
    }

    protected abstract boolean createReturnFlowInfo(ReturnStatement var1);

    protected abstract boolean traverseNode(ASTNode var1);

    protected boolean skipNode(ASTNode node) {
        return !this.traverseNode(node);
    }

    @Override
    protected final boolean visitNode(ASTNode node) {
        return this.traverseNode(node);
    }

    protected ReturnFlowInfo createReturn(ReturnStatement statement) {
        return new ReturnFlowInfo(statement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(SimpleName label) {
        return new BranchFlowInfo(label, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected EnhancedForFlowInfo createEnhancedFor() {
        return new EnhancedForFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected MessageSendFlowInfo createMessageSendFlowInfo() {
        return new MessageSendFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(ASTNode node) {
        return this.fData.remove(node);
    }

    protected void setFlowInfo(ASTNode node, FlowInfo info) {
        this.fData.put(node, info);
    }

    protected FlowInfo assignFlowInfo(ASTNode target, ASTNode source) {
        FlowInfo result = this.getFlowInfo(source);
        this.setFlowInfo(target, result);
        return result;
    }

    protected FlowInfo accessFlowInfo(ASTNode node) {
        return this.fData.get(node);
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, List<? extends ASTNode> nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1, ASTNode node2) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            result.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(ASTNode parent) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.setFlowInfo(parent, result);
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(List<? extends ASTNode> nodes) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.process(result, nodes);
        return result;
    }

    protected void process(GenericSequentialFlowInfo info, List<? extends ASTNode> nodes) {
        if (nodes == null) {
            return;
        }
        Iterator<? extends ASTNode> iter = nodes.iterator();
        while (iter.hasNext()) {
            info.merge(this.getFlowInfo(iter.next()), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node) {
        if (node != null) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node1, ASTNode node2) {
        if (node1 != null) {
            info.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            info.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
    }

    @Override
    public boolean visit(EmptyStatement node) {
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        if (this.traverseNode(node)) {
            this.fFlowContext.pushExcptions(node);
            node.getBody().accept(this);
            this.fFlowContext.popExceptions();
            List catchClauses = node.catchClauses();
            Iterator iter = catchClauses.iterator();
            while (iter.hasNext()) {
                ((CatchClause)iter.next()).accept(this);
            }
            Block finallyBlock = node.getFinally();
            if (finallyBlock != null) {
                finallyBlock.accept(this);
            }
        }
        return false;
    }

    protected SwitchData createSwitchData(SwitchStatement node) {
        SwitchData result = new SwitchData();
        List statements = node.statements();
        if (statements.isEmpty()) {
            return result;
        }
        int start = -1;
        int end = -1;
        GenericSequentialFlowInfo info = null;
        for (Statement statement : statements) {
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (switchCase.isDefault()) {
                    result.setHasDefaultCase();
                }
                if (info == null) {
                    info = this.createSequential();
                    start = statement.getStartPosition();
                } else if (info.isReturn() || info.isPartialReturn() || info.branches()) {
                    result.add((IRegion)new Region(start, end - start + 1), info);
                    info = this.createSequential();
                    start = statement.getStartPosition();
                }
            } else {
                info.merge(this.getFlowInfo(statement), this.fFlowContext);
            }
            end = statement.getStartPosition() + statement.getLength() - 1;
        }
        result.add((IRegion)new Region(start, end - start + 1), info);
        return result;
    }

    protected void endVisit(SwitchStatement node, SwitchData data) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo(node, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        FlowInfo[] cases = data.getInfos();
        int i = 0;
        while (i < cases.length) {
            switchFlowInfo.mergeCase(cases[i], this.fFlowContext);
            ++i;
        }
        switchFlowInfo.mergeDefault(data.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
    }

    @Override
    public void endVisit(AnnotationTypeDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.bodyDeclarations());
        info.setNoReturn();
    }

    @Override
    public void endVisit(AnnotationTypeMemberDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential(node, node.getType(), node.getDefault());
        info.setNoReturn();
    }

    @Override
    public void endVisit(AnonymousClassDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.bodyDeclarations());
        info.setNoReturn();
    }

    @Override
    public void endVisit(ArrayAccess node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getArray(), node.getIndex());
    }

    @Override
    public void endVisit(ArrayCreation node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getType());
        this.process(info, node.dimensions());
        this.process(info, node.getInitializer());
    }

    @Override
    public void endVisit(ArrayInitializer node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    @Override
    public void endVisit(ArrayType node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.getElementType());
    }

    @Override
    public void endVisit(AssertStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        IfFlowInfo info = new IfFlowInfo();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo(node.getMessage()), null, this.fFlowContext);
    }

    @Override
    public void endVisit(Assignment node) {
        if (this.skipNode(node)) {
            return;
        }
        FlowInfo lhs = this.getFlowInfo(node.getLeftHandSide());
        FlowInfo rhs = this.getFlowInfo(node.getRightHandSide());
        if (lhs instanceof LocalFlowInfo) {
            LocalFlowInfo llhs = (LocalFlowInfo)lhs;
            llhs.setWriteAccess(this.fFlowContext);
            if (node.getOperator() != Assignment.Operator.ASSIGN) {
                GenericSequentialFlowInfo tmp = this.createSequential();
                tmp.merge(new LocalFlowInfo(llhs, 2, this.fFlowContext), this.fFlowContext);
                tmp.merge(rhs, this.fFlowContext);
                rhs = tmp;
            }
        }
        GenericSequentialFlowInfo info = this.createSequential(node);
        info.merge(rhs, this.fFlowContext);
        info.merge(lhs, this.fFlowContext);
    }

    @Override
    public void endVisit(Block node) {
        if (this.skipNode(node)) {
            return;
        }
        BlockFlowInfo info = this.createBlock();
        this.setFlowInfo(node, info);
        this.process((GenericSequentialFlowInfo)info, node.statements());
    }

    @Override
    public void endVisit(BooleanLiteral node) {
    }

    @Override
    public void endVisit(BreakStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        this.setFlowInfo(node, this.createBranch(node.getLabel()));
    }

    @Override
    public void endVisit(CastExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getType(), node.getExpression());
    }

    @Override
    public void endVisit(CatchClause node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getException(), node.getBody());
    }

    @Override
    public void endVisit(CharacterLiteral node) {
    }

    @Override
    public void endVisit(ClassInstanceCreation node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getExpression());
        this.process(info, node.getType());
        this.process(info, node.arguments());
        this.process(info, node.getAnonymousClassDeclaration());
    }

    @Override
    public void endVisit(CompilationUnit node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.imports());
        this.process(info, node.types());
    }

    @Override
    public void endVisit(ConditionalExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        ConditionalFlowInfo info = this.createConditional();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo(node.getThenExpression()), this.getFlowInfo(node.getElseExpression()), this.fFlowContext);
    }

    @Override
    public void endVisit(ConstructorInvocation node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.arguments());
    }

    @Override
    public void endVisit(ContinueStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        this.setFlowInfo(node, this.createBranch(node.getLabel()));
    }

    @Override
    public void endVisit(DoStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        DoWhileFlowInfo info = this.createDoWhile();
        this.setFlowInfo(node, info);
        info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        info.removeLabel(null);
    }

    @Override
    public void endVisit(EmptyStatement node) {
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        EnhancedForFlowInfo forInfo = this.createEnhancedFor();
        this.setFlowInfo(node, forInfo);
        forInfo.mergeParameter(this.getFlowInfo(node.getParameter()), this.fFlowContext);
        forInfo.mergeExpression(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    @Override
    public void endVisit(EnumConstantDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.arguments());
        this.process(info, node.getAnonymousClassDeclaration());
    }

    @Override
    public void endVisit(EnumDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.superInterfaceTypes());
        this.process(info, node.enumConstants());
        this.process(info, node.bodyDeclarations());
        info.setNoReturn();
    }

    @Override
    public void endVisit(ExpressionStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getExpression());
    }

    @Override
    public void endVisit(FieldAccess node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getExpression(), node.getName());
    }

    @Override
    public void endVisit(FieldDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getType());
        this.process(info, node.fragments());
    }

    @Override
    public void endVisit(ForStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        ForFlowInfo forInfo = this.createFor();
        this.setFlowInfo(node, forInfo);
        forInfo.mergeInitializer(this.createSequential(node.initializers()), this.fFlowContext);
        forInfo.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        forInfo.mergeIncrement(this.createSequential(node.updaters()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    @Override
    public void endVisit(IfStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        IfFlowInfo info = this.createIf();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo(node.getThenStatement()), this.getFlowInfo(node.getElseStatement()), this.fFlowContext);
    }

    @Override
    public void endVisit(ImportDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getName());
    }

    @Override
    public void endVisit(InfixExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential(node, node.getLeftOperand(), node.getRightOperand());
        this.process(info, node.extendedOperands());
    }

    @Override
    public void endVisit(InstanceofExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getLeftOperand(), node.getRightOperand());
    }

    @Override
    public void endVisit(Initializer node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getBody());
    }

    @Override
    public void endVisit(Javadoc node) {
    }

    @Override
    public void endVisit(LabeledStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        FlowInfo info = this.assignFlowInfo(node, node.getBody());
        if (info != null) {
            info.removeLabel(node.getLabel());
        }
    }

    @Override
    public void endVisit(MarkerAnnotation node) {
    }

    @Override
    public void endVisit(MemberValuePair node) {
        if (this.skipNode(node)) {
            return;
        }
        FlowInfo name = this.getFlowInfo(node.getName());
        FlowInfo value = this.getFlowInfo(node.getValue());
        if (name instanceof LocalFlowInfo) {
            LocalFlowInfo llhs = (LocalFlowInfo)name;
            llhs.setWriteAccess(this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.createSequential(node);
        info.merge(value, this.fFlowContext);
        info.merge(name, this.fFlowContext);
    }

    @Override
    public void endVisit(MethodDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getReturnType2());
        this.process(info, node.parameters());
        this.process(info, node.thrownExceptions());
        this.process(info, node.getBody());
    }

    @Override
    public void endVisit(MethodInvocation node) {
        this.endVisitMethodInvocation(node, node.getExpression(), node.arguments(), this.getMethodBinding(node.getName()));
    }

    @Override
    public void endVisit(NormalAnnotation node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getTypeName());
        this.process(info, node.values());
    }

    @Override
    public void endVisit(NullLiteral node) {
    }

    @Override
    public void endVisit(NumberLiteral node) {
    }

    @Override
    public void endVisit(PackageDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getName());
    }

    @Override
    public void endVisit(ParameterizedType node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getType());
        this.process(info, node.typeArguments());
    }

    @Override
    public void endVisit(ParenthesizedExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getExpression());
    }

    @Override
    public void endVisit(PostfixExpression node) {
        this.endVisitIncDecOperation(node, node.getOperand());
    }

    @Override
    public void endVisit(PrefixExpression node) {
        PrefixExpression.Operator op = node.getOperator();
        if (PrefixExpression.Operator.INCREMENT.equals(op) || PrefixExpression.Operator.DECREMENT.equals(op)) {
            this.endVisitIncDecOperation(node, node.getOperand());
        } else {
            this.assignFlowInfo(node, node.getOperand());
        }
    }

    @Override
    public void endVisit(PrimitiveType node) {
    }

    @Override
    public void endVisit(QualifiedName node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getQualifier(), node.getName());
    }

    @Override
    public void endVisit(QualifiedType node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getQualifier(), node.getName());
    }

    @Override
    public void endVisit(ReturnStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        if (this.createReturnFlowInfo(node)) {
            ReturnFlowInfo info = this.createReturn(node);
            this.setFlowInfo(node, info);
            info.merge(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        } else {
            this.assignFlowInfo(node, node.getExpression());
        }
    }

    @Override
    public void endVisit(SimpleName node) {
        ITypeBinding type;
        if (this.skipNode(node) || node.isDeclaration()) {
            return;
        }
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (!variable.isField()) {
                this.setFlowInfo(node, new LocalFlowInfo(variable, 2, this.fFlowContext));
            }
        } else if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isTypeVariable()) {
            this.setFlowInfo(node, new TypeVariableFlowInfo(type, this.fFlowContext));
        }
    }

    @Override
    public void endVisit(SimpleType node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getName());
    }

    @Override
    public void endVisit(SingleMemberAnnotation node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getValue());
    }

    @Override
    public void endVisit(SingleVariableDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        IVariableBinding binding = node.resolveBinding();
        LocalFlowInfo nameInfo = null;
        Expression initializer = node.getInitializer();
        if (binding != null && !binding.isField() && initializer != null) {
            nameInfo = new LocalFlowInfo(binding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.processSequential(node, node.getType(), initializer);
        info.merge(nameInfo, this.fFlowContext);
    }

    @Override
    public void endVisit(StringLiteral node) {
    }

    @Override
    public void endVisit(SuperConstructorInvocation node) {
        this.endVisitMethodInvocation(node, node.getExpression(), node.arguments(), node.resolveConstructorBinding());
    }

    @Override
    public void endVisit(SuperFieldAccess node) {
        if (this.skipNode(node)) {
            return;
        }
        this.processSequential(node, node.getQualifier(), node.getName());
    }

    @Override
    public void endVisit(SuperMethodInvocation node) {
        this.endVisitMethodInvocation(node, node.getQualifier(), node.arguments(), this.getMethodBinding(node.getName()));
    }

    @Override
    public void endVisit(SwitchCase node) {
        this.endVisitNode(node);
    }

    @Override
    public void endVisit(SwitchStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        this.endVisit(node, this.createSwitchData(node));
    }

    @Override
    public void endVisit(SynchronizedStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getExpression());
        this.process(info, node.getBody());
    }

    @Override
    public void endVisit(ThisExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getQualifier());
    }

    @Override
    public void endVisit(ThrowStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        ThrowFlowInfo info = this.createThrow();
        this.setFlowInfo(node, info);
        Expression expression = node.getExpression();
        info.merge(this.getFlowInfo(expression), this.fFlowContext);
        info.mergeException(expression.resolveTypeBinding(), this.fFlowContext);
    }

    @Override
    public void endVisit(TryStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        TryFlowInfo info = this.createTry();
        this.setFlowInfo(node, info);
        info.mergeTry(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.removeExceptions(node);
        for (CatchClause element : node.catchClauses()) {
            info.mergeCatch(this.getFlowInfo(element), this.fFlowContext);
        }
        info.mergeFinally(this.getFlowInfo(node.getFinally()), this.fFlowContext);
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getSuperclassType());
        this.process(info, node.superInterfaceTypes());
        this.process(info, node.bodyDeclarations());
        info.setNoReturn();
    }

    @Override
    public void endVisit(TypeDeclarationStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getDeclaration());
    }

    @Override
    public void endVisit(TypeLiteral node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getType());
    }

    @Override
    public void endVisit(TypeParameter node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getName());
        this.process(info, node.typeBounds());
    }

    @Override
    public void endVisit(VariableDeclarationExpression node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getType());
        this.process(info, node.fragments());
    }

    @Override
    public void endVisit(VariableDeclarationStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.getType());
        this.process(info, node.fragments());
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        if (this.skipNode(node)) {
            return;
        }
        IVariableBinding binding = node.resolveBinding();
        LocalFlowInfo nameInfo = null;
        Expression initializer = node.getInitializer();
        if (binding != null && !binding.isField() && initializer != null) {
            nameInfo = new LocalFlowInfo(binding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, initializer);
        info.merge(nameInfo, this.fFlowContext);
    }

    @Override
    public void endVisit(WhileStatement node) {
        if (this.skipNode(node)) {
            return;
        }
        WhileFlowInfo info = this.createWhile();
        this.setFlowInfo(node, info);
        info.mergeCondition(this.getFlowInfo(node.getExpression()), this.fFlowContext);
        info.mergeAction(this.getFlowInfo(node.getBody()), this.fFlowContext);
        info.removeLabel(null);
    }

    @Override
    public void endVisit(WildcardType node) {
        if (this.skipNode(node)) {
            return;
        }
        this.assignFlowInfo(node, node.getBound());
    }

    private void endVisitMethodInvocation(ASTNode node, ASTNode receiver, List<Expression> arguments, IMethodBinding binding) {
        if (this.skipNode(node)) {
            return;
        }
        MessageSendFlowInfo info = this.createMessageSendFlowInfo();
        this.setFlowInfo(node, info);
        for (Expression arg : arguments) {
            info.mergeArgument(this.getFlowInfo(arg), this.fFlowContext);
        }
        info.mergeReceiver(this.getFlowInfo(receiver), this.fFlowContext);
        info.mergeExceptions(binding, this.fFlowContext);
    }

    private void endVisitIncDecOperation(Expression node, Expression operand) {
        if (this.skipNode(node)) {
            return;
        }
        FlowInfo info = this.getFlowInfo(operand);
        if (info instanceof LocalFlowInfo) {
            GenericSequentialFlowInfo result = this.createSequential(node);
            result.merge(info, this.fFlowContext);
            result.merge(new LocalFlowInfo((LocalFlowInfo)info, 8, this.fFlowContext), this.fFlowContext);
        } else {
            this.setFlowInfo(node, info);
        }
    }

    private IMethodBinding getMethodBinding(Name name) {
        if (name == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private List<IRegion> fRanges = new ArrayList<IRegion>(4);
        private List<FlowInfo> fInfos = new ArrayList<FlowInfo>(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion range, FlowInfo info) {
            this.fRanges.add(range);
            this.fInfos.add(info);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int index) {
            return this.fInfos.get(index);
        }
    }
}

