/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;

public class NLSLine {
    private int fLineNumber;
    private List<NLSElement> fElements;

    public NLSLine(int lineNumber) {
        this.fLineNumber = lineNumber;
        Assert.isTrue(this.fLineNumber >= 0);
        this.fElements = new ArrayList<NLSElement>();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public void add(NLSElement element) {
        Assert.isNotNull(element);
        this.fElements.add(element);
    }

    public NLSElement[] getElements() {
        return this.fElements.toArray(new NLSElement[this.fElements.size()]);
    }

    public NLSElement get(int index) {
        return this.fElements.get(index);
    }

    public boolean exists(int index) {
        return index >= 0 && index < this.fElements.size();
    }

    public int size() {
        return this.fElements.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Line: " + this.fLineNumber + "\n");
        Iterator<NLSElement> iter = this.fElements.iterator();
        while (iter.hasNext()) {
            result.append("\t");
            result.append(iter.next().toString());
            result.append("\n");
        }
        return result.toString();
    }
}

