/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.CreateArguments;
import org.eclipse.ltk.core.refactoring.participants.CreateParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ResourceModifications {
    private List<IResource> fCreate;
    private List<IResource> fDelete;
    private List<IResource> fMove;
    private List<MoveArguments> fMoveArguments;
    private List<IResource> fRename;
    private List<RenameArguments> fRenameArguments;
    private List<IResource> fCopy;
    private List<CopyArguments> fCopyArguments;
    private int fIgnoreCount;
    private List<DeltaDescription> fDeltaDescriptions;

    public void addChanged(IFile file) {
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new ChangedDescription(file));
        }
    }

    public void addCreate(IResource create) {
        if (this.fCreate == null) {
            this.fCreate = new ArrayList<IResource>(2);
        }
        this.fCreate.add(create);
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new CreateDescription(create));
        }
    }

    public void addDelete(IResource delete) {
        if (this.fDelete == null) {
            this.fDelete = new ArrayList<IResource>(2);
        }
        this.fDelete.add(delete);
        if (this.fIgnoreCount == 0) {
            this.internalAdd(new DeleteDescription(delete));
        }
    }

    public void addMove(IResource move, MoveArguments arguments) {
        if (this.fMove == null) {
            this.fMove = new ArrayList<IResource>(2);
            this.fMoveArguments = new ArrayList<MoveArguments>(2);
        }
        this.fMove.add(move);
        this.fMoveArguments.add(arguments);
        if (this.fIgnoreCount == 0) {
            IPath destination = ((IResource)arguments.getDestination()).getFullPath().append(move.getName());
            this.internalAdd(new MoveDescription(move, destination));
        }
    }

    public void addCopy(IResource copy, CopyArguments arguments) {
        if (this.fCopy == null) {
            this.fCopy = new ArrayList<IResource>(2);
            this.fCopyArguments = new ArrayList<CopyArguments>(2);
        }
        this.fCopy.add(copy);
        this.fCopyArguments.add(arguments);
        this.addCopyDelta(copy, arguments);
    }

    public void addRename(IResource rename, RenameArguments arguments) {
        Assert.isNotNull(rename);
        Assert.isNotNull(arguments);
        if (this.fRename == null) {
            this.fRename = new ArrayList<IResource>(2);
            this.fRenameArguments = new ArrayList<RenameArguments>(2);
        }
        this.fRename.add(rename);
        this.fRenameArguments.add(arguments);
        if (this.fIgnoreCount == 0) {
            IPath newPath = rename.getFullPath().removeLastSegments(1).append(arguments.getNewName());
            this.internalAdd(new MoveDescription(rename, newPath));
        }
    }

    public RefactoringParticipant[] getParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) {
        MoveArguments arguments;
        IResource element;
        Iterator<IResource> iter;
        DeleteArguments arguments2;
        ArrayList<Object> result = new ArrayList<Object>(5);
        if (this.fDelete != null) {
            arguments2 = new DeleteArguments();
            iter = this.fDelete.iterator();
            while (iter.hasNext()) {
                DeleteParticipant[] deletes = ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)iter.next(), (DeleteArguments)arguments2, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(deletes));
            }
        }
        if (this.fCreate != null) {
            arguments2 = new CreateArguments();
            iter = this.fCreate.iterator();
            while (iter.hasNext()) {
                CreateParticipant[] creates = ParticipantManager.loadCreateParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)iter.next(), (CreateArguments)arguments2, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(creates));
            }
        }
        if (this.fMove != null) {
            int i = 0;
            while (i < this.fMove.size()) {
                element = this.fMove.get(i);
                arguments = this.fMoveArguments.get(i);
                MoveParticipant[] moves = ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)element, (MoveArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(moves));
                ++i;
            }
        }
        if (this.fCopy != null) {
            int i = 0;
            while (i < this.fCopy.size()) {
                element = this.fCopy.get(i);
                arguments = this.fCopyArguments.get(i);
                CopyParticipant[] copies = ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)element, (CopyArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(copies));
                ++i;
            }
        }
        if (this.fRename != null) {
            int i = 0;
            while (i < this.fRename.size()) {
                IResource resource = this.fRename.get(i);
                arguments = this.fRenameArguments.get(i);
                RenameParticipant[] renames = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)resource, (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(renames));
                ++i;
            }
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public void ignoreForDelta() {
        ++this.fIgnoreCount;
    }

    public void trackForDelta() {
        --this.fIgnoreCount;
    }

    public void addDelta(DeltaDescription description) {
        if (this.fIgnoreCount > 0) {
            return;
        }
        this.internalAdd(description);
    }

    public void addCopyDelta(IResource copy, CopyArguments arguments) {
        if (this.fIgnoreCount == 0) {
            IPath destination = ((IResource)arguments.getDestination()).getFullPath().append(copy.getName());
            this.internalAdd(new CopyDescription(copy, destination));
        }
    }

    public boolean willExist(IResource resource) {
        if (this.fDeltaDescriptions == null) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        for (DeltaDescription delta : this.fDeltaDescriptions) {
            if (!fullPath.equals(delta.getDestinationPath())) continue;
            return true;
        }
        return false;
    }

    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        if (this.fDeltaDescriptions == null) {
            return;
        }
        Iterator<DeltaDescription> iter = this.fDeltaDescriptions.iterator();
        while (iter.hasNext()) {
            iter.next().buildDelta(builder);
        }
    }

    public static void buildMoveDelta(IResourceChangeDescriptionFactory builder, IResource resource, RenameArguments args) {
        IPath newPath = resource.getFullPath().removeLastSegments(1).append(args.getNewName());
        new MoveDescription(resource, newPath).buildDelta(builder);
    }

    public static void buildMoveDelta(IResourceChangeDescriptionFactory builder, IResource resource, MoveArguments args) {
        IPath destination = ((IResource)args.getDestination()).getFullPath().append(resource.getName());
        new MoveDescription(resource, destination).buildDelta(builder);
    }

    public static void buildCopyDelta(IResourceChangeDescriptionFactory builder, IResource resource, CopyArguments args) {
        IPath destination = ((IResource)args.getDestination()).getFullPath().append(resource.getName());
        new CopyDescription(resource, destination).buildDelta(builder);
    }

    private void internalAdd(DeltaDescription description) {
        if (this.fDeltaDescriptions == null) {
            this.fDeltaDescriptions = new ArrayList<DeltaDescription>();
        }
        this.fDeltaDescriptions.add(description);
    }

    public static class ChangedDescription
    extends DeltaDescription {
        public ChangedDescription(IFile resource) {
            super(resource);
        }

        public void buildDelta(IResourceChangeDescriptionFactory builder) {
            builder.change((IFile)this.fResource);
        }

        public IPath getDestinationPath() {
            return null;
        }
    }

    public static class CopyDescription
    extends DeltaDescription {
        private IPath fDestination;

        public CopyDescription(IResource resource, IPath destination) {
            super(resource);
            this.fDestination = destination;
        }

        public void buildDelta(IResourceChangeDescriptionFactory builder) {
            IResource existing = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fDestination);
            if (existing != null && !existing.equals(this.fResource)) {
                builder.delete(existing);
            }
            builder.copy(this.fResource, this.fDestination);
        }

        public IPath getDestinationPath() {
            return this.fDestination;
        }
    }

    public static class CreateDescription
    extends DeltaDescription {
        public CreateDescription(IResource resource) {
            super(resource);
        }

        public void buildDelta(IResourceChangeDescriptionFactory builder) {
            builder.create(this.fResource);
        }

        public IPath getDestinationPath() {
            return this.fResource.getFullPath();
        }
    }

    public static class DeleteDescription
    extends DeltaDescription {
        public DeleteDescription(IResource resource) {
            super(resource);
        }

        public void buildDelta(IResourceChangeDescriptionFactory builder) {
            builder.delete(this.fResource);
        }

        public IPath getDestinationPath() {
            return null;
        }
    }

    public static abstract class DeltaDescription {
        protected IResource fResource;

        public DeltaDescription(IResource resource) {
            this.fResource = resource;
        }

        public abstract void buildDelta(IResourceChangeDescriptionFactory var1);

        public abstract IPath getDestinationPath();
    }

    public static class MoveDescription
    extends DeltaDescription {
        private IPath fDestination;

        public MoveDescription(IResource resource, IPath destination) {
            super(resource);
            this.fDestination = destination;
        }

        public void buildDelta(IResourceChangeDescriptionFactory builder) {
            IResource existing = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fDestination);
            if (existing != null && !existing.equals(this.fResource)) {
                builder.delete(existing);
            }
            builder.move(this.fResource, this.fDestination);
        }

        public IPath getDestinationPath() {
            return this.fDestination;
        }
    }
}

