/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public final class RenameSourceFolderProcessor
extends JavaRenameProcessor {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private IPackageFragmentRoot fSourceFolder;

    public RenameSourceFolderProcessor(IPackageFragmentRoot root) {
        this.fSourceFolder = root;
        if (root != null) {
            this.setNewElementName(root.getElementName());
        }
    }

    public RenameSourceFolderProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        status.merge(this.initialize(arguments));
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameSourceFolderProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fSourceFolder);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameSourceFolderRefactoring_rename;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures(this.fSourceFolder);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getElementName().equals(this.getNewElementName())) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public int getSaveMode() {
        return 2;
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fSourceFolder, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[0];
    }

    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        IPath p;
        Assert.isNotNull(newName, "new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_blank);
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_invalid_name);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaProject project = this.fSourceFolder.getJavaProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_already_exists);
        }
        if (project.getProject().findMember(new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_alread_exists);
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 1);
        try {
            IResource resource = this.fSourceFolder.getResource();
            String project = resource.getProject().getName();
            String newName = this.getNewElementName();
            String description = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description_short, JavaElementLabels.getElementLabel(this.fSourceFolder, JavaElementLabels.ALL_DEFAULT));
            String header = Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_descriptor_description, new String[]{BasicElementLabels.getPathLabel(resource.getFullPath(), false), BasicElementLabels.getJavaElementName(newName)});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.source.folder");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(0);
            descriptor.setJavaElement((IJavaElement)this.fSourceFolder);
            descriptor.setNewName(newName);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameSourceFolderRefactoring_rename, new Change[]{new RenameSourceFolderChange(this.fSourceFolder, newName)});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments generic) {
        IResource resource;
        String path = generic.getAttribute(ATTRIBUTE_PATH);
        if (path != null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(path));
            if (resource == null || !resource.exists()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(resource, this.getProcessorName(), "org.eclipse.jdt.ui.rename.source.folder");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
        }
        this.fSourceFolder = (IPackageFragmentRoot)JavaCore.create(resource);
        String name = generic.getAttribute(ATTRIBUTE_NAME);
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }
}

