/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.ClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoablePackageDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static Change createDeleteChange(TextChangeManager manager, IResource[] resources, IJavaElement[] javaElements, String changeName, List<IResource> packageDeletes) throws CoreException {
        DynamicValidationStateChange result = packageDeletes.size() > 0 ? new UndoablePackageDeleteChange(changeName, packageDeletes) : new DynamicValidationStateChange(changeName);
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (!ReorgUtils.isInsideCompilationUnit(element)) {
                result.add(DeleteChangeCreator.createDeleteChange(element));
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            result.add(DeleteChangeCreator.createDeleteChange(resources[i]));
            ++i;
        }
        Map<ICompilationUnit, List<IJavaElement>> grouped = ReorgUtils.groupByCompilationUnit(DeleteChangeCreator.getElementsSmallerThanCu(javaElements));
        if (grouped.size() != 0) {
            Assert.isNotNull(manager);
            for (ICompilationUnit cu : grouped.keySet()) {
                result.add(DeleteChangeCreator.createDeleteChange(cu, grouped.get(cu), manager));
            }
        }
        return result;
    }

    private static Change createDeleteChange(IResource resource) {
        Assert.isTrue(!(resource instanceof IWorkspaceRoot));
        Assert.isTrue(!(resource instanceof IProject));
        return new DeleteResourceChange(resource.getFullPath(), true);
    }

    private static Change createDeleteChange(ICompilationUnit cu, List<IJavaElement> javaElements, TextChangeManager manager) throws CoreException {
        CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider(cu, false, null);
        CompilationUnitRewrite rewriter = new CompilationUnitRewrite(cu, cuNode);
        IJavaElement[] elements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        ASTNodeDeleteUtil.markAsDeleted(elements, rewriter, null);
        return DeleteChangeCreator.addTextEditFromRewrite(manager, cu, rewriter.getASTRewrite());
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(cu);
            TextEdit resultingEdits = rewrite.rewriteAST(buffer.getDocument(), cu.getJavaProject().getOptions(true));
            TextChange textChange = manager.get(cu);
            if (textChange instanceof TextFileChange) {
                TextFileChange tfc = (TextFileChange)textChange;
                tfc.setSaveMode(1);
            }
            String message = RefactoringCoreMessages.DeleteChangeCreator_1;
            TextChangeCompatibility.addTextEdit(textChange, message, resultingEdits);
            TextChange textChange2 = textChange;
            return textChange2;
        }
        finally {
            RefactoringFileBuffers.release(cu);
        }
    }

    private static List<IJavaElement> getElementsSmallerThanCu(IJavaElement[] javaElements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (ReorgUtils.isInsideCompilationUnit(element)) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private static Change createDeleteChange(IJavaElement javaElement) throws JavaModelException {
        Assert.isTrue(!ReorgUtils.isInsideCompilationUnit(javaElement));
        switch (javaElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createPackageFragmentRootDeleteChange((IPackageFragmentRoot)javaElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((IPackageFragment)javaElement);
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ICompilationUnit)javaElement);
            }
            case 6: {
                Assert.isTrue(((IClassFile)javaElement).getResource() instanceof IFile);
                return DeleteChangeCreator.createDeleteChange(((IClassFile)javaElement).getResource());
            }
            case 1: {
                Assert.isTrue(false);
                return null;
            }
            case 2: {
                Assert.isTrue(false);
                return null;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                Assert.isTrue(false);
                return new NullChange();
            }
        }
        Assert.isTrue(false);
        return new NullChange();
    }

    private static Change createSourceManipulationDeleteChange(ISourceManipulation element) {
        IResource resource;
        if ((element instanceof ICompilationUnit || element instanceof IPackageFragment) && (resource = element instanceof ICompilationUnit ? ReorgUtils.getResource((ICompilationUnit)element) : ((IPackageFragment)element).getResource()) != null && resource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(resource);
        }
        return new DeleteSourceManipulationChange(element, true);
    }

    private static Change createPackageFragmentRootDeleteChange(IPackageFragmentRoot root) throws JavaModelException {
        IResource resource = root.getResource();
        if (resource != null && resource.isLinked()) {
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.DeleteRefactoring_delete_package_fragment_root);
            ClasspathChange change = ClasspathChange.removeEntryChange(root.getJavaProject(), root.getRawClasspathEntry());
            if (change != null) {
                composite.add((Change)change);
            }
            Assert.isTrue(!Checks.isClasspathDelete(root));
            composite.add(DeleteChangeCreator.createDeleteChange(resource));
            return composite;
        }
        Assert.isTrue(!root.isExternal());
        return new DeletePackageFragmentRootChange(root, true, null);
    }
}

