/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.LoggedNewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MonitoringNewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class JavaCopyProcessor
extends CopyProcessor
implements IReorgDestinationValidator {
    private IReorgPolicy.ICopyPolicy fCopyPolicy;
    private ReorgExecutionLog fExecutionLog;
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;

    public JavaCopyProcessor(IReorgPolicy.ICopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    public JavaCopyProcessor(JavaRefactoringArguments refactoringArguments, RefactoringStatus status) {
        RefactoringStatus initStatus = this.initialize(refactoringArguments);
        status.merge(initStatus);
    }

    public boolean canChildrenBeDestinations(IReorgDestination destination) {
        return this.fCopyPolicy.canChildrenBeDestinations(destination);
    }

    public boolean canElementBeDestination(IReorgDestination destination) {
        return this.fCopyPolicy.canElementBeDestination(destination);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull(this.fNewNameQueries, "Missing new name queries");
        Assert.isNotNull(this.fReorgQueries, "Missing reorg queries");
        pm.beginTask("", 2);
        return this.fCopyPolicy.checkFinalConditions(new SubProgressMonitor(pm, 1), context, this.fReorgQueries);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] javaResources = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(this.fNewNameQueries);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(this.getChangeName()){

                public Object getAdapter(Class adapter) {
                    if (ReorgExecutionLog.class.equals((Object)adapter)) {
                        return JavaCopyProcessor.this.fExecutionLog;
                    }
                    return super.getAdapter(adapter);
                }

                public ChangeDescriptor getDescriptor() {
                    return JavaCopyProcessor.this.fCopyPolicy.getDescriptor();
                }

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    try {
                        super.perform(pm2);
                    }
                    catch (OperationCanceledException e) {
                        JavaCopyProcessor.this.fExecutionLog.markAsCanceled();
                        throw e;
                    }
                    return null;
                }
            };
            Change change = this.fCopyPolicy.createChange(pm, new MonitoringNewNameQueries(this.fNewNameQueries, this.fExecutionLog));
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fCopyPolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fCopyPolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    private String getChangeName() {
        return RefactoringCoreMessages.JavaCopyProcessor_changeName;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public Object[] getElements() {
        IJavaElement[] jElements = this.fCopyPolicy.getJavaElements();
        IResource[] resources = this.fCopyPolicy.getResources();
        ArrayList<IAdaptable> result = new ArrayList<IAdaptable>(jElements.length + resources.length);
        result.addAll(Arrays.asList(jElements));
        result.addAll(Arrays.asList(resources));
        return result.toArray();
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.CopyProcessor";
    }

    public IJavaElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.JavaCopyProcessor_processorName;
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        this.fCopyPolicy = ReorgPolicyFactory.createCopyPolicy(status, extended);
        if (this.fCopyPolicy != null && !status.hasFatalError()) {
            ReorgExecutionLog log;
            status.merge(this.fCopyPolicy.initialize(extended));
            if (!status.hasFatalError() && (log = ReorgPolicyFactory.loadReorgExecutionLog(extended)) != null && !status.hasFatalError()) {
                this.setNewNameQueries(new LoggedNewNameQueries(log));
            }
        }
        return status;
    }

    public boolean isApplicable() throws CoreException {
        return this.fCopyPolicy.canEnable();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RefactoringParticipant[] result = this.fCopyPolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharedParticipants);
        this.fExecutionLog = this.fCopyPolicy.getReorgExecutionLog();
        return result;
    }

    public RefactoringStatus setDestination(IReorgDestination destination) throws JavaModelException {
        this.fCopyPolicy.setDestination(destination);
        return this.fCopyPolicy.verifyDestination(destination);
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull(newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fReorgQueries = queries;
    }

    public int getSaveMode() {
        return this.fCopyPolicy.getSaveMode();
    }
}

