/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private ICompilationUnit[] fCus = new ICompilationUnit[0];
    private IPackageFragmentRoot[] fRoots = new IPackageFragmentRoot[0];
    private IPackageFragment[] fPackageFragments = new IPackageFragment[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] files) {
        Assert.isNotNull(files);
        this.fFiles = files;
    }

    public void setFolders(IFolder[] folders) {
        Assert.isNotNull(folders);
        this.fFolders = folders;
    }

    public void setCus(ICompilationUnit[] cus) {
        Assert.isNotNull(cus);
        this.fCus = cus;
    }

    public void setPackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull(roots);
        this.fRoots = roots;
    }

    public void setPackages(IPackageFragment[] fragments) {
        Assert.isNotNull(fragments);
        this.fPackageFragments = fragments;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public ICompilationUnit[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IPackageFragmentRoot[] getPackageFragmentRootsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IPackageFragment[] getPackagesWithoutUnconfirmedOnes() {
        return this.fPackageFragments;
    }

    public void confirmOverwriting(IReorgQueries reorgQueries, Object destination) {
        Assert.isNotNull(destination);
        Assert.isNotNull(reorgQueries);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    private void confirmOverwritting(IReorgQueries reorgQueries) {
        IConfirmQuery overwriteQuery = reorgQueries.createYesYesToAllNoNoToAllQuery(RefactoringCoreMessages.OverwriteHelper_0, true, 6);
        IConfirmQuery skipQuery = reorgQueries.createSkipQuery(RefactoringCoreMessages.OverwriteHelper_2, 7);
        this.confirmFileOverwritting(overwriteQuery, skipQuery);
        this.confirmFolderOverwritting(skipQuery);
        this.confirmCuOverwritting(overwriteQuery);
        this.confirmPackageFragmentRootOverwritting(skipQuery, overwriteQuery);
        this.confirmPackageOverwritting(overwriteQuery);
    }

    private void confirmPackageFragmentRootOverwritting(IConfirmQuery skipQuery, IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragmentRoot> toNotOverwrite = new ArrayList<IPackageFragmentRoot>(1);
        int i = 0;
        while (i < this.fRoots.length) {
            IPackageFragmentRoot root = this.fRoots[i];
            if (this.canOverwrite(root)) {
                if (root.getResource() instanceof IContainer) {
                    if (!OverwriteHelper.skip(JavaElementLabels.getElementLabel(root, JavaElementLabels.ALL_DEFAULT), skipQuery)) {
                        toNotOverwrite.add(root);
                    }
                } else if (!OverwriteHelper.overwrite(root.getResource(), overwriteQuery)) {
                    toNotOverwrite.add(root);
                }
            }
            ++i;
        }
        IJavaElement[] roots = toNotOverwrite.toArray(new IPackageFragmentRoot[toNotOverwrite.size()]);
        this.fRoots = ArrayTypeConverter.toPackageFragmentRootArray(ReorgUtils.setMinus(this.fRoots, roots));
    }

    private void confirmCuOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<ICompilationUnit> cusToNotOverwrite = new ArrayList<ICompilationUnit>(1);
        int i = 0;
        while (i < this.fCus.length) {
            ICompilationUnit cu = this.fCus[i];
            if (this.canOverwrite(cu) && !OverwriteHelper.overwrite(cu, overwriteQuery)) {
                cusToNotOverwrite.add(cu);
            }
            ++i;
        }
        IJavaElement[] cus = cusToNotOverwrite.toArray(new ICompilationUnit[cusToNotOverwrite.size()]);
        this.fCus = ArrayTypeConverter.toCuArray(ReorgUtils.setMinus(this.fCus, cus));
    }

    private void confirmFolderOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFolder> foldersToNotOverwrite = new ArrayList<IFolder>(1);
        int i = 0;
        while (i < this.fFolders.length) {
            IFolder folder = this.fFolders[i];
            if (this.willOverwrite(folder) && !OverwriteHelper.skip(BasicElementLabels.getResourceName(folder), overwriteQuery)) {
                foldersToNotOverwrite.add(folder);
            }
            ++i;
        }
        IResource[] folders = foldersToNotOverwrite.toArray(new IFolder[foldersToNotOverwrite.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtils.setMinus(this.fFolders, folders));
    }

    private void confirmFileOverwritting(IConfirmQuery overwriteQuery, IConfirmQuery skipQuery) {
        ArrayList<IFile> filesToNotOverwrite = new ArrayList<IFile>(1);
        int i = 0;
        while (i < this.fFiles.length) {
            IFile file = this.fFiles[i];
            if (this.willOverwrite(file)) {
                IContainer destination = (IContainer)ResourceUtil.getResource(this.fDestination);
                if (ParentChecker.isDescendantOf((IResource)file, destination.findMember(file.getName()))) {
                    if (!OverwriteHelper.skip(BasicElementLabels.getResourceName(file), skipQuery)) {
                        filesToNotOverwrite.add(file);
                    }
                } else if (!OverwriteHelper.overwrite(file, overwriteQuery)) {
                    filesToNotOverwrite.add(file);
                }
            }
            ++i;
        }
        IResource[] files = filesToNotOverwrite.toArray(new IFile[filesToNotOverwrite.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtils.setMinus(this.fFiles, files));
    }

    private void confirmPackageOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragment> toNotOverwrite = new ArrayList<IPackageFragment>(1);
        int i = 0;
        while (i < this.fPackageFragments.length) {
            IPackageFragment pack = this.fPackageFragments[i];
            if (this.canOverwrite(pack) && !OverwriteHelper.overwrite(pack, overwriteQuery)) {
                toNotOverwrite.add(pack);
            }
            ++i;
        }
        IJavaElement[] packages = toNotOverwrite.toArray(new IPackageFragment[toNotOverwrite.size()]);
        this.fPackageFragments = ArrayTypeConverter.toPackageArray(ReorgUtils.setMinus(this.fPackageFragments, packages));
    }

    private boolean canOverwrite(IPackageFragment pack) {
        if (this.fDestination instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot destination = (IPackageFragmentRoot)this.fDestination;
            return !destination.equals(pack.getParent()) && destination.getPackageFragment(pack.getElementName()).exists();
        }
        return this.willOverwrite(pack.getResource());
    }

    private boolean willOverwrite(IResource resource) {
        if (resource == null) {
            return false;
        }
        IResource destinationResource = ResourceUtil.getResource(this.fDestination);
        if (destinationResource.equals(resource.getParent())) {
            return false;
        }
        if (destinationResource instanceof IContainer) {
            IContainer container = (IContainer)destinationResource;
            IResource member = container.findMember(resource.getName());
            return member != null && member.exists();
        }
        return false;
    }

    private boolean canOverwrite(IPackageFragmentRoot root) {
        if (this.fDestination instanceof IJavaProject) {
            IJavaProject destination = (IJavaProject)this.fDestination;
            IFolder conflict = destination.getProject().getFolder(root.getElementName());
            try {
                return !destination.equals(root.getParent()) && conflict.exists() && conflict.members().length > 0;
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return this.willOverwrite(root.getResource());
    }

    private boolean canOverwrite(ICompilationUnit cu) {
        if (this.fDestination instanceof IPackageFragment) {
            IPackageFragment destination = (IPackageFragment)this.fDestination;
            return !destination.equals(cu.getParent()) && destination.getCompilationUnit(cu.getElementName()).exists();
        }
        return this.willOverwrite(ReorgUtils.getResource(cu));
    }

    private static boolean overwrite(IResource resource, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(BasicElementLabels.getResourceName(resource), overwriteQuery);
    }

    private static boolean overwrite(IJavaElement element, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT), overwriteQuery);
    }

    private static boolean overwrite(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_1, BasicElementLabels.getJavaElementName(name));
        return overwriteQuery.confirm(question);
    }

    private static boolean skip(String name, IConfirmQuery overwriteQuery) {
        String question = Messages.format(RefactoringCoreMessages.OverwriteHelper_3, BasicElementLabels.getJavaElementName(name));
        return overwriteQuery.confirm(question);
    }
}

