/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;

public class ReorgDestinationFactory {
    public static IReorgDestination createDestination(Object destination) {
        return ReorgDestinationFactory.createDestination(destination, 3);
    }

    public static IReorgDestination createDestination(Object destination, int location) {
        if (destination instanceof IJavaElement) {
            return new JavaElementDestination((IJavaElement)destination, location);
        }
        if (destination instanceof IResource) {
            return new ResourceDestination((IResource)destination, location);
        }
        return null;
    }

    private static class Destination
    implements IReorgDestination {
        private final Object fDestination;
        private final int fLocation;

        public Destination(Object destination, int location) {
            Assert.isNotNull(destination);
            Assert.isLegal(location == 2 || location == 1 || location == 3);
            this.fDestination = destination;
            this.fLocation = location;
        }

        public Object getDestination() {
            return this.fDestination;
        }

        public int getLocation() {
            return this.fLocation;
        }
    }

    static final class JavaElementDestination
    extends Destination {
        private JavaElementDestination(IJavaElement destination, int location) {
            super(destination, location);
        }

        public IJavaElement getJavaElement() {
            return (IJavaElement)this.getDestination();
        }
    }

    static final class ResourceDestination
    extends Destination {
        private ResourceDestination(IResource destination, int location) {
            super(destination, location);
        }

        public IResource getResource() {
            return (IResource)this.getDestination();
        }
    }
}

