/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeSearchUtil {
    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] getAstNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.getAstNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode getAstNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = ASTNodeSearchUtil.getAstNode(cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    public static ASTNode getAstNode(CompilationUnit cuNode, int start, int length) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(start, length), true);
        cuNode.accept(analyzer);
        ASTNode node = analyzer.getFirstSelectedNode();
        if (node == null && analyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        } else if (node == null && analyzer.getLastCoveringNode() instanceof ConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        }
        if (node == null) {
            return null;
        }
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)parentNode;
            if (!(node instanceof SimpleName) && md.isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && (md.getBody().statements().get(0) instanceof ConstructorInvocation || md.getBody().statements().get(0) instanceof SuperConstructorInvocation) && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
                return (ASTNode)md.getBody().statements().get(0);
            }
        }
        if (parentNode instanceof SuperConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        if (parentNode instanceof ConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        return node;
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return (MethodDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iMethod, cuNode), MethodDeclaration.class);
    }

    public static AnnotationTypeMemberDeclaration getAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return (AnnotationTypeMemberDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iMethod, cuNode), AnnotationTypeMemberDeclaration.class);
    }

    public static BodyDeclaration getMethodOrAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        if (JdtFlags.isAnnotation(iMethod.getDeclaringType())) {
            return ASTNodeSearchUtil.getAnnotationTypeMemberDeclarationNode(iMethod, cuNode);
        }
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, cuNode);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.getNameNode(iField, cuNode);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, VariableDeclarationFragment.class);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        return (FieldDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iField, cuNode), FieldDeclaration.class);
    }

    public static EnumConstantDeclaration getEnumConstantDeclaration(IField iField, CompilationUnit cuNode) throws JavaModelException {
        return (EnumConstantDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iField, cuNode), EnumConstantDeclaration.class);
    }

    public static BodyDeclaration getFieldOrEnumConstantDeclaration(IField iField, CompilationUnit cuNode) throws JavaModelException {
        if (JdtFlags.isEnum(iField)) {
            return ASTNodeSearchUtil.getEnumConstantDeclaration(iField, cuNode);
        }
        return ASTNodeSearchUtil.getFieldDeclarationNode(iField, cuNode);
    }

    public static EnumDeclaration getEnumDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (EnumDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iType, cuNode), EnumDeclaration.class);
    }

    public static AnnotationTypeDeclaration getAnnotationTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (AnnotationTypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iType, cuNode), AnnotationTypeDeclaration.class);
    }

    public static BodyDeclaration getBodyDeclarationNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return (BodyDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iMember, cuNode), BodyDeclaration.class);
    }

    public static AbstractTypeDeclaration getAbstractTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (AbstractTypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iType, cuNode), AbstractTypeDeclaration.class);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (TypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iType, cuNode), TypeDeclaration.class);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (ClassInstanceCreation)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iType, cuNode), ClassInstanceCreation.class);
    }

    public static List<BodyDeclaration> getBodyDeclarationList(IType iType, CompilationUnit cuNode) throws JavaModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, cuNode).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, cuNode).bodyDeclarations();
    }

    public static ASTNode[] getDeclarationNodes(IJavaElement element, CompilationUnit cuNode) throws JavaModelException {
        switch (element.getElementType()) {
            case 8: {
                return new ASTNode[]{ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)element, cuNode)};
            }
            case 12: {
                return ASTNodeSearchUtil.getImportNodes((IImportContainer)element, cuNode);
            }
            case 13: {
                return new ASTNode[]{ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)element, cuNode)};
            }
            case 10: {
                return new ASTNode[]{ASTNodeSearchUtil.getInitializerNode((IInitializer)element, cuNode)};
            }
            case 9: {
                return new ASTNode[]{ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)element, cuNode)};
            }
            case 11: {
                return new ASTNode[]{ASTNodeSearchUtil.getPackageDeclarationNode((IPackageDeclaration)element, cuNode)};
            }
            case 7: {
                return new ASTNode[]{ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)element, cuNode)};
            }
        }
        Assert.isTrue(false, String.valueOf(element.getElementType()));
        return null;
    }

    private static ASTNode getNameNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return NodeFinder.perform(cuNode, iMember.getNameRange());
    }

    public static PackageDeclaration getPackageDeclarationNode(IPackageDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (PackageDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ImportDeclaration getImportDeclarationNode(IImportDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (ImportDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ASTNode[] getImportNodes(IImportContainer reference, CompilationUnit cuNode) throws JavaModelException {
        IJavaElement[] imps = reference.getChildren();
        ASTNode[] result = new ASTNode[imps.length];
        int i = 0;
        while (i < imps.length) {
            result[i] = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)imps[i], cuNode);
            ++i;
        }
        return result;
    }

    public static Initializer getInitializerNode(IInitializer initializer, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.findNode(initializer.getSourceRange(), cuNode);
        if (node instanceof Initializer) {
            return (Initializer)node;
        }
        if (node instanceof Block && node.getParent() instanceof Initializer) {
            return (Initializer)node.getParent();
        }
        return null;
    }

    private static ASTNode findNode(ISourceRange range, CompilationUnit cuNode) {
        NodeFinder nodeFinder = new NodeFinder(cuNode, range.getOffset(), range.getLength());
        ASTNode coveredNode = nodeFinder.getCoveredNode();
        if (coveredNode != null) {
            return coveredNode;
        }
        return nodeFinder.getCoveringNode();
    }

    public static ASTNode[] findNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.findNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode findNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = NodeFinder.perform(cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }
}

