/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractClassDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ParameterObjectFactory;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractClassRefactoring
extends Refactoring {
    private ExtractClassDescriptor fDescriptor;
    private Map<String, FieldInfo> fVariables;
    private CompilationUnitRewrite fBaseCURewrite;
    private TextChangeManager fChangeManager;
    private ParameterObjectFactory fParameterObjectFactory;
    private ExtractClassDescriptorVerification fVerification;

    public ExtractClassRefactoring(ExtractClassDescriptor descriptor) {
        this.fDescriptor = descriptor;
        IType type = this.fDescriptor.getType();
        if (this.fDescriptor.getPackage() == null) {
            this.fDescriptor.setPackage(type.getPackageFragment().getElementName());
        }
        if (this.fDescriptor.getClassName() == null) {
            this.fDescriptor.setClassName(String.valueOf(type.getElementName()) + "Data");
        }
        if (this.fDescriptor.getFieldName() == null) {
            this.fDescriptor.setFieldName(StubUtility.getVariableNameSuggestions(2, type.getJavaProject(), "data", 0, null, true)[0]);
        }
        if (this.fDescriptor.getFields() == null) {
            try {
                this.fDescriptor.setFields(ExtractClassDescriptor.getFields((IType)type));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        this.fVerification = new ExtractClassDescriptorVerification(descriptor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_msg_check_initial_condition, 5);
        try {
            result.merge(this.fDescriptor.validateDescriptor());
            if (!result.isOK()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IType type = this.fDescriptor.getType();
            result.merge(Checks.checkAvailability(type));
            if (!result.isOK()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            ExtractClassDescriptor.Field[] fields = ExtractClassDescriptor.getFields((IType)this.fDescriptor.getType());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fVariables = new LinkedHashMap<String, FieldInfo>();
            if (fields.length == 0) {
                result.addFatalError(RefactoringCoreMessages.ExtractClassRefactoring_error_no_usable_fields, JavaStatusContext.create(type));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            int i = 0;
            while (i < fields.length) {
                ExtractClassDescriptor.Field field = fields[i];
                String fieldName = field.getFieldName();
                IField declField = type.getField(fieldName);
                ParameterInfo info = new ParameterInfo(Signature.toString(declField.getTypeSignature()), fieldName, i);
                this.fVariables.put(fieldName, new FieldInfo(info, declField));
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            pm.worked(3);
        }
        finally {
            pm.done();
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.fVerification.validateAll());
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_final_conditions, 95);
            for (FieldInfo fi : this.fVariables.values()) {
                boolean createField = this.isCreateField(fi);
                if (!createField) continue;
                IField field = fi.ifield;
                int flags = field.getFlags();
                if (Flags.isStatic(flags)) {
                    result.addFatalError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_field_is_static, BasicElementLabels.getJavaElementName(field.getElementName())), JavaStatusContext.create(field));
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                if (Flags.isTransient(flags)) {
                    result.addWarning(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_warning_field_is_transient, BasicElementLabels.getJavaElementName(field.getElementName())), JavaStatusContext.create(field));
                }
                if (!Flags.isVolatile(flags)) continue;
                result.addWarning(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_warning_field_is_volatile, BasicElementLabels.getJavaElementName(field.getElementName())), JavaStatusContext.create(field));
            }
            pm.worked(5);
            this.fChangeManager = new TextChangeManager();
            this.fParameterObjectFactory = this.initializeFactory();
            IType type = this.fDescriptor.getType();
            pm.worked(5);
            FieldDeclaration field = this.performFieldRewrite(type, this.fParameterObjectFactory, result);
            int flags = 851970;
            if (!Modifier.isPrivate(field.getModifiers())) {
                flags |= 4;
            }
            this.fDescriptor.setFlags(flags);
            result.merge(this.updateReferences(type, this.fParameterObjectFactory, new SubProgressMonitor(pm, 65)));
        }
        finally {
            pm.done();
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_create_change, 10);
        try {
            DynamicValidationRefactoringChange change;
            ICompilationUnit typeCU = this.fDescriptor.getType().getCompilationUnit();
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)typeCU.getAncestor(3);
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(this.createParameterObject(this.fParameterObjectFactory, packageRoot));
            this.fChangeManager.manage(typeCU, (TextChange)this.fBaseCURewrite.createChange(true, pm));
            changes.addAll(Arrays.asList(this.fChangeManager.getAllChanges()));
            String project = this.fDescriptor.getType().getJavaProject().getElementName();
            this.fDescriptor.setProject(project);
            this.fDescriptor.setDescription(this.getName());
            this.fDescriptor.setComment(this.createComment());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = change = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)this.fDescriptor, RefactoringCoreMessages.ExtractClassRefactoring_change_name, changes.toArray(new Change[changes.size()]));
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
        }
    }

    private String createComment() {
        Object[] keys = new Object[]{BasicElementLabels.getJavaElementName(this.fDescriptor.getClassName()), BasicElementLabels.getJavaElementName(this.fDescriptor.getType().getElementName())};
        String header = Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_change_comment_header, keys);
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(this.fDescriptor.getType().getJavaProject().getElementName(), (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_comment_extracted_class, BasicElementLabels.getJavaElementName(this.fDescriptor.getClassName())));
        if (this.fDescriptor.isCreateTopLevel()) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_comment_package, BasicElementLabels.getJavaElementName(this.fDescriptor.getPackage())));
        }
        ExtractClassDescriptor.Field[] fields = this.fDescriptor.getFields();
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < fields.length) {
            ExtractClassDescriptor.Field field = fields[i];
            if (field.isCreateField()) {
                strings.add(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_comment_field_renamed, new Object[]{BasicElementLabels.getJavaElementName(field.getFieldName()), BasicElementLabels.getJavaElementName(field.getNewFieldName())}));
            }
            ++i;
        }
        String fieldString = JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractClassRefactoring_comment_move_field, strings.toArray(new String[strings.size()]));
        comment.addSetting(fieldString);
        if (this.fDescriptor.isCreateGetterSetter()) {
            comment.addSetting(RefactoringCoreMessages.ExtractClassRefactoring_comment_getters);
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_comment_fieldname, BasicElementLabels.getJavaElementName(this.fDescriptor.getFieldName())));
        return comment.asString();
    }

    private List<ResourceChange> createParameterObject(ParameterObjectFactory pof, IPackageFragmentRoot packageRoot) throws CoreException {
        FieldUpdate fieldUpdate = new FieldUpdate();
        if (this.fDescriptor.isCreateTopLevel()) {
            return pof.createTopLevelParameterObject(packageRoot, fieldUpdate);
        }
        CompilationUnit root = this.fBaseCURewrite.getRoot();
        TypeDeclaration typeDecl = (TypeDeclaration)NodeFinder.perform(root, this.fDescriptor.getType().getSourceRange());
        ASTRewrite rewrite = this.fBaseCURewrite.getASTRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite(typeDecl, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        TypeDeclaration paramClass = pof.createClassDeclaration(typeDecl.getName().getFullyQualifiedName(), this.fBaseCURewrite, fieldUpdate);
        paramClass.modifiers().add(rewrite.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        paramClass.modifiers().add(rewrite.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        listRewrite.insertFirst(paramClass, this.fBaseCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractClassRefactoring_group_insert_parameter));
        return new ArrayList<ResourceChange>();
    }

    private ParameterObjectFactory initializeFactory() {
        ParameterObjectFactory pof = new ParameterObjectFactory();
        pof.setClassName(this.fDescriptor.getClassName());
        pof.setPackage(this.fDescriptor.getPackage());
        pof.setEnclosingType(this.fDescriptor.getType().getFullyQualifiedName());
        pof.setCreateGetter(this.fDescriptor.isCreateGetterSetter());
        pof.setCreateSetter(this.fDescriptor.isCreateGetterSetter());
        ArrayList<ParameterInfo> variables = new ArrayList<ParameterInfo>();
        for (FieldInfo info : this.fVariables.values()) {
            boolean createField = this.isCreateField(info);
            info.pi.setCreateField(createField);
            if (createField) {
                ExtractClassDescriptor.Field field = this.getField(info.name);
                info.pi.setNewName(field.getNewFieldName());
            }
            variables.add(info.pi);
        }
        pof.setVariables(variables);
        return pof;
    }

    private ExtractClassDescriptor.Field getField(String name) {
        ExtractClassDescriptor.Field[] fields = this.fDescriptor.getFields();
        int i = 0;
        while (i < fields.length) {
            ExtractClassDescriptor.Field field = fields[i];
            if (field.getFieldName().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus updateReferences(IType type, ParameterObjectFactory pof, IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_updating_references, 100);
        try {
            pm.worked(10);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            ArrayList<IField> validIFields = new ArrayList<IField>();
            for (FieldInfo info : this.fVariables.values()) {
                if (!this.isCreateField(info)) continue;
                validIFields.add(info.ifield);
            }
            if (validIFields.size() == 0) {
                status.addWarning(RefactoringCoreMessages.ExtractClassRefactoring_warning_no_fields_moved, JavaStatusContext.create(type));
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern(validIFields.toArray(new IField[validIFields.size()]), 3);
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, RefactoringScopeFactory.create(type), pm, status);
            SubProgressMonitor spm = new SubProgressMonitor(pm, 90);
            spm.beginTask(RefactoringCoreMessages.ExtractClassRefactoring_progress_updating_references, results.length * 10);
            try {
                int i = 0;
                while (i < results.length) {
                    SearchResultGroup group = results[i];
                    ICompilationUnit unit = group.getCompilationUnit();
                    CompilationUnitRewrite cuRewrite = unit.equals(this.fBaseCURewrite.getCu()) ? this.fBaseCURewrite : new CompilationUnitRewrite(unit);
                    spm.worked(1);
                    status.merge(this.replaceReferences(pof, group, cuRewrite));
                    if (cuRewrite != this.fBaseCURewrite) {
                        this.fChangeManager.manage(unit, (TextChange)cuRewrite.createChange(true, new SubProgressMonitor(spm, 9)));
                    }
                    if (spm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++i;
                }
            }
            finally {
                spm.done();
            }
        }
        finally {
            pm.done();
        }
        return status;
    }

    private RefactoringStatus replaceReferences(ParameterObjectFactory pof, SearchResultGroup group, CompilationUnitRewrite cuRewrite) {
        TextEditGroup writeGroup = cuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractClassRefactoring_group_replace_write);
        TextEditGroup readGroup = cuRewrite.createGroupDescription(RefactoringCoreMessages.ExtractClassRefactoring_group_replace_read);
        ICompilationUnit typeRoot = cuRewrite.getCu();
        IJavaProject javaProject = typeRoot.getJavaProject();
        AST ast = cuRewrite.getAST();
        RefactoringStatus status = new RefactoringStatus();
        String parameterName = this.fDescriptor.getFieldName();
        SearchMatch[] searchResults = group.getSearchResults();
        int j = 0;
        while (j < searchResults.length) {
            boolean isDeclaration;
            SearchMatch searchMatch = searchResults[j];
            ASTNode node = NodeFinder.perform(cuRewrite.getRoot(), searchMatch.getOffset(), searchMatch.getLength());
            ASTNode parent = node.getParent();
            boolean bl = isDeclaration = parent instanceof VariableDeclaration && ((VariableDeclaration)parent).getInitializer() != node;
            if (!isDeclaration && node instanceof SimpleName) {
                ASTRewrite rewrite = cuRewrite.getASTRewrite();
                if (parent.getNodeType() == 49) {
                    status.addError(RefactoringCoreMessages.ExtractClassRefactoring_error_switch, JavaStatusContext.create((ITypeRoot)typeRoot, node));
                }
                SimpleName name = (SimpleName)node;
                ParameterInfo pi = this.getFieldInfo((String)name.getIdentifier()).pi;
                boolean writeAccess = ASTResolving.isWriteAccess(name);
                if (writeAccess && this.fDescriptor.isCreateGetterSetter()) {
                    boolean useSuper = parent.getNodeType() == 47;
                    Expression qualifier = this.getQualifier(parent);
                    ASTNode replaceNode = this.getReplacementNode(parent, useSuper, qualifier);
                    Expression assignedValue = this.getAssignedValue(pof, parameterName, javaProject, status, rewrite, pi, useSuper, name.resolveTypeBinding(), qualifier, replaceNode, typeRoot);
                    if (assignedValue == null) {
                        status.addError(RefactoringCoreMessages.ExtractClassRefactoring_error_unable_to_convert_node, JavaStatusContext.create((ITypeRoot)typeRoot, replaceNode));
                    } else {
                        NullLiteral marker = qualifier == null ? null : ast.newNullLiteral();
                        Expression access = pof.createFieldWriteAccess(pi, parameterName, ast, javaProject, assignedValue, useSuper, marker);
                        this.replaceMarker(rewrite, qualifier, access, marker);
                        rewrite.replace(replaceNode, access, writeGroup);
                    }
                } else {
                    Expression fieldReadAccess = pof.createFieldReadAccess(pi, parameterName, ast, javaProject, false, null);
                    rewrite.replace(name, fieldReadAccess, readGroup);
                }
            }
            ++j;
        }
        return status;
    }

    private Expression getAssignedValue(ParameterObjectFactory pof, String parameterName, IJavaProject javaProject, RefactoringStatus status, ASTRewrite rewrite, ParameterInfo pi, boolean useSuper, ITypeBinding typeBinding, Expression qualifier, ASTNode replaceNode, ITypeRoot typeRoot) {
        NullLiteral marker;
        Expression fieldReadAccess;
        boolean markerReplaced;
        AST ast = rewrite.getAST();
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(javaProject);
        Expression assignedValue = this.handleSimpleNameAssignment(replaceNode, pof, parameterName, ast, javaProject, useSuper);
        if (assignedValue == null && (markerReplaced = this.replaceMarker(rewrite, qualifier, assignedValue = GetterSetterUtil.getAssignedValue(replaceNode, rewrite, fieldReadAccess = pof.createFieldReadAccess(pi, parameterName, ast, javaProject, useSuper, marker = qualifier == null ? null : ast.newNullLiteral()), typeBinding, is50OrHigher), marker))) {
            switch (qualifier.getNodeType()) {
                case 14: 
                case 32: 
                case 36: 
                case 48: {
                    status.addWarning(RefactoringCoreMessages.ExtractClassRefactoring_warning_semantic_change, JavaStatusContext.create(typeRoot, replaceNode));
                }
            }
        }
        return assignedValue;
    }

    private ASTNode getReplacementNode(ASTNode parent, boolean useSuper, Expression qualifier) {
        if (qualifier != null || useSuper) {
            return parent.getParent();
        }
        return parent;
    }

    private Expression getQualifier(ASTNode parent) {
        switch (parent.getNodeType()) {
            case 22: {
                return ((FieldAccess)parent).getExpression();
            }
            case 40: {
                return ((QualifiedName)parent).getQualifier();
            }
            case 47: {
                return ((SuperFieldAccess)parent).getQualifier();
            }
        }
        return null;
    }

    private boolean replaceMarker(ASTRewrite rewrite, Expression qualifier, Expression assignedValue, NullLiteral marker) {
        if (assignedValue != null && qualifier != null) {
            class MarkerReplacer
            extends ASTVisitor {
                private boolean fReplaced = false;
                private final /* synthetic */ NullLiteral val$marker;
                private final /* synthetic */ ASTRewrite val$rewrite;
                private final /* synthetic */ Expression val$qualifier;

                MarkerReplacer(NullLiteral nullLiteral, ASTRewrite aSTRewrite, Expression expression) {
                    this.val$marker = nullLiteral;
                    this.val$rewrite = aSTRewrite;
                    this.val$qualifier = expression;
                }

                public boolean visit(NullLiteral node) {
                    if (node == this.val$marker) {
                        this.val$rewrite.replace(node, this.val$rewrite.createCopyTarget(this.val$qualifier), null);
                        this.fReplaced = true;
                        return false;
                    }
                    return true;
                }
            }
            MarkerReplacer visitor = new MarkerReplacer(marker, rewrite, qualifier);
            assignedValue.accept(visitor);
            return visitor.fReplaced;
        }
        return false;
    }

    private Expression handleSimpleNameAssignment(ASTNode replaceNode, ParameterObjectFactory pof, String parameterName, AST ast, IJavaProject javaProject, boolean useSuper) {
        FieldInfo fieldInfo;
        SimpleName sn;
        IVariableBinding binding;
        Assignment assignment;
        Expression rightHandSide;
        if (replaceNode instanceof Assignment && (rightHandSide = (assignment = (Assignment)replaceNode).getRightHandSide()).getNodeType() == 42 && (binding = ASTNodes.getVariableBinding(sn = (SimpleName)rightHandSide)) != null && binding.isField() && this.fDescriptor.getType().getFullyQualifiedName().equals(binding.getDeclaringClass().getQualifiedName()) && (fieldInfo = this.getFieldInfo(binding.getName())) != null && binding == fieldInfo.pi.getOldBinding()) {
            return pof.createFieldReadAccess(fieldInfo.pi, parameterName, ast, javaProject, useSuper, null);
        }
        return null;
    }

    private FieldInfo getFieldInfo(String identifier) {
        return this.fVariables.get(identifier);
    }

    private FieldDeclaration performFieldRewrite(IType type, ParameterObjectFactory pof, RefactoringStatus status) throws CoreException {
        this.fBaseCURewrite = new CompilationUnitRewrite(type.getCompilationUnit());
        SimpleName name = (SimpleName)NodeFinder.perform(this.fBaseCURewrite.getRoot(), type.getNameRange());
        TypeDeclaration typeNode = (TypeDeclaration)ASTNodes.getParent((ASTNode)name, 55);
        ASTRewrite rewrite = this.fBaseCURewrite.getASTRewrite();
        int modifier = 2;
        TextEditGroup removeFieldGroup = this.fBaseCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractClassRefactoring_group_remove_field);
        FieldDeclaration lastField = null;
        this.initializeDeclaration(typeNode);
        for (FieldInfo pi : this.fVariables.values()) {
            int modifiers;
            Expression initializer;
            if (!this.isCreateField(pi)) continue;
            VariableDeclarationFragment vdf = pi.declaration;
            FieldDeclaration parent = (FieldDeclaration)vdf.getParent();
            if (lastField == null) {
                lastField = parent;
            } else if (lastField.getStartPosition() < parent.getStartPosition()) {
                lastField = parent;
            }
            ListRewrite listRewrite = rewrite.getListRewrite(parent, FieldDeclaration.FRAGMENTS_PROPERTY);
            this.removeNode(vdf, removeFieldGroup, this.fBaseCURewrite);
            if (listRewrite.getRewrittenList().size() == 0) {
                this.removeNode(parent, removeFieldGroup, this.fBaseCURewrite);
            }
            if (this.fDescriptor.isCreateTopLevel()) {
                IVariableBinding binding = vdf.resolveBinding();
                ICompilationUnit typeRoot = this.fBaseCURewrite.getCu();
                if (binding == null || binding.getType() == null) {
                    status.addFatalError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_fatal_error_cannot_resolve_binding, BasicElementLabels.getJavaElementName(pi.name)), JavaStatusContext.create((ITypeRoot)typeRoot, vdf));
                } else {
                    IPackageBinding package1;
                    ITypeBinding declaringClass;
                    ITypeBinding typeBinding = binding.getType();
                    if (Modifier.isPrivate(typeBinding.getDeclaredModifiers())) {
                        status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_referencing_private_class, BasicElementLabels.getJavaElementName(typeBinding.getName())), JavaStatusContext.create((ITypeRoot)typeRoot, vdf));
                    } else if (Modifier.isProtected(typeBinding.getDeclaredModifiers()) && (declaringClass = typeBinding.getDeclaringClass()) != null && (package1 = declaringClass.getPackage()) != null && !this.fDescriptor.getPackage().equals(package1.getName())) {
                        status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_referencing_protected_class, new String[]{BasicElementLabels.getJavaElementName(typeBinding.getName()), BasicElementLabels.getJavaElementName(this.fDescriptor.getPackage())}), JavaStatusContext.create((ITypeRoot)typeRoot, vdf));
                    }
                }
            }
            if ((initializer = vdf.getInitializer()) != null) {
                pi.initializer = initializer;
            }
            if (MemberVisibilityAdjustor.hasLowerVisibility(modifiers = parent.getModifiers(), modifier)) continue;
            modifier = modifiers;
        }
        FieldDeclaration fieldDeclaration = this.createParameterObjectField(pof, typeNode, modifier);
        ListRewrite bodyDeclList = rewrite.getListRewrite(typeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        if (lastField != null) {
            bodyDeclList.insertAfter(fieldDeclaration, lastField, null);
        } else {
            bodyDeclList.insertFirst(fieldDeclaration, null);
        }
        return fieldDeclaration;
    }

    private void initializeDeclaration(TypeDeclaration node) {
        FieldDeclaration[] fields = node.getFields();
        int i = 0;
        while (i < fields.length) {
            FieldDeclaration fieldDeclaration = fields[i];
            List fragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment vdf : fragments) {
                FieldInfo fieldInfo = this.getFieldInfo(vdf.getName().getIdentifier());
                if (fieldInfo == null) continue;
                Assert.isNotNull(vdf);
                fieldInfo.declaration = vdf;
                fieldInfo.pi.setOldBinding(vdf.resolveBinding());
            }
            ++i;
        }
    }

    private void removeNode(ASTNode parent, TextEditGroup removeFieldGroup, CompilationUnitRewrite baseCURewrite) {
        baseCURewrite.getASTRewrite().remove(parent, removeFieldGroup);
        baseCURewrite.getImportRemover().registerRemovedNode(parent);
    }

    private FieldDeclaration createParameterObjectField(ParameterObjectFactory pof, TypeDeclaration typeNode, int modifier) {
        AST ast = this.fBaseCURewrite.getAST();
        ClassInstanceCreation creation = ast.newClassInstanceCreation();
        creation.setType(pof.createType(this.fDescriptor.isCreateTopLevel(), this.fBaseCURewrite, typeNode.getStartPosition()));
        ListRewrite listRewrite = this.fBaseCURewrite.getASTRewrite().getListRewrite(creation, ClassInstanceCreation.ARGUMENTS_PROPERTY);
        for (FieldInfo fi : this.fVariables.values()) {
            Expression expression;
            if (!this.isCreateField(fi) || (expression = fi.initializer) == null || fi.hasFieldReference()) continue;
            this.importNodeTypes(expression, this.fBaseCURewrite);
            ASTNode createMoveTarget = this.fBaseCURewrite.getASTRewrite().createMoveTarget(expression);
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer ai = (ArrayInitializer)expression;
                ITypeBinding componentType = ai.resolveTypeBinding().getComponentType();
                ArrayCreation arrayCreation = ast.newArrayCreation();
                Type addImport = this.fBaseCURewrite.getImportRewrite().addImport(componentType, ast);
                this.fBaseCURewrite.getImportRemover().registerAddedImports(addImport);
                arrayCreation.setType(ast.newArrayType(addImport));
                arrayCreation.setInitializer((ArrayInitializer)createMoveTarget);
                listRewrite.insertLast(arrayCreation, null);
                continue;
            }
            listRewrite.insertLast(createMoveTarget, null);
        }
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(this.fDescriptor.getFieldName()));
        fragment.setInitializer(creation);
        Modifier.ModifierKeyword acc = null;
        if (Modifier.isPublic(modifier)) {
            acc = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        } else if (Modifier.isProtected(modifier)) {
            acc = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
        } else if (Modifier.isPrivate(modifier)) {
            acc = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        }
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        fieldDeclaration.setType(pof.createType(this.fDescriptor.isCreateTopLevel(), this.fBaseCURewrite, typeNode.getStartPosition()));
        if (acc != null) {
            fieldDeclaration.modifiers().add(ast.newModifier(acc));
        }
        return fieldDeclaration;
    }

    private void importNodeTypes(ASTNode node, final CompilationUnitRewrite cuRewrite) {
        ASTResolving.visitAllBindings(node, new TypeBindingVisitor(){

            public boolean visit(ITypeBinding nodeBinding) {
                ParameterObjectFactory.importBinding(nodeBinding, cuRewrite);
                return false;
            }
        });
    }

    private boolean isCreateField(FieldInfo fi) {
        return this.getField(fi.name).isCreateField();
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractClassRefactoring_refactoring_name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ExtractClassDescriptorVerification.class) {
            return this.fVerification;
        }
        return super.getAdapter(adapter);
    }

    public static class ExtractClassDescriptorVerification {
        private ExtractClassDescriptor fDescriptor;

        public ExtractClassDescriptorVerification(ExtractClassDescriptor descriptor) {
            this.fDescriptor = descriptor;
        }

        public RefactoringStatus validateClassName() {
            RefactoringStatus status = new RefactoringStatus();
            status.merge(Checks.checkTypeName(this.fDescriptor.getClassName(), this.fDescriptor.getType()));
            status.merge(this.checkClass());
            return status;
        }

        private RefactoringStatus checkClass() {
            RefactoringStatus status = new RefactoringStatus();
            IType type = this.fDescriptor.getType();
            if (!this.fDescriptor.isCreateTopLevel()) {
                if (type.getType(this.fDescriptor.getClassName()).exists()) {
                    status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_errror_nested_name_clash, new Object[]{BasicElementLabels.getJavaElementName(this.fDescriptor.getClassName()), BasicElementLabels.getJavaElementName(type.getElementName())}));
                }
            } else {
                status.merge(this.checkPackageClass());
            }
            return status;
        }

        private RefactoringStatus checkPackageClass() {
            RefactoringStatus status = new RefactoringStatus();
            IType type = this.fDescriptor.getType();
            IPackageFragmentRoot ancestor = (IPackageFragmentRoot)type.getAncestor(3);
            IPackageFragment packageFragment = ancestor.getPackageFragment(this.fDescriptor.getPackage());
            if (packageFragment.getCompilationUnit(String.valueOf(this.fDescriptor.getClassName()) + ".java").exists()) {
                status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_toplevel_name_clash, new Object[]{BasicElementLabels.getJavaElementName(this.fDescriptor.getClassName()), BasicElementLabels.getJavaElementName(this.fDescriptor.getPackage())}));
            }
            return status;
        }

        public RefactoringStatus validateTopLevel() {
            return this.checkClass();
        }

        public RefactoringStatus validateParameterName() {
            RefactoringStatus status = new RefactoringStatus();
            String parameterName = this.fDescriptor.getFieldName();
            IType type = this.fDescriptor.getType();
            status.merge(Checks.checkFieldName(parameterName, type));
            this.validateFieldNames(status, parameterName, type);
            return status;
        }

        private void validateFieldNames(RefactoringStatus status, String parameterName, IType type) {
            if (type.getField(parameterName).exists()) {
                ExtractClassDescriptor.Field[] fields = this.fDescriptor.getFields();
                int i = 0;
                while (i < fields.length) {
                    ExtractClassDescriptor.Field field = fields[i];
                    if (parameterName.equals(field.getFieldName()) && !field.isCreateField()) {
                        status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_field_already_exists, BasicElementLabels.getJavaElementName(parameterName)));
                    }
                    ++i;
                }
            }
        }

        public RefactoringStatus validateFields() {
            RefactoringStatus status = new RefactoringStatus();
            ExtractClassDescriptor.Field[] fields = this.fDescriptor.getFields();
            HashSet<String> names = new HashSet<String>();
            int i = 0;
            while (i < fields.length) {
                ExtractClassDescriptor.Field field = fields[i];
                if (field.isCreateField()) {
                    if (names.contains(field.getNewFieldName())) {
                        status.addError(Messages.format(RefactoringCoreMessages.ExtractClassRefactoring_error_duplicate_field_name, BasicElementLabels.getJavaElementName(field.getNewFieldName())));
                    }
                    names.add(field.getNewFieldName());
                    status.merge(Checks.checkFieldName(field.getNewFieldName(), this.fDescriptor.getType()));
                }
                ++i;
            }
            if (names.size() == 0) {
                status.addError(RefactoringCoreMessages.ExtractClassRefactoring_error_msg_one_field);
            }
            this.validateFieldNames(status, this.fDescriptor.getFieldName(), this.fDescriptor.getType());
            return status;
        }

        public RefactoringStatus validateAll() {
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.validateClassName());
            status.merge(this.validateFields());
            status.merge(this.validateParameterName());
            return status;
        }
    }

    private final class FieldInfo {
        ParameterInfo pi;
        VariableDeclarationFragment declaration;
        IField ifield;
        String name;
        Expression initializer;
        private Boolean hasFieldReferences = null;

        public boolean hasFieldReference() {
            if (this.hasFieldReferences == null) {
                if (this.initializer != null) {
                    FieldReferenceFinder frf = new FieldReferenceFinder();
                    this.initializer.accept(frf);
                    this.hasFieldReferences = frf.fFieldRefFound;
                } else {
                    this.hasFieldReferences = Boolean.FALSE;
                }
            }
            return this.hasFieldReferences;
        }

        private FieldInfo(ParameterInfo parameterInfo, IField ifield) {
            this.pi = parameterInfo;
            this.ifield = ifield;
            this.name = ifield.getElementName();
        }
    }

    private final class FieldReferenceFinder
    extends ASTVisitor {
        public boolean fFieldRefFound = false;

        private FieldReferenceFinder() {
        }

        public boolean visit(FieldAccess node) {
            IVariableBinding fieldBinding = node.resolveFieldBinding();
            return this.checkVariableBinding(fieldBinding);
        }

        public boolean visit(SimpleName node) {
            IVariableBinding variableBinding = ASTNodes.getVariableBinding(node);
            return this.checkVariableBinding(variableBinding);
        }

        private boolean checkVariableBinding(IVariableBinding fieldBinding) {
            FieldInfo fi;
            ITypeBinding declaringClass;
            if (fieldBinding != null && fieldBinding.isField() && (declaringClass = fieldBinding.getDeclaringClass()) != null && declaringClass.getQualifiedName().equals(ExtractClassRefactoring.this.fDescriptor.getType().getFullyQualifiedName()) && (fi = (FieldInfo)ExtractClassRefactoring.this.fVariables.get(fieldBinding.getName())) != null && ExtractClassRefactoring.this.isCreateField(fi) && Bindings.equals(fieldBinding, fi.pi.getOldBinding())) {
                this.fFieldRefFound = true;
                return false;
            }
            return true;
        }
    }

    private class FieldUpdate
    extends ParameterObjectFactory.CreationListener {
        private FieldUpdate() {
        }

        public void fieldCreated(CompilationUnitRewrite cuRewrite, FieldDeclaration field, ParameterInfo pi) {
            FieldInfo fieldInfo = ExtractClassRefactoring.this.getFieldInfo(pi.getOldName());
            FieldDeclaration parent = (FieldDeclaration)fieldInfo.declaration.getParent();
            List modifiers = parent.modifiers();
            ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite(field, FieldDeclaration.MODIFIERS2_PROPERTY);
            for (IExtendedModifier mod : modifiers) {
                if (!mod.isAnnotation()) continue;
                listRewrite.insertFirst(FieldUpdate.moveNode(cuRewrite, (ASTNode)((Object)mod)), null);
            }
            if (fieldInfo.initializer != null && fieldInfo.hasFieldReference()) {
                List fragments = field.fragments();
                for (VariableDeclarationFragment vdf : fragments) {
                    vdf.setInitializer((Expression)FieldUpdate.moveNode(cuRewrite, fieldInfo.initializer));
                }
            }
            if (parent.getJavadoc() != null) {
                field.setJavadoc((Javadoc)FieldUpdate.moveNode(cuRewrite, parent.getJavadoc()));
            }
        }

        public boolean isCreateSetter(ParameterInfo pi) {
            return true;
        }

        public boolean isUseInConstructor(ParameterInfo pi) {
            FieldInfo fi = ExtractClassRefactoring.this.getFieldInfo(pi.getOldName());
            return fi.initializer != null && !fi.hasFieldReference();
        }
    }
}

