/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceParameterObjectDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ParameterObjectFactory;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceParameterObjectProcessor
extends ChangeSignatureProcessor {
    private static final String PARAMETER_CLASS_APPENDIX = "Parameter";
    private static final String DEFAULT_PARAMETER_OBJECT_NAME = "parameterObject";
    private MethodDeclaration fMethodDeclaration;
    private ParameterObjectFactory fParameterObjectFactory;
    private boolean fCreateAsTopLevel = true;
    private ParameterInfo fParameterObjectReference;
    private boolean fParameterClassCreated = false;
    private List<ResourceChange> fOtherChanges;

    private boolean isParameter(ParameterInfo pi, ASTNode node, List<SingleVariableDeclaration> enclosingMethodParameters, String qualifier) {
        if (node instanceof Name) {
            Name name = (Name)node;
            IVariableBinding binding = ASTNodes.getVariableBinding(name);
            if (binding != null && binding.isParameter()) {
                return binding.getName().equals(this.getNameInScope(pi, enclosingMethodParameters));
            }
            if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                return qn.getFullyQualifiedName().equals(JavaModelUtil.concatenateName(qualifier, this.getNameInScope(pi, enclosingMethodParameters)));
            }
        }
        return false;
    }

    public IntroduceParameterObjectProcessor(IntroduceParameterObjectDescriptor descriptor) throws JavaModelException {
        super(descriptor.getMethod());
        IMethod method = descriptor.getMethod();
        Assert.isNotNull(method);
        this.initializeFields(method);
        this.setBodyUpdater(new RewriteParameterBody());
        this.setDefaultValueAdvisor(new ParameterObjectCreator());
        this.configureRefactoring(descriptor, this);
    }

    private void configureRefactoring(IntroduceParameterObjectDescriptor parameter, IntroduceParameterObjectProcessor ref) {
        ref.setCreateAsTopLevel(parameter.isTopLevel());
        ref.setCreateGetter(parameter.isGetters());
        ref.setCreateSetter(parameter.isSetters());
        ref.setDelegateUpdating(parameter.isDelegate());
        ref.setDeprecateDelegates(parameter.isDeprecateDelegate());
        if (parameter.getClassName() != null) {
            ref.setClassName(parameter.getClassName());
        }
        if (parameter.getPackageName() != null) {
            ref.setPackage(parameter.getPackageName());
        }
        if (parameter.getParameterName() != null) {
            ref.setParameterName(parameter.getParameterName());
        }
        List<ParameterInfo> pis = ref.getParameterInfos();
        IntroduceParameterObjectDescriptor.Parameter[] parameters = parameter.getParameters();
        if (parameters == null) {
            parameters = IntroduceParameterObjectDescriptor.createParameters((IMethod)this.getMethod());
        }
        HashMap<Integer, ParameterInfo> paramIndex = new HashMap<Integer, ParameterInfo>();
        for (ParameterInfo pi : pis) {
            paramIndex.put(new Integer(pi.getOldIndex()), pi);
        }
        paramIndex.put(new Integer(-1), this.fParameterObjectReference);
        pis.clear();
        int i = 0;
        while (i < parameters.length) {
            IntroduceParameterObjectDescriptor.Parameter param = parameters[i];
            ParameterInfo pi = (ParameterInfo)paramIndex.get(new Integer(param.getIndex()));
            pis.add(pi);
            if (param != IntroduceParameterObjectDescriptor.PARAMETER_OBJECT) {
                String fieldName;
                pi.setCreateField(param.isCreateField());
                if (pi.isCreateField() && (fieldName = param.getFieldName()) != null) {
                    pi.setNewName(fieldName);
                }
            }
            ++i;
        }
    }

    private void initializeFields(IMethod method) {
        this.fParameterObjectFactory = new ParameterObjectFactory();
        String methodName = method.getElementName();
        String className = String.valueOf(Character.toUpperCase(methodName.charAt(0)));
        if (methodName.length() > 1) {
            className = String.valueOf(className) + methodName.substring(1);
        }
        className = String.valueOf(className) + PARAMETER_CLASS_APPENDIX;
        this.fParameterObjectReference = ParameterInfo.createInfoForAddedParameter(className, DEFAULT_PARAMETER_OBJECT_NAME);
        this.fParameterObjectFactory.setClassName(className);
        IType declaringType = method.getDeclaringType();
        Assert.isNotNull(declaringType);
        this.fParameterObjectFactory.setPackage(declaringType.getPackageFragment().getElementName());
        this.updateReferenceType();
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IMethod method = this.getMethod();
        status.merge(Checks.checkTypeName(this.fParameterObjectFactory.getClassName(), method));
        status.merge(Checks.checkIdentifier(this.getParameterName(), method));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(super.checkFinalConditions(pm, context));
        return status;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ISourceRange nameRange;
        RefactoringStatus status = new RefactoringStatus();
        status.merge(super.checkInitialConditions(pm));
        if (status.hasFatalError()) {
            return status;
        }
        CompilationUnit astRoot = this.getBaseCuRewrite().getRoot();
        ASTNode selectedNode = NodeFinder.perform(astRoot, (nameRange = this.getMethod().getNameRange()).getOffset(), nameRange.getLength());
        if (selectedNode == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(selectedNode, MethodDeclaration.class);
        if (this.fMethodDeclaration == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        IMethodBinding resolveBinding = this.fMethodDeclaration.resolveBinding();
        if (resolveBinding == null) {
            if (!this.processCompilerError(status, selectedNode)) {
                status.addFatalError(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_error_cannot_resolve_type);
            }
            return status;
        }
        ITypeBinding declaringClass = resolveBinding.getDeclaringClass();
        if (this.fParameterObjectFactory.getPackage() == null) {
            this.fParameterObjectFactory.setPackage(declaringClass.getPackage().getName());
        }
        if (this.fParameterObjectFactory.getEnclosingType() == null) {
            this.fParameterObjectFactory.setEnclosingType(declaringClass.getQualifiedName());
        }
        List<ParameterInfo> parameterInfos = super.getParameterInfos();
        for (ParameterInfo pi : parameterInfos) {
            if (pi.isAdded() || !pi.getOldName().equals(pi.getNewName())) continue;
            pi.setNewName(this.getFieldName(pi));
        }
        if (!parameterInfos.contains(this.fParameterObjectReference)) {
            parameterInfos.add(0, this.fParameterObjectReference);
        }
        HashMap<String, IVariableBinding> bindingMap = new HashMap<String, IVariableBinding>();
        for (SingleVariableDeclaration sdv : this.fMethodDeclaration.parameters()) {
            bindingMap.put(sdv.getName().getIdentifier(), sdv.resolveBinding());
        }
        for (ParameterInfo pi : parameterInfos) {
            if (pi == this.fParameterObjectReference) continue;
            pi.setOldBinding((IVariableBinding)bindingMap.get(pi.getOldName()));
        }
        this.fParameterObjectFactory.setVariables(parameterInfos);
        return status;
    }

    @Override
    protected boolean shouldReport(IProblem problem, CompilationUnit cu) {
        if (!super.shouldReport(problem, cu)) {
            return false;
        }
        ASTNode node = ASTNodeSearchUtil.getAstNode(cu, problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart() + 1);
        if (node instanceof Type) {
            Type type = (Type)node;
            if (problem.getID() == 0x1000002 && this.getClassName().equals(ASTNodes.getTypeName(type))) {
                return false;
            }
        }
        if (node instanceof Name) {
            Name name = (Name)node;
            if (problem.getID() == 268435846 && this.getPackage().indexOf(name.getFullyQualifiedName()) != -1) {
                return false;
            }
            if (problem.getID() == 67108984) {
                StructuralPropertyDescriptor locationInParent = name.getLocationInParent();
                String[] arguments = problem.getArguments();
                if ((locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SuperMethodInvocation.NAME_PROPERTY) && arguments.length > 3 && arguments[3].endsWith(this.getClassName())) {
                    return false;
                }
            }
        }
        return true;
    }

    public String getClassName() {
        return this.fParameterObjectFactory.getClassName();
    }

    public ITypeBinding getContainingClass() {
        return this.fMethodDeclaration.resolveBinding().getDeclaringClass();
    }

    private String getMappingErrorMessage() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotalanyzemethod_mappingerror;
    }

    public String getFieldName(ParameterInfo element) {
        IJavaProject javaProject = this.getCompilationUnit().getJavaProject();
        String stripped = NamingConventions.getBaseName(4, element.getOldName(), javaProject);
        int dim = element.getNewTypeBinding() != null ? element.getNewTypeBinding().getDimensions() : 0;
        return StubUtility.getVariableNameSuggestions(2, javaProject, stripped, dim, null, true)[0];
    }

    @Override
    public Change[] getAllChanges() {
        ArrayList<Object> changes = new ArrayList<Object>();
        changes.addAll(Arrays.asList(super.getAllChanges()));
        changes.addAll(this.fOtherChanges);
        return changes.toArray(new Change[changes.size()]);
    }

    @Override
    protected void clearManagers() {
        super.clearManagers();
        this.fOtherChanges = new ArrayList<ResourceChange>();
        this.fParameterClassCreated = false;
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_refactoring_name;
    }

    @Override
    public String getIdentifier() {
        return "org.eclipse.jdt.ui.introduceParameterObjectRefactoring";
    }

    @Override
    public JavaRefactoringDescriptor createDescriptor() {
        IntroduceParameterObjectDescriptor ipod = RefactoringSignatureDescriptorFactory.createIntroduceParameterObjectDescriptor();
        ipod.setMethod(this.getMethod());
        ipod.setClassName(this.getClassName());
        ipod.setDelegate(this.getDelegateUpdating());
        ipod.setDeprecateDelegate(this.getDeprecateDelegates());
        ipod.setGetters(this.isCreateGetter());
        ipod.setSetters(this.isCreateSetter());
        ipod.setPackageName(this.getPackage());
        ipod.setParameterName(this.getParameterName());
        ipod.setTopLevel(this.isCreateAsTopLevel());
        ArrayList<IntroduceParameterObjectDescriptor.Parameter> parameters = new ArrayList<IntroduceParameterObjectDescriptor.Parameter>();
        List<ParameterInfo> pis = this.getParameterInfos();
        for (ParameterInfo pi : pis) {
            if (pi.isAdded()) {
                parameters.add(IntroduceParameterObjectDescriptor.PARAMETER_OBJECT);
                continue;
            }
            IntroduceParameterObjectDescriptor.Parameter parameter = new IntroduceParameterObjectDescriptor.Parameter(pi.getOldIndex());
            if (pi.isCreateField()) {
                parameter.setCreateField(true);
                parameter.setFieldName(pi.getNewName());
            }
            parameters.add(parameter);
        }
        ipod.setParameters(parameters.toArray(new IntroduceParameterObjectDescriptor.Parameter[parameters.size()]));
        String project = this.getCompilationUnit().getJavaProject().getElementName();
        try {
            ipod.setComment(this.createComment(project).asString());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        ipod.setProject(project);
        ipod.setDescription(this.getProcessorName());
        ipod.setFlags(this.getDescriptorFlags());
        return ipod;
    }

    private JDTRefactoringDescriptorComment createComment(String project) throws JavaModelException {
        String header = Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_description, this.getOldMethodSignature());
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_object_class, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getClassName())));
        if (this.fCreateAsTopLevel) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_package, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getPackage())));
        } else {
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_enclosing_type, BasicElementLabels.getJavaElementName(this.fParameterObjectFactory.getEnclosingType())));
        }
        List<ParameterInfo> infos = this.getParameterInfos();
        ArrayList<String> kept = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        for (ParameterInfo pi : infos) {
            if (pi.isCreateField()) {
                fields.add(pi.getNewName());
                continue;
            }
            if (pi.isAdded()) continue;
            kept.add(pi.getNewName());
        }
        comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_fields, fields.toArray(new String[0])));
        if (!kept.isEmpty()) {
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_keep_parameter, kept.toArray(new String[0])));
        }
        if (this.fParameterObjectFactory.isCreateGetter()) {
            comment.addSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_create_getter);
        }
        if (this.fParameterObjectFactory.isCreateSetter()) {
            comment.addSetting(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_descriptor_create_setter);
        }
        return comment;
    }

    @Override
    protected String doGetRefactoringChangeName() {
        return this.getProcessorName();
    }

    public String getParameterName() {
        return this.fParameterObjectReference.getNewName();
    }

    public boolean isCreateGetter() {
        return this.fParameterObjectFactory.isCreateGetter();
    }

    public boolean isCreateSetter() {
        return this.fParameterObjectFactory.isCreateSetter();
    }

    public boolean isCreateAsTopLevel() {
        return this.fCreateAsTopLevel;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() & !pi.isAdded();
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    public void moveFieldDown(ParameterInfo selected) {
        this.fParameterObjectFactory.moveDown(selected);
    }

    public void moveFieldUp(ParameterInfo selected) {
        this.fParameterObjectFactory.moveUp(selected);
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotanalysemethod_compilererror, new String[]{messages[0].getMessage()}));
        return true;
    }

    public void setClassName(String className) {
        this.fParameterObjectFactory.setClassName(className);
        this.updateReferenceType();
    }

    private void updateReferenceType() {
        if (this.fCreateAsTopLevel) {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getPackage(), this.fParameterObjectFactory.getClassName()));
        } else {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getEnclosingType(), this.fParameterObjectFactory.getClassName()));
        }
    }

    public void setCreateGetter(boolean createGetter) {
        this.fParameterObjectFactory.setCreateGetter(createGetter);
    }

    public void setCreateSetter(boolean createSetter) {
        this.fParameterObjectFactory.setCreateSetter(createSetter);
    }

    public void setPackageName(String packageName) {
        this.fParameterObjectFactory.setPackage(packageName);
        this.updateReferenceType();
    }

    public void setParameterName(String paramName) {
        this.fParameterObjectReference.setNewName(paramName);
    }

    public void setCreateAsTopLevel(boolean topLevel) {
        this.fCreateAsTopLevel = topLevel;
        this.updateReferenceType();
    }

    public void updateParameterPosition() {
        this.fParameterObjectFactory.updateParameterPosition(this.fParameterObjectReference);
    }

    private void createParameterClass(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite) throws CoreException {
        if (this.fCreateAsTopLevel) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)cuRewrite.getCu().getAncestor(3);
            this.fOtherChanges.addAll(this.fParameterObjectFactory.createTopLevelParameterObject(root));
        } else {
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            TypeDeclaration enclosingType = (TypeDeclaration)methodDeclaration.getParent();
            ListRewrite bodyRewrite = rewriter.getListRewrite(enclosingType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            String fqn = enclosingType.getName().getFullyQualifiedName();
            TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(fqn, cuRewrite, null);
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            bodyRewrite.insertBefore(classDeclaration, methodDeclaration, null);
        }
    }

    public String getPackage() {
        return this.fParameterObjectFactory.getPackage();
    }

    public void setPackage(String typeQualifier) {
        this.fParameterObjectFactory.setPackage(typeQualifier);
    }

    private String getNameInScope(ParameterInfo pi, List<SingleVariableDeclaration> enclosingMethodParameters) {
        boolean emptyVararg;
        Assert.isNotNull(enclosingMethodParameters);
        boolean bl = emptyVararg = pi.getOldIndex() >= enclosingMethodParameters.size();
        if (!emptyVararg) {
            SingleVariableDeclaration svd = enclosingMethodParameters.get(pi.getOldIndex());
            return svd.getName().getIdentifier();
        }
        return null;
    }

    public String getNewTypeName() {
        return this.fParameterObjectReference.getNewTypeName();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.getBaseCuRewrite().getCu();
    }

    @Override
    protected int getDescriptorFlags() {
        return super.getDescriptorFlags() | 0x40000;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ParameterObjectCreator
    implements IDefaultValueAdvisor {
        private ParameterObjectCreator() {
        }

        @Override
        public Expression createDefaultExpression(List<Expression> invocationArguments, ParameterInfo addedInfo, List<ParameterInfo> parameterInfos, MethodDeclaration enclosingMethod, boolean isRecursive, CompilationUnitRewrite cuRewrite) {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (isRecursive && this.canReuseParameterObject(invocationArguments, addedInfo, parameterInfos, enclosingMethod)) {
                return ast.newSimpleName(addedInfo.getNewName());
            }
            ClassInstanceCreation classCreation = ast.newClassInstanceCreation();
            int startPosition = enclosingMethod != null ? enclosingMethod.getStartPosition() : cuRewrite.getRoot().getStartPosition();
            ContextSensitiveImportRewriteContext context = IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createParameterClassAwareContext(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, startPosition);
            classCreation.setType(IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, startPosition));
            List constructorArguments = classCreation.arguments();
            Iterator<ParameterInfo> iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = iter.next();
                if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                if (pi.isOldVarargs()) {
                    boolean isLastParameter = !iter.hasNext();
                    constructorArguments.addAll(this.computeVarargs(invocationArguments, pi, isLastParameter, cuRewrite, context));
                    continue;
                }
                Expression exp = invocationArguments.get(pi.getOldIndex());
                this.importNodeTypes(exp, cuRewrite, context);
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode(exp, rewrite));
            }
            return classCreation;
        }

        @Override
        public Type createType(String newTypeName, int startPosition, CompilationUnitRewrite cuRewrite) {
            return IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, startPosition);
        }

        private boolean canReuseParameterObject(List<Expression> invocationArguments, ParameterInfo addedInfo, List<ParameterInfo> parameterInfos, MethodDeclaration enclosingMethod) {
            Assert.isNotNull(enclosingMethod);
            List parameters = enclosingMethod.parameters();
            for (ParameterInfo pi : parameterInfos) {
                if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                if (!pi.isInlined()) {
                    return false;
                }
                ASTNode node = invocationArguments.get(pi.getOldIndex());
                if (IntroduceParameterObjectProcessor.this.isParameter(pi, node, parameters, addedInfo.getNewName())) continue;
                return false;
            }
            return true;
        }

        private List<Expression> computeVarargs(List<Expression> invocationArguments, ParameterInfo varArgPI, boolean isLastParameter, CompilationUnitRewrite cuRewrite, ContextSensitiveImportRewriteContext context) {
            ArrayCreation creation;
            ITypeBinding arrayType;
            boolean isEmptyVarArg = varArgPI.getOldIndex() >= invocationArguments.size();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            Expression lastNode = isEmptyVarArg ? null : invocationArguments.get(varArgPI.getOldIndex());
            ArrayList<Expression> constructorArguments = new ArrayList<Expression>();
            if (lastNode instanceof ArrayCreation && (arrayType = (creation = (ArrayCreation)lastNode).resolveTypeBinding()) != null && arrayType.isAssignmentCompatible(varArgPI.getNewTypeBinding())) {
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode(creation, rewrite));
                return constructorArguments;
            }
            if (isLastParameter) {
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    Expression node = invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite, context);
                    constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode(node, rewrite));
                    ++i;
                }
            } else if (lastNode instanceof NullLiteral) {
                NullLiteral nullLiteral = (NullLiteral)lastNode;
                constructorArguments.add(IntroduceParameterObjectProcessor.this.moveNode(nullLiteral, rewrite));
            } else {
                creation = ast.newArrayCreation();
                creation.setType((ArrayType)this.importBinding(varArgPI.getNewTypeBinding(), cuRewrite, context));
                ArrayInitializer initializer = ast.newArrayInitializer();
                List expressions = initializer.expressions();
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    Expression node = invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite, context);
                    expressions.add(IntroduceParameterObjectProcessor.this.moveNode(node, rewrite));
                    ++i;
                }
                if (expressions.isEmpty()) {
                    creation.dimensions().add(ast.newNumberLiteral("0"));
                } else {
                    creation.setInitializer(initializer);
                }
                constructorArguments.add(creation);
            }
            return constructorArguments;
        }

        public Type importBinding(ITypeBinding newTypeBinding, CompilationUnitRewrite cuRewrite, ImportRewrite.ImportRewriteContext context) {
            Type type = cuRewrite.getImportRewrite().addImport(newTypeBinding, cuRewrite.getAST(), context);
            cuRewrite.getImportRemover().registerAddedImports(type);
            return type;
        }

        private void importNodeTypes(ASTNode node, final CompilationUnitRewrite cuRewrite, final ImportRewrite.ImportRewriteContext context) {
            ASTResolving.visitAllBindings(node, new TypeBindingVisitor(){

                public boolean visit(ITypeBinding nodeBinding) {
                    ParameterObjectCreator.this.importBinding(nodeBinding, cuRewrite, context);
                    return false;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RewriteParameterBody
    extends BodyUpdater {
        private RewriteParameterBody() {
        }

        @Override
        public void updateBody(MethodDeclaration methodDeclaration, final CompilationUnitRewrite cuRewrite, RefactoringStatus result) throws CoreException {
            IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createType(IntroduceParameterObjectProcessor.this.fCreateAsTopLevel, cuRewrite, methodDeclaration.getStartPosition());
            if (cuRewrite.getCu().equals(IntroduceParameterObjectProcessor.this.getCompilationUnit()) && !IntroduceParameterObjectProcessor.this.fParameterClassCreated) {
                IntroduceParameterObjectProcessor.this.createParameterClass(methodDeclaration, cuRewrite);
                IntroduceParameterObjectProcessor.this.fParameterClassCreated = true;
            }
            Block body = methodDeclaration.getBody();
            final List parameters = methodDeclaration.parameters();
            if (body != null) {
                final ASTRewrite rewriter = cuRewrite.getASTRewrite();
                ListRewrite bodyStatements = rewriter.getListRewrite(body, Block.STATEMENTS_PROPERTY);
                List<ParameterInfo> managedParams = IntroduceParameterObjectProcessor.this.getParameterInfos();
                for (final ParameterInfo pi : managedParams) {
                    if (!IntroduceParameterObjectProcessor.this.isValidField(pi)) continue;
                    if (this.isReadOnly(pi, body, parameters, null)) {
                        body.accept(new ASTVisitor(false){

                            public boolean visit(SimpleName node) {
                                RewriteParameterBody.this.updateSimpleName(rewriter, pi, node, parameters, cuRewrite.getCu().getJavaProject());
                                return false;
                            }
                        });
                        pi.setInlined(true);
                        continue;
                    }
                    ExpressionStatement initializer = IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createInitializer(pi, IntroduceParameterObjectProcessor.this.getParameterName(), cuRewrite);
                    bodyStatements.insertFirst(initializer, null);
                }
            }
        }

        private void updateSimpleName(ASTRewrite rewriter, ParameterInfo pi, SimpleName node, List<SingleVariableDeclaration> enclosingParameters, IJavaProject project) {
            AST ast = rewriter.getAST();
            IBinding binding = node.resolveBinding();
            Expression replacementNode = IntroduceParameterObjectProcessor.this.fParameterObjectFactory.createFieldReadAccess(pi, IntroduceParameterObjectProcessor.this.getParameterName(), ast, project, false, null);
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                if (variable.isParameter() && variable.getName().equals(IntroduceParameterObjectProcessor.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace(node, replacementNode, null);
                }
            } else {
                ASTNode parent = node.getParent();
                if (!(parent instanceof QualifiedName) && !(parent instanceof FieldAccess) && !(parent instanceof SuperFieldAccess) && node.getIdentifier().equals(IntroduceParameterObjectProcessor.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace(node, replacementNode, null);
                }
            }
        }

        private boolean isReadOnly(ParameterInfo pi, Block block, List<SingleVariableDeclaration> enclosingMethodParameters, String qualifier) {
            class NotWrittenDetector
            extends ASTVisitor {
                boolean notWritten = true;
                private final /* synthetic */ ParameterInfo val$pi;
                private final /* synthetic */ List val$enclosingMethodParameters;
                private final /* synthetic */ String val$qualifier;

                NotWrittenDetector(ParameterInfo parameterInfo, List list, String string) {
                    this.val$pi = parameterInfo;
                    this.val$enclosingMethodParameters = list;
                    this.val$qualifier = string;
                }

                public boolean visit(SimpleName node) {
                    if (IntroduceParameterObjectProcessor.this.isParameter(this.val$pi, node, this.val$enclosingMethodParameters, this.val$qualifier) && ASTResolving.isWriteAccess(node)) {
                        this.notWritten = false;
                    }
                    return false;
                }

                public boolean visit(SuperFieldAccess node) {
                    return false;
                }
            }
            NotWrittenDetector visitor = new NotWrittenDetector(pi, enclosingMethodParameters, qualifier);
            block.accept(visitor);
            return visitor.notWritten;
        }

        @Override
        public boolean needsParameterUsedCheck() {
            return false;
        }
    }
}

