/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.MoveMethodDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MoveInstanceMethodProcessor
extends MoveProcessor
implements IDelegateUpdating {
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_INLINE = "inline";
    private static final String ATTRIBUTE_REMOVE = "remove";
    private static final String ATTRIBUTE_TARGET_INDEX = "targetIndex";
    private static final String ATTRIBUTE_TARGET_NAME = "targetName";
    private static final String ATTRIBUTE_USE_GETTER = "getter";
    private static final String ATTRIBUTE_USE_SETTER = "setter";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.moveInstanceMethodProcessor";
    private IVariableBinding[] fCandidateTargets = new IVariableBinding[0];
    private TextChangeManager fChangeManager = null;
    private boolean fDelegateDeprecation = true;
    private boolean fDelegatingUpdating;
    private boolean fInline = false;
    private IMethod fMethod;
    private String fMethodName;
    private IVariableBinding[] fPossibleTargets = new IVariableBinding[0];
    private boolean fRemove = false;
    private CodeGenerationSettings fSettings;
    private CompilationUnitRewrite fSourceRewrite;
    private IVariableBinding fTarget = null;
    private String fTargetName;
    private boolean fTargetNode = true;
    private IType fTargetType = null;
    private boolean fUseGetters = true;
    private boolean fUseSetters = true;

    protected static IVariableBinding[] getArgumentBindings(MethodDeclaration declaration) {
        Assert.isNotNull(declaration);
        ArrayList<IVariableBinding> parameters = new ArrayList<IVariableBinding>(declaration.parameters().size());
        for (VariableDeclaration variable : declaration.parameters()) {
            IVariableBinding binding = variable.resolveBinding();
            if (binding == null) {
                return new IVariableBinding[0];
            }
            parameters.add(binding);
        }
        IVariableBinding[] result = new IVariableBinding[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    protected static ITypeBinding[] getArgumentTypes(MethodDeclaration declaration) {
        Assert.isNotNull(declaration);
        IVariableBinding[] parameters = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
        ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>(parameters.length);
        IVariableBinding binding = null;
        ITypeBinding type = null;
        int index = 0;
        while (index < parameters.length) {
            binding = parameters[index];
            type = binding.getType();
            if (type != null) {
                types.add(type);
            }
            ++index;
        }
        ITypeBinding[] result = new ITypeBinding[types.size()];
        types.toArray(result);
        return result;
    }

    protected static boolean isFieldAccess(SimpleName name) {
        QualifiedName qualified;
        ITypeBinding type;
        ASTNode parent;
        Assert.isNotNull(name);
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variable = (IVariableBinding)binding;
        if (!variable.isField()) {
            return false;
        }
        if ("length".equals(name.getIdentifier()) && (parent = name.getParent()) instanceof QualifiedName && (type = (qualified = (QualifiedName)parent).getQualifier().resolveTypeBinding()) != null && type.isArray()) {
            return false;
        }
        return !Modifier.isStatic(variable.getModifiers());
    }

    public MoveInstanceMethodProcessor(IMethod method, CodeGenerationSettings settings) {
        this.fSettings = settings;
        this.fMethod = method;
        if (method != null) {
            this.initialize(method);
        }
    }

    public MoveInstanceMethodProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    @Override
    public final boolean canEnableDelegateUpdating() {
        return true;
    }

    protected void checkConflictingMethod(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        IMethod[] methods = this.fTargetType.getMethods();
        try {
            monitor.beginTask("", methods.length);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            IMethod method = null;
            int index = 0;
            while (index < methods.length) {
                method = methods[index];
                int newParamCount = this.fMethod.getParameterTypes().length;
                if (this.needsTargetNode()) {
                    --newParamCount;
                }
                if (method.getElementName().equals(this.fMethodName) && method.getParameterTypes().length == newParamCount) {
                    status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_already_exists, new String[]{BasicElementLabels.getJavaElementName(this.fMethodName), BasicElementLabels.getJavaElementName(this.fTargetType.getElementName())}), (RefactoringStatusContext)JavaStatusContext.create(method)));
                }
                monitor.worked(1);
                ++index;
            }
            if (this.fMethodName.equals(this.fTargetType.getElementName())) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_type_clash, BasicElementLabels.getJavaElementName(this.fMethodName)), (RefactoringStatusContext)JavaStatusContext.create(this.fTargetType)));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void checkConflictingTarget(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
        VariableDeclaration variable2 = null;
        List parameters = declaration.parameters();
        try {
            monitor.beginTask("", parameters.size());
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            for (VariableDeclaration variable2 : parameters) {
                if (this.fTargetName.equals(variable2.getName().getIdentifier())) {
                    status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_target_name_already_used, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
                    break;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        Assert.isNotNull(context);
        Assert.isNotNull(this.fTarget);
        RefactoringStatus status = new RefactoringStatus();
        this.fChangeManager = new TextChangeManager();
        try {
            monitor.beginTask("", 4);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            status.merge(Checks.checkIfCuBroken(this.fMethod));
            if (!status.hasError()) {
                this.checkGenericTarget(new SubProgressMonitor(monitor, 1), status);
                if (status.isOK()) {
                    IType type = this.getTargetType();
                    if (type != null) {
                        if (type.isBinary() || type.isReadOnly() || !this.fMethod.exists() || this.fMethod.isBinary() || this.fMethod.isReadOnly()) {
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
                        } else {
                            status.merge(Checks.checkIfCuBroken(type));
                            if (!status.hasError()) {
                                if (!type.exists() || type.isBinary() || type.isReadOnly()) {
                                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
                                }
                                this.checkConflictingTarget(new SubProgressMonitor(monitor, 1), status);
                                this.checkConflictingMethod(new SubProgressMonitor(monitor, 1), status);
                                Checks.addModifiedFilesToChecker(this.computeModifiedFiles(this.fMethod.getCompilationUnit(), type.getCompilationUnit()), context);
                                monitor.worked(1);
                                if (!status.hasFatalError()) {
                                    this.fChangeManager = this.createChangeManager(status, new SubProgressMonitor(monitor, 1));
                                }
                            }
                        }
                    } else {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_resolved_target, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void checkGenericTarget(IProgressMonitor monitor, RefactoringStatus status) {
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            ITypeBinding binding = this.fTarget.getType();
            if (binding == null || binding.isTypeVariable()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_generic_targets, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void checkGenericTypes(IProgressMonitor monitor, MethodDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull(monitor);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            GenericReferenceFinder finder = new GenericReferenceFinder(declaration);
            declaration.accept(finder);
            if (!finder.getStatus().isOK()) {
                status.merge(finder.getStatus());
            }
        }
        finally {
            monitor.done();
        }
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 4);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            status.merge(Checks.checkIfCuBroken(this.fMethod));
            if (!status.hasError()) {
                this.checkMethodDeclaration(new SubProgressMonitor(monitor, 1), status);
                if (status.isOK()) {
                    MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
                    this.checkGenericTypes(new SubProgressMonitor(monitor, 1), declaration, status);
                    this.checkMethodBody(new SubProgressMonitor(monitor, 1), declaration, status);
                    this.checkPossibleTargets(new SubProgressMonitor(monitor, 1), declaration, status);
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void checkMethodBody(IProgressMonitor monitor, MethodDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull(monitor);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        try {
            ITypeBinding declaring;
            monitor.beginTask("", 3);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            AstNodeFinder finder = new SuperReferenceFinder();
            declaration.accept(finder);
            if (!finder.getStatus().isOK()) {
                status.merge(finder.getStatus());
            }
            monitor.worked(1);
            finder = null;
            IMethodBinding binding = declaration.resolveBinding();
            if (binding != null && (declaring = binding.getDeclaringClass()) != null) {
                finder = new EnclosingInstanceReferenceFinder(declaring);
            }
            if (finder != null) {
                declaration.accept(finder);
                if (!finder.getStatus().isOK()) {
                    status.merge(finder.getStatus());
                }
                monitor.worked(1);
                finder = new RecursiveCallFinder(declaration);
                declaration.accept(finder);
                if (!finder.getStatus().isOK()) {
                    status.merge(finder.getStatus());
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void checkMethodDeclaration(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        try {
            monitor.beginTask("", 5);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            int flags = this.fMethod.getFlags();
            if (Flags.isStatic(flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_static_methods, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            } else if (Flags.isAbstract(flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_single_implementation, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
            monitor.worked(1);
            if (Flags.isNative(flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_native_methods, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
            monitor.worked(1);
            if (Flags.isSynchronized(flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_synchronized_methods, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
            monitor.worked(1);
            if (this.fMethod.isConstructor()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_constructors, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
            monitor.worked(1);
            if (this.fMethod.getDeclaringType().isAnnotation()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_annotation, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            } else if (this.fMethod.getDeclaringType().isInterface()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_interface, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    protected void checkPossibleTargets(IProgressMonitor monitor, MethodDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull(monitor);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            if (this.computeTargetCategories(declaration).length < 1) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_cannot_be_moved, (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected SearchResultGroup[] computeMethodReferences(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            SearchPattern pattern = SearchPattern.createPattern(this.fMethod, 2, 24);
            IJavaSearchScope scope = RefactoringScopeFactory.create(this.fMethod, true, false);
            String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.fMethod.getElementName()));
            ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
            CollectingSearchRequestor requestor = new CollectingSearchRequestor(binaryRefs);
            SearchResultGroup[] result = RefactoringSearchEngine.search(pattern, scope, requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            binaryRefs.addErrorIfNecessary(status);
            SearchResultGroup[] searchResultGroupArray = result;
            return searchResultGroupArray;
        }
        finally {
            monitor.done();
        }
    }

    protected IFile[] computeModifiedFiles(ICompilationUnit source, ICompilationUnit target) {
        Assert.isNotNull(source);
        Assert.isNotNull(target);
        if (source.equals(target)) {
            return ResourceUtil.getFiles(new ICompilationUnit[]{source});
        }
        return ResourceUtil.getFiles(new ICompilationUnit[]{source, target});
    }

    protected String[] computeReservedIdentifiers() throws JavaModelException {
        ArrayList<String> names = new ArrayList<String>();
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
        if (declaration != null) {
            List parameters = declaration.parameters();
            VariableDeclaration variable = null;
            int index = 0;
            while (index < parameters.size()) {
                variable = (VariableDeclaration)parameters.get(index);
                names.add(variable.getName().getIdentifier());
                ++index;
            }
            Block body = declaration.getBody();
            if (body != null) {
                IBinding[] bindings = new ScopeAnalyzer(this.fSourceRewrite.getRoot()).getDeclarationsAfter(body.getStartPosition(), 2);
                int index2 = 0;
                while (index2 < bindings.length) {
                    names.add(bindings[index2].getName());
                    ++index2;
                }
            }
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    protected IVariableBinding[] computeTargetCategories(MethodDeclaration declaration) {
        Assert.isNotNull(declaration);
        if (this.fPossibleTargets.length == 0 || this.fCandidateTargets.length == 0) {
            ArrayList<IVariableBinding> possibleTargets = new ArrayList<IVariableBinding>(16);
            ArrayList<IVariableBinding> candidateTargets = new ArrayList<IVariableBinding>(16);
            IMethodBinding method = declaration.resolveBinding();
            if (method != null) {
                ITypeBinding declaring = method.getDeclaringClass();
                IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
                ITypeBinding binding = null;
                int index = 0;
                while (index < bindings.length) {
                    binding = bindings[index].getType();
                    if ((binding.isClass() || binding.isEnum()) && binding.isFromSource()) {
                        possibleTargets.add(bindings[index]);
                        candidateTargets.add(bindings[index]);
                    }
                    ++index;
                }
                ReadyOnlyFieldFinder visitor = new ReadyOnlyFieldFinder(declaring);
                declaration.accept(visitor);
                bindings = visitor.getReadOnlyFields();
                int index2 = 0;
                while (index2 < bindings.length) {
                    binding = bindings[index2].getType();
                    if (binding.isClass() && binding.isFromSource()) {
                        possibleTargets.add(bindings[index2]);
                    }
                    ++index2;
                }
                bindings = visitor.getDeclaredFields();
                index2 = 0;
                while (index2 < bindings.length) {
                    binding = bindings[index2].getType();
                    if (binding.isClass() && binding.isFromSource()) {
                        candidateTargets.add(bindings[index2]);
                    }
                    ++index2;
                }
            }
            this.fPossibleTargets = new IVariableBinding[possibleTargets.size()];
            possibleTargets.toArray(this.fPossibleTargets);
            this.fCandidateTargets = new IVariableBinding[candidateTargets.size()];
            candidateTargets.toArray(this.fCandidateTargets);
        }
        return this.fPossibleTargets;
    }

    protected Expression createAdjustedTargetExpression(IJavaElement enclosingElement, Expression expression, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, ASTRewrite rewrite) throws JavaModelException {
        IField field;
        Assert.isNotNull(enclosingElement);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(rewrite);
        IJavaElement element = this.fTarget.getJavaElement();
        if (element != null && !Modifier.isPublic(this.fTarget.getModifiers()) && (field = (IField)this.fTarget.getJavaElement()) != null) {
            MethodDeclaration method;
            IMethod getter;
            String modifier;
            boolean same = field.getAncestor(4).equals(enclosingElement.getAncestor(4));
            Modifier.ModifierKeyword keyword = same ? null : Modifier.ModifierKeyword.PUBLIC_KEYWORD;
            String string = modifier = same ? RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default : RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
            if (this.fUseGetters && (getter = GetterSetterUtil.getGetter(field)) != null && (method = ASTNodeSearchUtil.getMethodDeclarationNode(getter, this.fSourceRewrite.getRoot())) != null) {
                IMethodBinding binding = method.resolveBinding();
                if (binding != null && MemberVisibilityAdjustor.hasLowerVisibility(getter.getFlags(), same ? 0 : (keyword == null ? 0 : keyword.toFlagValue())) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)getter, keyword, adjustments)) {
                    adjustments.put(getter, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(getter, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{BindingLabelProvider.getBindingLabel(binding, JavaElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create(getter))));
                }
                MethodInvocation invocation = rewrite.getAST().newMethodInvocation();
                invocation.setExpression(expression);
                invocation.setName(rewrite.getAST().newSimpleName(getter.getElementName()));
                return invocation;
            }
            if (MemberVisibilityAdjustor.hasLowerVisibility(field.getFlags(), keyword == null ? 0 : keyword.toFlagValue()) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)field, keyword, adjustments)) {
                adjustments.put(field, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(field, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning, new String[]{BindingLabelProvider.getBindingLabel(this.fTarget, JavaElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create(field))));
            }
        }
        return null;
    }

    protected boolean createArgumentList(MethodDeclaration declaration, List<ASTNode> arguments, IArgumentFactory factory) throws JavaModelException {
        Assert.isNotNull(declaration);
        Assert.isNotNull(arguments);
        Assert.isNotNull(factory);
        ThisReferenceFinder finder = new ThisReferenceFinder();
        declaration.accept(finder);
        IVariableBinding binding = null;
        VariableDeclaration variable = null;
        boolean added = false;
        int size = declaration.parameters().size();
        int index = 0;
        while (index < size) {
            variable = (VariableDeclaration)declaration.parameters().get(index);
            binding = variable.resolveBinding();
            if (binding != null) {
                if (!Bindings.equals(binding, this.fTarget)) {
                    arguments.add(factory.getArgumentNode(binding, index == size - 1));
                } else if (!finder.getStatus().isOK()) {
                    arguments.add(factory.getTargetNode());
                    added = true;
                }
            } else {
                arguments.add(factory.getArgumentNode(binding, index == size - 1));
            }
            ++index;
        }
        if (!finder.getStatus().isOK() && !added) {
            arguments.add(0, factory.getTargetNode());
            added = true;
        }
        return added;
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", 6);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            TextChange[] changes = this.fChangeManager.getAllChanges();
            if (changes.length == 1) {
                TextChange textChange = changes[0];
                return textChange;
            }
            ArrayList<TextChange> list = new ArrayList<TextChange>(changes.length);
            list.addAll(Arrays.asList(changes));
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fMethod.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 786438;
            IType declaring = this.fMethod.getDeclaringType();
            try {
                if (declaring.isAnonymous() || declaring.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fMethod.getElementName()));
            String header = Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel(this.fMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel(this.fTarget, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_moved_element_pattern, RefactoringCoreMessages.JavaRefactoringDescriptor_not_available));
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_target_element_pattern, BindingLabelProvider.getBindingLabel(this.fTarget, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_name_pattern, BasicElementLabels.getJavaElementName(this.getMethodName())));
            if (this.needsTargetNode()) {
                comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_parameter_name_pattern, BasicElementLabels.getJavaElementName(this.getTargetName())));
            }
            MoveMethodDescriptor descriptor = RefactoringSignatureDescriptorFactory.createMoveMethodDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, this.fMethod));
            arguments.put("name", this.fMethodName);
            arguments.put(ATTRIBUTE_TARGET_NAME, this.fTargetName);
            arguments.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDelegateDeprecation).toString());
            arguments.put(ATTRIBUTE_REMOVE, Boolean.valueOf(this.fRemove).toString());
            arguments.put(ATTRIBUTE_INLINE, Boolean.valueOf(this.fInline).toString());
            arguments.put(ATTRIBUTE_USE_GETTER, Boolean.valueOf(this.fUseGetters).toString());
            arguments.put(ATTRIBUTE_USE_SETTER, Boolean.valueOf(this.fUseSetters).toString());
            arguments.put(ATTRIBUTE_TARGET_INDEX, new Integer(this.getTargetIndex()).toString());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.MoveInstanceMethodRefactoring_name, list.toArray(new Change[list.size()]));
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected TextChangeManager createChangeManager(RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException, CoreException {
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            MemberVisibilityAdjustor.IVisibilityAdjustment adjustmentForTarget;
            IJavaElement targetElement;
            monitor.beginTask("", 7);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            this.fSourceRewrite.clearASTAndImportRewrites();
            TextChangeManager manager = new TextChangeManager();
            CompilationUnitRewrite targetRewrite = this.fMethod.getCompilationUnit().equals(this.getTargetType().getCompilationUnit()) ? this.fSourceRewrite : new CompilationUnitRewrite(this.getTargetType().getCompilationUnit());
            MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
            SearchResultGroup[] references = this.computeMethodReferences(new SubProgressMonitor(monitor, 1), status);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            rewrites.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            if (!this.fSourceRewrite.getCu().equals(targetRewrite.getCu())) {
                rewrites.put(targetRewrite.getCu(), targetRewrite);
            }
            ASTRewrite sourceRewrite = ASTRewrite.create(this.fSourceRewrite.getRoot().getAST());
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor(this.fTargetType, this.fMethod);
            adjustor.setStatus(status);
            adjustor.setVisibilitySeverity(2);
            adjustor.setFailureSeverity(2);
            adjustor.setRewrites(rewrites);
            adjustor.setRewrite(sourceRewrite, this.fSourceRewrite.getRoot());
            adjustor.adjustVisibility(new SubProgressMonitor(monitor, 1));
            Document document = new Document(this.fMethod.getCompilationUnit().getBuffer().getContents());
            boolean target = this.createMethodCopy((IDocument)document, declaration, sourceRewrite, rewrites, adjustor.getAdjustments(), status, new SubProgressMonitor(monitor, 1));
            this.createMethodJavadocReferences(rewrites, declaration, references, target, status, new SubProgressMonitor(monitor, 1));
            if (!this.fSourceRewrite.getCu().equals(targetRewrite.getCu())) {
                this.createMethodImports(targetRewrite, declaration, new SubProgressMonitor(monitor, 1), status);
            }
            boolean removable = false;
            if (this.fInline) {
                String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.getMethod().getElementName()));
                ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
                removable = this.createMethodDelegator(rewrites, declaration, references, adjustor.getAdjustments(), target, binaryRefs, status, new SubProgressMonitor(monitor, 1));
                binaryRefs.addErrorIfNecessary(status);
                if (this.fRemove && removable) {
                    this.fSourceRewrite.getASTRewrite().remove(declaration, this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_remove_original_method));
                    if (!this.fSourceRewrite.getCu().equals(this.fTargetType.getCompilationUnit())) {
                        this.fSourceRewrite.getImportRemover().registerRemovedNode(declaration);
                    }
                }
            }
            if (!this.fRemove || !removable) {
                this.createMethodDelegation(declaration, rewrites, adjustor.getAdjustments(), status, new SubProgressMonitor(monitor, 1));
            }
            if ((targetElement = this.fTarget.getJavaElement()) != null && targetElement instanceof IField && (Flags.isPrivate(this.fMethod.getFlags()) || !this.fInline) && (adjustmentForTarget = (MemberVisibilityAdjustor.IVisibilityAdjustment)adjustor.getAdjustments().get(targetElement)) != null) {
                adjustor.getAdjustments().remove(targetElement);
            }
            adjustor.rewriteVisibility(new SubProgressMonitor(monitor, 1));
            sourceRewrite.rewriteAST((IDocument)document, this.fMethod.getJavaProject().getOptions(true));
            this.createMethodSignature((IDocument)document, declaration, sourceRewrite, rewrites);
            ICompilationUnit unit2 = null;
            CompilationUnitRewrite rewrite = null;
            for (ICompilationUnit unit2 : rewrites.keySet()) {
                rewrite = (CompilationUnitRewrite)rewrites.get(unit2);
                manager.manage(unit2, (TextChange)rewrite.createChange(true));
            }
            TextChangeManager textChangeManager = manager;
            return textChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean createInlinedMethodInvocation(CompilationUnitRewrite rewriter, MethodDeclaration declaration, SearchMatch match, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, boolean target, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(rewriter);
        Assert.isNotNull(declaration);
        Assert.isNotNull(match);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(status);
        boolean result = true;
        ASTRewrite rewrite = rewriter.getASTRewrite();
        ASTNode node = ASTNodeSearchUtil.findNode(match, rewriter.getRoot());
        TextEditGroup group = rewriter.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_method_invocation);
        if (node instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)node;
            ListRewrite list = rewrite.getListRewrite(invocation, MethodInvocation.ARGUMENTS_PROPERTY);
            if (this.fTarget.isField()) {
                Expression access = null;
                if (invocation.getExpression() != null) {
                    access = this.createInlinedTargetExpression(rewriter, (IJavaElement)match.getElement(), invocation.getExpression(), adjustments, status);
                    rewrite.set(invocation, MethodInvocation.EXPRESSION_PROPERTY, access, group);
                } else {
                    rewrite.set(invocation, MethodInvocation.EXPRESSION_PROPERTY, rewrite.getAST().newSimpleName(this.fTarget.getName()), group);
                }
                if (target) {
                    if (access == null || !(access instanceof FieldAccess)) {
                        list.insertFirst(rewrite.getAST().newThisExpression(), null);
                    } else {
                        list.insertFirst(rewrite.createCopyTarget(invocation.getExpression()), null);
                    }
                }
            } else {
                IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
                if (bindings.length > 0) {
                    int index = 0;
                    while (index < bindings.length) {
                        if (Bindings.equals(bindings[index], this.fTarget)) break;
                        ++index;
                    }
                    if (index < bindings.length && invocation.arguments().size() > index) {
                        Expression argument = (Expression)invocation.arguments().get(index);
                        if (argument instanceof NullLiteral) {
                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_no_null_argument, BindingLabelProvider.getBindingLabel(declaration.resolveBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)rewriter.getCu(), invocation)));
                            result = false;
                        } else {
                            if (argument instanceof ThisExpression) {
                                rewrite.remove(invocation.getExpression(), null);
                            } else {
                                rewrite.set(invocation, MethodInvocation.EXPRESSION_PROPERTY, rewrite.createCopyTarget(argument), group);
                            }
                            if (target) {
                                if (invocation.getExpression() != null) {
                                    list.replace(argument, rewrite.createCopyTarget(invocation.getExpression()), group);
                                } else {
                                    ThisExpression expression = rewrite.getAST().newThisExpression();
                                    AbstractTypeDeclaration member = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)invocation, AbstractTypeDeclaration.class);
                                    if (member != null) {
                                        ITypeBinding declaring;
                                        IMethodBinding method;
                                        ITypeBinding resolved = member.resolveBinding();
                                        if ((ASTNodes.getParent((ASTNode)invocation, AnonymousClassDeclaration.class) != null || resolved != null && resolved.isMember()) && (method = declaration.resolveBinding()) != null && (declaring = method.getDeclaringClass()) != null) {
                                            expression.setQualifier(rewrite.getAST().newSimpleName(declaring.getName()));
                                        }
                                    }
                                    list.replace(argument, expression, group);
                                }
                            } else {
                                list.remove(argument, group);
                            }
                        }
                    }
                }
            }
            if (result) {
                rewrite.set(invocation, MethodInvocation.NAME_PROPERTY, rewrite.getAST().newSimpleName(this.fMethodName), group);
            }
        }
        return result;
    }

    protected Expression createInlinedTargetExpression(CompilationUnitRewrite rewriter, IJavaElement enclosingElement, Expression original, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(rewriter);
        Assert.isNotNull(enclosingElement);
        Assert.isNotNull(original);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(status);
        Assert.isTrue(this.fTarget.isField());
        Expression expression = (Expression)ASTNode.copySubtree(this.fSourceRewrite.getASTRewrite().getAST(), original);
        Expression result = this.createAdjustedTargetExpression(enclosingElement, expression, adjustments, this.fSourceRewrite.getASTRewrite());
        if (result == null) {
            FieldAccess access = this.fSourceRewrite.getASTRewrite().getAST().newFieldAccess();
            access.setExpression(expression);
            access.setName(this.fSourceRewrite.getASTRewrite().getAST().newSimpleName(this.fTarget.getName()));
            return access;
        }
        return result;
    }

    protected boolean createMethodArguments(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, ASTRewrite rewrite, final MethodDeclaration declaration, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, RefactoringStatus status) throws JavaModelException {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(declaration);
        Assert.isNotNull(rewrite);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(status);
        final CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(rewrites, this.getTargetType().getCompilationUnit());
        final AST ast = rewriter.getRoot().getAST();
        final AnonymousClassReferenceFinder finder = new AnonymousClassReferenceFinder(declaration);
        declaration.accept(finder);
        ArrayList<ASTNode> arguments = new ArrayList<ASTNode>(declaration.parameters().size() + 1);
        boolean result = this.createArgumentList(declaration, arguments, new VisibilityAdjustingArgumentFactory(ast, rewrites, adjustments){

            public final ASTNode getArgumentNode(IVariableBinding binding, boolean last) throws JavaModelException {
                Assert.isNotNull(binding);
                SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
                ITypeBinding type = binding.getType();
                this.adjustTypeVisibility(type);
                variable.setName(ast.newSimpleName(binding.getName()));
                variable.modifiers().addAll(ast.newModifiers(binding.getModifiers()));
                IMethodBinding method = binding.getDeclaringMethod();
                if (last && method != null && method.isVarargs()) {
                    variable.setVarargs(true);
                    String name = null;
                    if (type.isArray()) {
                        name = type.getElementType().getName();
                        if (PrimitiveType.toCode(name) != null) {
                            variable.setType(ast.newPrimitiveType(PrimitiveType.toCode(name)));
                        } else {
                            variable.setType(ast.newSimpleType(ast.newSimpleName(name)));
                        }
                    } else {
                        name = type.getName();
                        if (PrimitiveType.toCode(name) != null) {
                            variable.setType(ast.newPrimitiveType(PrimitiveType.toCode(name)));
                        } else {
                            variable.setType(ast.newSimpleType(ast.newSimpleName(name)));
                        }
                    }
                } else {
                    variable.setType(rewriter.getImportRewrite().addImport(type, ast));
                }
                return variable;
            }

            public final ASTNode getTargetNode() throws JavaModelException {
                ITypeBinding declaring;
                SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
                IMethodBinding method = declaration.resolveBinding();
                if (method != null && (declaring = method.getDeclaringClass()) != null) {
                    this.adjustTypeVisibility(declaring);
                    variable.setType(rewriter.getImportRewrite().addImport(declaring, ast));
                    variable.setName(ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName));
                    if (finder.getResult().size() > 0) {
                        variable.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                    }
                }
                return variable;
            }
        });
        ListRewrite list = rewrite.getListRewrite(declaration, MethodDeclaration.PARAMETERS_PROPERTY);
        ASTNode node2 = null;
        for (ASTNode node2 : declaration.parameters()) {
            list.remove(node2, null);
        }
        for (ASTNode node2 : arguments) {
            list.insertLast(node2, null);
        }
        return result;
    }

    protected void createMethodBody(CompilationUnitRewrite rewriter, ASTRewrite rewrite, MethodDeclaration declaration) {
        Assert.isNotNull(declaration);
        declaration.getBody().accept(new MethodBodyRewriter(rewriter, rewrite, declaration));
    }

    protected void createMethodComment(final ASTRewrite rewrite, final MethodDeclaration declaration) throws JavaModelException {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(declaration);
        Javadoc comment = declaration.getJavadoc();
        if (comment != null) {
            LinkedList tags = new LinkedList(comment.tags());
            IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
            final HashMap<String, TagElement> elements = new HashMap<String, TagElement>(bindings.length);
            String name = null;
            List fragments = null;
            TagElement element2 = null;
            TagElement reference = null;
            IVariableBinding binding = null;
            int index = 0;
            while (index < bindings.length) {
                binding = bindings[index];
                for (TagElement element2 : comment.tags()) {
                    name = element2.getTagName();
                    fragments = element2.fragments();
                    if (name == null) continue;
                    if (name.equals("@param") && !fragments.isEmpty() && fragments.get(0) instanceof SimpleName) {
                        SimpleName simple = (SimpleName)fragments.get(0);
                        if (!binding.getName().equals(simple.getIdentifier())) continue;
                        elements.put(binding.getKey(), element2);
                        tags.remove(element2);
                        continue;
                    }
                    if (reference != null) continue;
                    reference = element2;
                }
                ++index;
            }
            if (bindings.length == 0 && reference == null) {
                for (TagElement element2 : comment.tags()) {
                    name = element2.getTagName();
                    fragments = element2.fragments();
                    if (name == null || name.equals("@param")) continue;
                    reference = element2;
                }
            }
            ArrayList<ASTNode> arguments = new ArrayList<ASTNode>(bindings.length + 1);
            this.createArgumentList(declaration, arguments, new IArgumentFactory(){

                public final ASTNode getArgumentNode(IVariableBinding argument, boolean last) throws JavaModelException {
                    Assert.isNotNull(argument);
                    if (elements.containsKey(argument.getKey())) {
                        return rewrite.createCopyTarget((ASTNode)elements.get(argument.getKey()));
                    }
                    return JavadocUtil.createParamTag(argument.getName(), declaration.getAST(), MoveInstanceMethodProcessor.this.fMethod.getJavaProject());
                }

                public final ASTNode getTargetNode() throws JavaModelException {
                    return JavadocUtil.createParamTag(MoveInstanceMethodProcessor.this.fTargetName, declaration.getAST(), MoveInstanceMethodProcessor.this.fMethod.getJavaProject());
                }
            });
            ListRewrite rewriter = rewrite.getListRewrite(comment, Javadoc.TAGS_PROPERTY);
            ASTNode tag2 = null;
            for (ASTNode tag2 : comment.tags()) {
                if (tags.contains(tag2)) continue;
                rewriter.remove(tag2, null);
            }
            for (ASTNode tag2 : arguments) {
                if (reference != null) {
                    rewriter.insertBefore(tag2, reference, null);
                    continue;
                }
                rewriter.insertLast(tag2, null);
            }
        }
    }

    protected String createMethodContent(IDocument document, MethodDeclaration declaration, ASTRewrite rewrite) throws BadLocationException {
        Assert.isNotNull(document);
        Assert.isNotNull(declaration);
        Assert.isNotNull(rewrite);
        Region range = new Region(declaration.getStartPosition(), declaration.getLength());
        RangeMarker marker = new RangeMarker(range.getOffset(), range.getLength());
        IJavaProject project = this.fMethod.getJavaProject();
        TextEdit[] edits = rewrite.rewriteAST(document, project.getOptions(true)).removeChildren();
        int index = 0;
        while (index < edits.length) {
            marker.addChild(edits[index]);
            ++index;
        }
        MultiTextEdit result = new MultiTextEdit();
        result.addChild((TextEdit)marker);
        TextEditProcessor processor = new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, document.getLength()), 2);
        processor.getRoot().addChild((TextEdit)result);
        processor.performEdits();
        IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
        return Strings.changeIndent(document.get(marker.getOffset(), marker.getLength()), Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project), project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
    }

    protected boolean createMethodCopy(IDocument document, MethodDeclaration declaration, ASTRewrite rewrite, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(document);
        Assert.isNotNull(declaration);
        Assert.isNotNull(rewrite);
        Assert.isNotNull(rewrites);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        boolean target = false;
        CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(rewrites, this.getTargetType().getCompilationUnit());
        try {
            rewrite.set(declaration, MethodDeclaration.NAME_PROPERTY, rewrite.getAST().newSimpleName(this.fMethodName), null);
            boolean same = false;
            IMethodBinding binding = declaration.resolveBinding();
            if (binding != null) {
                ITypeBinding declaring = binding.getDeclaringClass();
                if (declaring != null && Bindings.equals(declaring.getPackage(), this.fTarget.getType().getPackage())) {
                    same = true;
                }
                Modifier.ModifierKeyword keyword = same ? null : Modifier.ModifierKeyword.PUBLIC_KEYWORD;
                if (MemberVisibilityAdjustor.hasLowerVisibility(binding.getModifiers(), same ? 0 : (keyword == null ? 0 : keyword.toFlagValue())) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)this.fMethod, keyword, adjustments)) {
                    MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment adjustment = new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(this.fMethod, keyword, RefactoringStatus.createStatus((int)2, (String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{MemberVisibilityAdjustor.getLabel(this.fMethod), MemberVisibilityAdjustor.getLabel(keyword)}), (RefactoringStatusContext)JavaStatusContext.create(this.fMethod), null, (int)-1, null));
                    ModifierRewrite.create(rewrite, declaration).setVisibility(keyword == null ? 0 : keyword.toFlagValue(), null);
                    adjustment.setNeedsRewriting(false);
                    adjustments.put(this.fMethod, adjustment);
                }
            }
            target = this.createMethodArguments(rewrites, rewrite, declaration, adjustments, status);
            this.createMethodTypeParameters(rewrite, declaration, status);
            this.createMethodComment(rewrite, declaration);
            this.createMethodBody(rewriter, rewrite, declaration);
        }
        finally {
            if (this.fMethod.getCompilationUnit().equals(this.getTargetType().getCompilationUnit())) {
                rewriter.clearImportRewrites();
            }
        }
        return target;
    }

    protected boolean createMethodDelegation(MethodDeclaration declaration, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(declaration);
        Assert.isNotNull(monitor);
        DelegateInstanceMethodCreator creator = new DelegateInstanceMethodCreator(adjustments, rewrites);
        creator.setSourceRewrite(this.fSourceRewrite);
        creator.setCopy(false);
        creator.setDeclareDeprecated(this.fDelegateDeprecation);
        creator.setDeclaration(declaration);
        creator.setNewElementName(this.fMethodName);
        creator.prepareDelegate();
        creator.createEdit();
        return creator.getNeededInsertion();
    }

    protected boolean createMethodDelegator(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, MethodDeclaration declaration, SearchResultGroup[] groups, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, boolean target, ReferencesInBinaryContext binaryRefs, RefactoringStatus status, IProgressMonitor monitor) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(declaration);
        Assert.isNotNull(groups);
        Assert.isNotNull(adjustments);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            try {
                boolean result = true;
                boolean found = false;
                ITypeHierarchy hierarchy = this.fMethod.getDeclaringType().newTypeHierarchy(new SubProgressMonitor(monitor, 1));
                IType type = null;
                IMethod method = null;
                IType[] types = hierarchy.getAllSubtypes(this.fMethod.getDeclaringType());
                int index = 0;
                while (index < types.length && !found) {
                    type = types[index];
                    method = JavaModelUtil.findMethod(this.fMethod.getElementName(), this.fMethod.getParameterTypes(), false, type);
                    if (method != null) {
                        found = true;
                    }
                    ++index;
                }
                types = hierarchy.getAllSupertypes(this.fMethod.getDeclaringType());
                index = 0;
                while (index < types.length && !found) {
                    type = types[index];
                    method = JavaModelUtil.findMethod(this.fMethod.getElementName(), this.fMethod.getParameterTypes(), false, type);
                    if (method != null) {
                        found = true;
                    }
                    ++index;
                }
                if (found) {
                    status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_overridden, BindingLabelProvider.getBindingLabel(declaration.resolveBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)), (RefactoringStatusContext)JavaStatusContext.create(this.fMethod)));
                    result = false;
                } else {
                    monitor.worked(1);
                    SearchMatch[] matches = null;
                    IJavaElement element = null;
                    ICompilationUnit unit = null;
                    CompilationUnitRewrite rewrite = null;
                    SearchResultGroup group = null;
                    int index2 = 0;
                    while (index2 < groups.length) {
                        group = groups[index2];
                        element = JavaCore.create(group.getResource());
                        if (element instanceof ICompilationUnit) {
                            matches = group.getSearchResults();
                            unit = (ICompilationUnit)element;
                            rewrite = this.getCompilationUnitRewrite(rewrites, unit);
                            SearchMatch match = null;
                            int offset = 0;
                            while (offset < matches.length) {
                                match = matches[offset];
                                if (match.getAccuracy() == 1) {
                                    status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_inaccurate, BasicElementLabels.getFileName(unit)), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)unit, new SourceRange(match.getOffset(), match.getLength()))));
                                    result = false;
                                } else if (!this.createInlinedMethodInvocation(rewrite, declaration, match, adjustments, target, status)) {
                                    result = false;
                                }
                                ++offset;
                            }
                        } else {
                            result = false;
                        }
                        ++index2;
                    }
                    monitor.worked(1);
                }
                boolean bl = result;
                return bl;
            }
            catch (CoreException exception) {
                status.merge(RefactoringStatus.create((IStatus)exception.getStatus()));
                monitor.done();
                return false;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void createMethodImports(CompilationUnitRewrite rewrite, MethodDeclaration declaration, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(declaration);
        Assert.isNotNull(monitor);
        Assert.isNotNull(status);
        monitor.beginTask("", 1);
        monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
        try {
            ImportRewriteUtil.addImports(rewrite, null, declaration, new HashMap<Name, String>(), new HashMap<Name, String>(), false);
        }
        finally {
            monitor.done();
        }
    }

    protected void createMethodJavadocReference(CompilationUnitRewrite rewrite, MethodDeclaration declaration, SearchMatch match, boolean targetNode, RefactoringStatus status) {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(declaration);
        Assert.isNotNull(match);
        Assert.isNotNull(status);
        ASTNode node = ASTNodeSearchUtil.findNode(match, rewrite.getRoot());
        if (node instanceof MethodRef) {
            AST ast = node.getAST();
            MethodRef successor = ast.newMethodRef();
            rewrite.getASTRewrite().replace(node, successor, null);
        }
    }

    protected void createMethodJavadocReferences(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, MethodDeclaration declaration, SearchResultGroup[] groups, boolean target, RefactoringStatus status, IProgressMonitor monitor) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            SearchMatch[] matches = null;
            IJavaElement element = null;
            ICompilationUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            SearchResultGroup group = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                element = JavaCore.create(group.getResource());
                unit = group.getCompilationUnit();
                if (element instanceof ICompilationUnit) {
                    matches = group.getSearchResults();
                    unit = (ICompilationUnit)element;
                    rewrite = this.getCompilationUnitRewrite(rewrites, unit);
                    SearchMatch match = null;
                    int offset = 0;
                    while (offset < matches.length) {
                        match = matches[offset];
                        if (match.getAccuracy() == 1) {
                            status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_inaccurate, BasicElementLabels.getFileName(unit)), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)unit, new SourceRange(match.getOffset(), match.getLength()))));
                        } else {
                            this.createMethodJavadocReference(rewrite, declaration, match, target, status);
                        }
                        ++offset;
                    }
                }
                monitor.worked(1);
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ASTNode createMethodReference(final MethodDeclaration declaration, final AST ast) throws JavaModelException {
        Assert.isNotNull(ast);
        Assert.isNotNull(declaration);
        MethodRef reference = ast.newMethodRef();
        reference.setName(ast.newSimpleName(this.fMethodName));
        reference.setQualifier(ASTNodeFactory.newName(ast, this.fTargetType.getFullyQualifiedName('.')));
        this.createArgumentList(declaration, reference.parameters(), new IArgumentFactory(){

            public final ASTNode getArgumentNode(IVariableBinding binding, boolean last) {
                Assert.isNotNull(binding);
                MethodRefParameter parameter = ast.newMethodRefParameter();
                parameter.setType(ASTNodeFactory.newType(ast, binding.getType().getName()));
                return parameter;
            }

            public final ASTNode getTargetNode() {
                ITypeBinding declaring;
                MethodRefParameter parameter = ast.newMethodRefParameter();
                IMethodBinding method = declaration.resolveBinding();
                if (method != null && (declaring = method.getDeclaringClass()) != null) {
                    parameter.setType(ASTNodeFactory.newType(ast, Bindings.getFullyQualifiedName(declaring)));
                }
                return parameter;
            }
        });
        return reference;
    }

    protected void createMethodSignature(IDocument document, MethodDeclaration declaration, ASTRewrite rewrite, Map<ICompilationUnit, CompilationUnitRewrite> rewrites) throws JavaModelException {
        Assert.isNotNull(document);
        Assert.isNotNull(declaration);
        Assert.isNotNull(rewrite);
        Assert.isNotNull(rewrites);
        try {
            CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(rewrites, this.getTargetType().getCompilationUnit());
            MethodDeclaration stub = (MethodDeclaration)rewriter.getASTRewrite().createStringPlaceholder(this.createMethodContent(document, declaration, rewrite), 31);
            AbstractTypeDeclaration type = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getTargetType(), rewriter.getRoot());
            rewriter.getASTRewrite().getListRewrite(type, type.getBodyDeclarationsProperty()).insertAt(stub, ASTNodes.getInsertionIndex(stub, type.bodyDeclarations()), rewriter.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_add_moved_method));
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
    }

    protected void createMethodTypeParameters(ASTRewrite rewrite, MethodDeclaration declaration, RefactoringStatus status) {
        ITypeBinding[] parameters;
        IMethodBinding method;
        ITypeBinding binding = this.fTarget.getType();
        if (binding != null && binding.isParameterizedType() && (method = declaration.resolveBinding()) != null && (parameters = method.getTypeParameters()).length > 0) {
            ListRewrite rewriter = rewrite.getListRewrite(declaration, MethodDeclaration.TYPE_PARAMETERS_PROPERTY);
            boolean foundStatic = false;
            while (binding != null && !foundStatic) {
                if (Flags.isStatic(binding.getModifiers())) {
                    foundStatic = true;
                }
                ITypeBinding[] bindings = binding.getTypeArguments();
                int index = 0;
                while (index < bindings.length) {
                    int offset = 0;
                    while (offset < parameters.length) {
                        if (parameters[offset].getName().equals(bindings[index].getName())) {
                            rewriter.remove((ASTNode)rewriter.getOriginalList().get(offset), null);
                            status.addWarning(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_present_type_parameter_warning, new Object[]{BasicElementLabels.getJavaElementName(parameters[offset].getName()), BindingLabelProvider.getBindingLabel(binding, JavaElementLabels.ALL_FULLY_QUALIFIED)}), JavaStatusContext.create(this.fMethod));
                        }
                        ++offset;
                    }
                    ++index;
                }
                binding = binding.getDeclaringClass();
            }
        }
    }

    protected Expression createSimpleTargetAccessExpression(MethodDeclaration declaration) {
        Assert.isNotNull(declaration);
        Expression expression = null;
        AST ast = declaration.getAST();
        ITypeBinding type = this.fTarget.getDeclaringClass();
        if (type != null) {
            boolean shadows = false;
            IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
            IVariableBinding variable = null;
            int index = 0;
            while (index < bindings.length) {
                variable = bindings[index];
                if (this.fMethod.getDeclaringType().getField(variable.getName()).exists()) {
                    shadows = true;
                    break;
                }
                ++index;
            }
            if (this.fSettings.useKeywordThis || shadows) {
                FieldAccess access = ast.newFieldAccess();
                access.setName(ast.newSimpleName(this.fTarget.getName()));
                access.setExpression(ast.newThisExpression());
                expression = access;
            } else {
                expression = ast.newSimpleName(this.fTarget.getName());
            }
        } else {
            expression = ast.newSimpleName(this.fTarget.getName());
        }
        return expression;
    }

    public final IVariableBinding[] getCandidateTargets() {
        Assert.isNotNull(this.fCandidateTargets);
        return this.fCandidateTargets;
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull(unit);
        CompilationUnitRewrite rewrite = rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    @Override
    public final boolean getDelegateUpdating() {
        return this.fDelegatingUpdating;
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_singular;
    }

    @Override
    public final boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public final Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    public final String getMethodName() {
        return this.fMethodName;
    }

    public final IVariableBinding[] getPossibleTargets() {
        Assert.isNotNull(this.fPossibleTargets);
        return this.fPossibleTargets;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.MoveInstanceMethodProcessor_name;
    }

    protected final int getTargetIndex() {
        IVariableBinding[] targets = this.getPossibleTargets();
        int result = -1;
        int index = 0;
        while (index < targets.length) {
            if (Bindings.equals(this.fTarget, targets[index])) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }

    public final String getTargetName() {
        return this.fTargetName;
    }

    protected IType getTargetType() throws JavaModelException {
        Assert.isNotNull(this.fTarget);
        if (this.fTargetType == null) {
            ITypeBinding binding = this.fTarget.getType();
            if (binding != null) {
                this.fTargetType = (IType)binding.getJavaElement();
            } else {
                throw new JavaModelException(new CoreException(new Status(4, JavaPlugin.getPluginId(), 0, RefactoringCoreMessages.MoveInstanceMethodProcessor_cannot_be_moved, null)));
            }
        }
        return this.fTargetType;
    }

    protected void initialize(IMethod method) {
        Assert.isNotNull(method);
        this.fSourceRewrite = new CompilationUnitRewrite(this.fMethod.getCompilationUnit());
        this.fMethodName = method.getElementName();
        this.fTargetName = this.suggestTargetName();
        if (this.fSettings == null) {
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fMethod.getJavaProject());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 9) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.move.method");
        }
        this.fMethod = (IMethod)element;
        this.initialize(this.fMethod);
        String name = extended.getAttribute("name");
        if (name == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        RefactoringStatus status = this.setMethodName(name);
        if (status.hasError()) {
            return status;
        }
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        if (deprecate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.valueOf(deprecate);
        String remove = extended.getAttribute(ATTRIBUTE_REMOVE);
        if (remove == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REMOVE));
        }
        this.fRemove = Boolean.valueOf(remove);
        String inline = extended.getAttribute(ATTRIBUTE_INLINE);
        if (inline == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INLINE));
        }
        this.fInline = Boolean.valueOf(inline);
        String getter = extended.getAttribute(ATTRIBUTE_USE_GETTER);
        if (getter == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_USE_GETTER));
        }
        this.fUseGetters = Boolean.valueOf(getter);
        String setter = extended.getAttribute(ATTRIBUTE_USE_SETTER);
        if (setter == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_USE_SETTER));
        }
        this.fUseSetters = Boolean.valueOf(setter);
        String target = extended.getAttribute(ATTRIBUTE_TARGET_NAME);
        if (target == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TARGET_NAME));
        RefactoringStatus status2 = this.setTargetName(target);
        if (status2.hasError()) {
            return status2;
        }
        String value = extended.getAttribute(ATTRIBUTE_TARGET_INDEX);
        if (value == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TARGET_INDEX));
        try {
            IVariableBinding[] bindings;
            MethodDeclaration declaration;
            int index = Integer.valueOf(value);
            if (index < 0 || (declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot())) == null || (bindings = this.computeTargetCategories(declaration)) == null || index >= bindings.length) return new RefactoringStatus();
            this.setTarget(bindings[index]);
            return new RefactoringStatus();
        }
        catch (NumberFormatException numberFormatException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{value, ATTRIBUTE_TARGET_INDEX}));
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{value, ATTRIBUTE_TARGET_INDEX}));
        }
    }

    public final boolean isApplicable() throws CoreException {
        return this.fMethod.exists() && !this.fMethod.isConstructor() && !this.fMethod.isBinary() && !this.fMethod.isReadOnly() && this.fMethod.getCompilationUnit() != null && !JdtFlags.isStatic(this.fMethod);
    }

    protected boolean isTargetAccess(Name name) {
        QualifiedName qualified;
        Assert.isNotNull(name);
        IBinding binding = name.resolveBinding();
        if (Bindings.equals(this.fTarget, binding)) {
            return true;
        }
        if (name.getParent() instanceof FieldAccess) {
            FieldAccess access = (FieldAccess)name.getParent();
            Expression expression = access.getExpression();
            if (expression instanceof Name) {
                return this.isTargetAccess((Name)expression);
            }
        } else if (name instanceof QualifiedName && (qualified = (QualifiedName)name).getQualifier() != null) {
            return this.isTargetAccess(qualified.getQualifier());
        }
        return false;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants participants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public final boolean needsTargetNode() {
        return this.fTargetNode;
    }

    @Override
    public final void setDelegateUpdating(boolean updating) {
        this.fDelegatingUpdating = updating;
        this.setInlineDelegator(!updating);
        this.setRemoveDelegator(!updating);
    }

    @Override
    public final void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public final void setInlineDelegator(boolean inline) {
        this.fInline = inline;
    }

    public final RefactoringStatus setMethodName(String name) {
        Assert.isNotNull(name);
        RefactoringStatus status = Checks.checkMethodName(name, this.fTargetType);
        if (status.hasFatalError()) {
            return status;
        }
        this.fMethodName = name;
        return status;
    }

    public final void setRemoveDelegator(boolean remove) {
        Assert.isTrue(!remove || this.fInline);
        this.fRemove = remove;
    }

    public final void setTarget(IVariableBinding target) {
        Assert.isNotNull(target);
        this.fTarget = target;
        this.fTargetType = null;
        try {
            MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
            if (declaration != null) {
                ThisReferenceFinder finder = new ThisReferenceFinder();
                declaration.accept(finder);
                this.fTargetNode = !finder.getResult().isEmpty();
                return;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        this.fTargetNode = true;
    }

    public final RefactoringStatus setTargetName(String name) {
        Assert.isNotNull(name);
        RefactoringStatus status = Checks.checkTempName(name, this.fMethod);
        if (status.hasFatalError()) {
            return status;
        }
        this.fTargetName = name;
        return status;
    }

    public final void setUseGetters(boolean use) {
        this.fUseGetters = use;
    }

    public final void setUseSetters(boolean use) {
        this.fUseSetters = use;
    }

    public final boolean shouldUseGetters() {
        return this.fUseGetters;
    }

    public final boolean shouldUseSetters() {
        return this.fUseSetters;
    }

    protected String suggestTargetName() {
        try {
            String[] candidates = StubUtility.getArgumentNameSuggestions(this.fMethod.getDeclaringType(), this.computeReservedIdentifiers());
            if (candidates.length > 0 && candidates[0].indexOf(36) < 0) {
                return candidates[0];
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        return "arg";
    }

    public final class AnonymousClassReferenceFinder
    extends AstNodeFinder {
        protected int fAnonymousClass = 0;
        protected final ITypeBinding fDeclaringType;

        public AnonymousClassReferenceFinder(MethodDeclaration declaration) {
            this.fDeclaringType = declaration.resolveBinding().getDeclaringClass();
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            Assert.isNotNull(node);
            if (this.fAnonymousClass > 0) {
                --this.fAnonymousClass;
            }
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            Assert.isNotNull(node);
            ++this.fAnonymousClass;
            return super.visit(node);
        }

        public final boolean visit(MethodInvocation node) {
            IMethodBinding binding;
            Assert.isNotNull(node);
            if (this.fAnonymousClass > 0 && (binding = node.resolveMethodBinding()) != null && node.getExpression() == null && !Modifier.isStatic(binding.getModifiers())) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IVariableBinding variable;
            ITypeBinding declaring;
            IBinding binding;
            Assert.isNotNull(node);
            if (this.fAnonymousClass > 0 && !(node.getParent() instanceof FieldAccess) && (binding = node.resolveBinding()) instanceof IVariableBinding && (declaring = (variable = (IVariableBinding)binding).getDeclaringClass()) != null && Bindings.equals(declaring, this.fDeclaringType)) {
                this.fResult.add(node);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AstNodeFinder
    extends ASTVisitor {
        protected final Set<Expression> fResult = new HashSet<Expression>();
        protected final RefactoringStatus fStatus = new RefactoringStatus();

        protected AstNodeFinder() {
        }

        public final Set<Expression> getResult() {
            return this.fResult;
        }

        public final RefactoringStatus getStatus() {
            return this.fStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DelegateInstanceMethodCreator
    extends DelegateMethodCreator {
        private Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> fAdjustments;
        private boolean fNeededInsertion;
        private Map<ICompilationUnit, CompilationUnitRewrite> fRewrites;

        public DelegateInstanceMethodCreator(Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, Map<ICompilationUnit, CompilationUnitRewrite> rewrites) {
            this.fAdjustments = adjustments;
            this.fRewrites = rewrites;
        }

        @Override
        protected ASTNode createBody(BodyDeclaration bd) throws JavaModelException {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bd;
            MethodInvocation invocation = this.getAst().newMethodInvocation();
            invocation.setName(this.getAst().newSimpleName(this.getNewElementName()));
            invocation.setExpression(MoveInstanceMethodProcessor.this.createSimpleTargetAccessExpression(methodDeclaration));
            this.fNeededInsertion = MoveInstanceMethodProcessor.this.createArgumentList(methodDeclaration, invocation.arguments(), new VisibilityAdjustingArgumentFactory(this.getAst(), this.fRewrites, this.fAdjustments));
            Block block = this.getAst().newBlock();
            block.statements().add(this.createMethodInvocation(methodDeclaration, invocation));
            if (!MoveInstanceMethodProcessor.this.fSourceRewrite.getCu().equals(MoveInstanceMethodProcessor.this.fTargetType.getCompilationUnit())) {
                MoveInstanceMethodProcessor.this.fSourceRewrite.getImportRemover().registerRemovedNode(methodDeclaration.getBody());
            }
            return block;
        }

        @Override
        protected ASTNode createDocReference(BodyDeclaration declaration) throws JavaModelException {
            return MoveInstanceMethodProcessor.this.createMethodReference((MethodDeclaration)declaration, this.getAst());
        }

        protected boolean getNeededInsertion() {
            return this.fNeededInsertion;
        }
    }

    public final class EnclosingInstanceReferenceFinder
    extends AstNodeFinder {
        private final List<ITypeBinding> fEnclosingTypes = new ArrayList<ITypeBinding>(3);

        public EnclosingInstanceReferenceFinder(ITypeBinding binding) {
            Assert.isNotNull(binding);
            ITypeBinding declaring = binding.getDeclaringClass();
            while (declaring != null) {
                this.fEnclosingTypes.add(declaring);
                declaring = declaring.getDeclaringClass();
            }
        }

        public final boolean visit(SimpleName node) {
            Assert.isNotNull(node);
            IBinding binding = node.resolveBinding();
            ITypeBinding declaring = null;
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                if (Flags.isStatic(variable.getModifiers())) {
                    return false;
                }
                declaring = variable.getDeclaringClass();
            } else if (binding instanceof IMethodBinding) {
                IMethodBinding method = (IMethodBinding)binding;
                if (Flags.isStatic(method.getModifiers())) {
                    return false;
                }
                declaring = method.getDeclaringClass();
            }
            if (declaring != null) {
                ITypeBinding enclosing2 = null;
                for (ITypeBinding enclosing2 : this.fEnclosingTypes) {
                    if (!Bindings.equals(enclosing2, declaring)) continue;
                    this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_refers_enclosing_instances, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
                    this.fResult.add(node);
                    break;
                }
            }
            return false;
        }

        public final boolean visit(ThisExpression node) {
            Assert.isNotNull(node);
            if (node.getQualifier() != null) {
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_refers_enclosing_instances, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
                this.fResult.add(node);
            }
            return false;
        }
    }

    public final class GenericReferenceFinder
    extends AstNodeFinder {
        protected final Set<String> fBindings = new HashSet<String>();

        public GenericReferenceFinder(MethodDeclaration declaration) {
            Assert.isNotNull(declaration);
            ITypeBinding binding = null;
            TypeParameter parameter2 = null;
            for (TypeParameter parameter2 : declaration.typeParameters()) {
                binding = parameter2.resolveBinding();
                if (binding == null) continue;
                this.fBindings.add(binding.getKey());
            }
        }

        public final boolean visit(SimpleName node) {
            ITypeBinding type;
            Assert.isNotNull(node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding && !this.fBindings.contains((type = (ITypeBinding)binding).getKey()) && type.isTypeVariable()) {
                this.fResult.add(node);
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_type_variables, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
                return false;
            }
            return true;
        }
    }

    protected static interface IArgumentFactory {
        public ASTNode getArgumentNode(IVariableBinding var1, boolean var2) throws JavaModelException;

        public ASTNode getTargetNode() throws JavaModelException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MethodBodyRewriter
    extends ASTVisitor {
        protected int fAnonymousClass = 0;
        protected final MethodDeclaration fDeclaration;
        protected final ASTRewrite fRewrite;
        protected final Set<IBinding> fStaticImports = new HashSet<IBinding>();
        protected final RefactoringStatus fStatus = new RefactoringStatus();
        protected final CompilationUnitRewrite fTargetRewrite;

        public MethodBodyRewriter(CompilationUnitRewrite targetRewrite, ASTRewrite rewrite, MethodDeclaration sourceDeclaration) {
            Assert.isNotNull(targetRewrite);
            Assert.isNotNull(rewrite);
            Assert.isNotNull(sourceDeclaration);
            this.fTargetRewrite = targetRewrite;
            this.fRewrite = rewrite;
            this.fDeclaration = sourceDeclaration;
            this.fStaticImports.clear();
            ImportRewriteUtil.collectImports(MoveInstanceMethodProcessor.this.fMethod.getJavaProject(), sourceDeclaration, new HashSet<ITypeBinding>(), this.fStaticImports, false);
        }

        private boolean isParameterName(String name) {
            List parameters = this.fDeclaration.parameters();
            for (SingleVariableDeclaration decl : parameters) {
                if (!name.equals(decl.getName().getIdentifier())) continue;
                return true;
            }
            return false;
        }

        @Override
        public final void endVisit(AnonymousClassDeclaration node) {
            Assert.isNotNull(node);
            if (this.fAnonymousClass > 0) {
                --this.fAnonymousClass;
            }
            super.endVisit(node);
        }

        @Override
        public final boolean visit(AnonymousClassDeclaration node) {
            Assert.isNotNull(node);
            ++this.fAnonymousClass;
            return super.visit(node);
        }

        @Override
        public final boolean visit(ClassInstanceCreation node) {
            Assert.isNotNull(node);
            if (node.getParent() instanceof ClassInstanceCreation) {
                AnonymousClassDeclaration declaration = node.getAnonymousClassDeclaration();
                if (declaration != null) {
                    this.visit(declaration);
                }
                return false;
            }
            return super.visit(node);
        }

        private ASTNode getFieldReference(SimpleName oldNameNode, ASTRewrite rewrite) {
            String name = oldNameNode.getIdentifier();
            AST ast = rewrite.getAST();
            if (this.isParameterName(name) || StubUtility.useThisForFieldAccess(this.fTargetRewrite.getCu().getJavaProject())) {
                FieldAccess fieldAccess = ast.newFieldAccess();
                fieldAccess.setExpression(ast.newThisExpression());
                fieldAccess.setName((SimpleName)rewrite.createMoveTarget(oldNameNode));
                return fieldAccess;
            }
            return rewrite.createMoveTarget(oldNameNode);
        }

        @Override
        public final boolean visit(FieldAccess node) {
            Assert.isNotNull(node);
            Expression expression = node.getExpression();
            IVariableBinding variable = node.resolveFieldBinding();
            AST ast = this.fRewrite.getAST();
            if (expression instanceof ThisExpression) {
                if (Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, variable)) {
                    if (this.fAnonymousClass > 0) {
                        ThisExpression target = ast.newThisExpression();
                        target.setQualifier(ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetType.getElementName()));
                        this.fRewrite.replace(node, target, null);
                    } else {
                        this.fRewrite.replace(node, ast.newThisExpression(), null);
                    }
                    return false;
                }
                expression.accept(this);
                return false;
            }
            if (expression instanceof FieldAccess) {
                FieldAccess access = (FieldAccess)expression;
                IBinding binding = access.getName().resolveBinding();
                if (access.getExpression() instanceof ThisExpression && Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, binding)) {
                    ASTNode newFieldAccess = this.getFieldReference(node.getName(), this.fRewrite);
                    this.fRewrite.replace(node, newFieldAccess, null);
                    return false;
                }
            } else if (expression != null) {
                expression.accept(this);
                return false;
            }
            return true;
        }

        public final void visit(List<ASTNode> nodes) {
            Assert.isNotNull(nodes);
            ASTNode node2 = null;
            for (ASTNode node2 : nodes) {
                node2.accept(this);
            }
        }

        @Override
        public final boolean visit(MethodInvocation node) {
            Assert.isNotNull(node);
            Expression expression = node.getExpression();
            IMethodBinding method = node.resolveMethodBinding();
            if (method != null) {
                ASTRewrite rewrite = this.fRewrite;
                if (expression == null) {
                    AST ast = node.getAST();
                    if (!JdtFlags.isStatic(method)) {
                        rewrite.set(node, MethodInvocation.EXPRESSION_PROPERTY, ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName), null);
                    } else {
                        rewrite.set(node, MethodInvocation.EXPRESSION_PROPERTY, ast.newSimpleType(ast.newSimpleName(MoveInstanceMethodProcessor.this.fMethod.getDeclaringType().getElementName())), null);
                    }
                    return true;
                }
                if (expression instanceof FieldAccess) {
                    FieldAccess access = (FieldAccess)expression;
                    if (Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, access.resolveFieldBinding())) {
                        rewrite.remove(expression, null);
                        this.visit(node.arguments());
                        return false;
                    }
                } else if (expression instanceof Name) {
                    Name name = (Name)expression;
                    if (Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, name.resolveBinding())) {
                        rewrite.remove(expression, null);
                        this.visit(node.arguments());
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public final boolean visit(QualifiedName node) {
            ITypeBinding type;
            Assert.isNotNull(node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isClass() && type.getDeclaringClass() != null) {
                Type newType = this.fTargetRewrite.getImportRewrite().addImport(type, node.getAST());
                this.fRewrite.replace(node, newType, null);
                return false;
            }
            binding = node.getQualifier().resolveBinding();
            if (Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, binding)) {
                this.fRewrite.replace(node, this.getFieldReference(node.getName(), this.fRewrite), null);
                return false;
            }
            node.getQualifier().accept(this);
            return false;
        }

        @Override
        public final boolean visit(SimpleName node) {
            String name;
            ITypeBinding type;
            Assert.isNotNull(node);
            AST ast = node.getAST();
            ASTRewrite rewrite = this.fRewrite;
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isClass() && type.getDeclaringClass() != null && (name = this.fTargetRewrite.getImportRewrite().addImport(type.getTypeDeclaration())) != null && name.length() > 0) {
                this.fRewrite.replace(node, ASTNodeFactory.newName(ast, name), null);
                return false;
            }
            if (Bindings.equals(MoveInstanceMethodProcessor.this.fTarget, binding)) {
                if (this.fAnonymousClass > 0) {
                    ThisExpression target = ast.newThisExpression();
                    target.setQualifier(ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetType.getElementName()));
                    this.fRewrite.replace(node, target, null);
                } else {
                    rewrite.replace(node, ast.newThisExpression(), null);
                }
            } else if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                IMethodBinding method = this.fDeclaration.resolveBinding();
                ITypeBinding declaring = variable.getDeclaringClass();
                if (method != null) {
                    if (Bindings.equals(method.getDeclaringClass(), declaring)) {
                        declaring = declaring.getTypeDeclaration();
                        if (JdtFlags.isStatic(variable)) {
                            rewrite.replace(node, ast.newQualifiedName(ASTNodeFactory.newName(ast, this.fTargetRewrite.getImportRewrite().addImport(declaring)), ast.newSimpleName(node.getFullyQualifiedName())), null);
                        } else {
                            FieldAccess access = ast.newFieldAccess();
                            access.setExpression(ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName));
                            access.setName(ast.newSimpleName(node.getFullyQualifiedName()));
                            rewrite.replace(node, access, null);
                        }
                    } else if (!(node.getParent() instanceof QualifiedName) && JdtFlags.isStatic(variable) && !this.fStaticImports.contains(variable)) {
                        rewrite.replace(node, ast.newQualifiedName(ASTNodeFactory.newName(ast, this.fTargetRewrite.getImportRewrite().addImport(declaring)), ast.newSimpleName(node.getFullyQualifiedName())), null);
                    }
                }
            }
            return false;
        }

        @Override
        public final boolean visit(ThisExpression node) {
            Assert.isNotNull(node);
            this.fRewrite.replace(node, node.getAST().newSimpleName(MoveInstanceMethodProcessor.this.fTargetName), null);
            return false;
        }
    }

    public static class ReadyOnlyFieldFinder
    extends ASTVisitor {
        protected final List<IVariableBinding> fBindings = new LinkedList<IVariableBinding>();
        protected final Set<String> fFound = new HashSet<String>();
        protected final Set<String> fWritten = new HashSet<String>();

        protected static IVariableBinding getFieldBinding(Expression expression) {
            IVariableBinding variable;
            IBinding binding;
            Assert.isNotNull(expression);
            if (expression instanceof FieldAccess) {
                return (IVariableBinding)((FieldAccess)expression).getName().resolveBinding();
            }
            if (expression instanceof Name && (binding = ((Name)expression).resolveBinding()) instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField()) {
                return variable;
            }
            return null;
        }

        protected static boolean isQualifiedEntity(Name name) {
            Assert.isNotNull(name);
            ASTNode parent = name.getParent();
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName().equals(name) || parent instanceof FieldAccess && ((FieldAccess)parent).getName().equals(name) || parent instanceof SuperFieldAccess) {
                return true;
            }
            if (parent instanceof MethodInvocation) {
                MethodInvocation invocation = (MethodInvocation)parent;
                return invocation.getExpression() != null && invocation.getName().equals(name);
            }
            return false;
        }

        public ReadyOnlyFieldFinder(ITypeBinding binding) {
            Assert.isNotNull(binding);
            IVariableBinding[] bindings = binding.getDeclaredFields();
            IVariableBinding variable = null;
            int index = 0;
            while (index < bindings.length) {
                variable = bindings[index];
                if (!variable.isSynthetic() && !this.fFound.contains(variable.getKey())) {
                    this.fFound.add(variable.getKey());
                    this.fBindings.add(variable);
                }
                ++index;
            }
        }

        public final IVariableBinding[] getDeclaredFields() {
            IVariableBinding[] result = new IVariableBinding[this.fBindings.size()];
            this.fBindings.toArray(result);
            return result;
        }

        public final IVariableBinding[] getReadOnlyFields() {
            IVariableBinding binding = null;
            LinkedList<IVariableBinding> list = new LinkedList<IVariableBinding>(this.fBindings);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                binding = (IVariableBinding)iterator.next();
                if (!this.fWritten.contains(binding.getKey())) continue;
                iterator.remove();
            }
            IVariableBinding[] result = new IVariableBinding[list.size()];
            list.toArray(result);
            return result;
        }

        public final boolean visit(Assignment node) {
            Assert.isNotNull(node);
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getLeftHandSide());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return true;
        }

        public final boolean visit(FieldAccess node) {
            String key;
            IVariableBinding binding;
            Assert.isNotNull(node);
            if (node.getExpression() instanceof ThisExpression && (binding = (IVariableBinding)node.getName().resolveBinding()) != null && !this.fFound.contains(key = binding.getKey())) {
                this.fFound.add(key);
                this.fBindings.add(binding);
            }
            return true;
        }

        public final boolean visit(PostfixExpression node) {
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getOperand());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return true;
        }

        public final boolean visit(PrefixExpression node) {
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getOperand());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return false;
        }

        public final boolean visit(SimpleName node) {
            IVariableBinding variable;
            String key;
            Assert.isNotNull(node);
            IBinding binding = node.resolveBinding();
            if (binding != null && MoveInstanceMethodProcessor.isFieldAccess(node) && !ReadyOnlyFieldFinder.isQualifiedEntity(node) && !this.fFound.contains(key = (variable = (IVariableBinding)binding).getKey())) {
                this.fFound.add(key);
                this.fBindings.add(variable);
            }
            return false;
        }
    }

    public final class RecursiveCallFinder
    extends AstNodeFinder {
        protected final IMethodBinding fBinding;

        public RecursiveCallFinder(MethodDeclaration declaration) {
            Assert.isNotNull(declaration);
            this.fBinding = declaration.resolveBinding();
        }

        public final boolean visit(MethodInvocation node) {
            Assert.isNotNull(node);
            Expression expression = node.getExpression();
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding == null || !Modifier.isStatic(binding.getModifiers()) && Bindings.equals(binding, this.fBinding) && (expression == null || expression instanceof ThisExpression)) {
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_potentially_recursive, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
                this.fResult.add(node);
                return false;
            }
            return true;
        }
    }

    public final class SuperReferenceFinder
    extends AstNodeFinder {
        public final boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public final boolean visit(EnumDeclaration node) {
            return false;
        }

        public final boolean visit(SuperFieldAccess node) {
            Assert.isNotNull(node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_uses_super, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
            this.fResult.add(node);
            return false;
        }

        public final boolean visit(SuperMethodInvocation node) {
            Assert.isNotNull(node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_uses_super, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
            this.fResult.add(node);
            return false;
        }

        public final boolean visit(TypeDeclaration node) {
            return false;
        }
    }

    public final class ThisReferenceFinder
    extends AstNodeFinder {
        public final boolean visit(MethodInvocation node) {
            Assert.isNotNull(node);
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding != null && !JdtFlags.isStatic(binding) && node.getExpression() == null) {
                this.fResult.add(node);
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
            }
            return true;
        }

        public final boolean visit(SimpleName node) {
            Assert.isNotNull(node);
            if (MoveInstanceMethodProcessor.isFieldAccess(node) && !MoveInstanceMethodProcessor.this.isTargetAccess(node)) {
                this.fResult.add(node);
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
            }
            return false;
        }

        public final boolean visit(ThisExpression node) {
            Assert.isNotNull(node);
            this.fResult.add(node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getCompilationUnit(), node)));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VisibilityAdjustingArgumentFactory
    implements IArgumentFactory {
        private final Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> fAdjustments;
        private final AST fAst;
        private final Map<ICompilationUnit, CompilationUnitRewrite> fRewrites;

        public VisibilityAdjustingArgumentFactory(AST ast, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments) {
            Assert.isNotNull(ast);
            Assert.isNotNull(rewrites);
            Assert.isNotNull(adjustments);
            this.fAst = ast;
            this.fRewrites = rewrites;
            this.fAdjustments = adjustments;
        }

        protected final void adjustTypeVisibility(ITypeBinding binding) throws JavaModelException {
            IType type;
            Assert.isNotNull(binding);
            IJavaElement element = binding.getJavaElement();
            if (element instanceof IType && !(type = (IType)element).isBinary() && !type.isReadOnly() && !Flags.isPublic(type.getFlags())) {
                boolean same = false;
                CompilationUnitRewrite rewrite = MoveInstanceMethodProcessor.this.getCompilationUnitRewrite(this.fRewrites, type.getCompilationUnit());
                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, rewrite.getRoot());
                if (declaration != null) {
                    ITypeBinding declaring = declaration.resolveBinding();
                    if (declaring != null && Bindings.equals(binding.getPackage(), MoveInstanceMethodProcessor.this.fTarget.getType().getPackage())) {
                        same = true;
                    }
                    Modifier.ModifierKeyword keyword = same ? null : Modifier.ModifierKeyword.PUBLIC_KEYWORD;
                    String modifier = same ? RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default : RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
                    if (MemberVisibilityAdjustor.hasLowerVisibility(binding.getModifiers(), same ? 0 : (keyword == null ? 0 : keyword.toFlagValue())) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)type, keyword, this.fAdjustments)) {
                        this.fAdjustments.put(type, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(type, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{BindingLabelProvider.getBindingLabel(declaration.resolveBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)type.getCompilationUnit(), declaration))));
                    }
                }
            }
        }

        @Override
        public ASTNode getArgumentNode(IVariableBinding binding, boolean last) throws JavaModelException {
            Assert.isNotNull(binding);
            this.adjustTypeVisibility(binding.getType());
            return this.fAst.newSimpleName(binding.getName());
        }

        @Override
        public ASTNode getTargetNode() throws JavaModelException {
            return this.fAst.newThisExpression();
        }
    }
}

