/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;

class MovedMemberAnalyzer
extends MoveStaticMemberAnalyzer {
    public MovedMemberAnalyzer(CompilationUnitRewrite cuRewrite, IBinding[] members, ITypeBinding source, ITypeBinding target) {
        super(cuRewrite, members, source, target);
    }

    public boolean targetNeedsSourceImport() {
        return this.fNeedsImport;
    }

    public boolean visit(SimpleName node) {
        if (node.isDeclaration() || this.isProcessed(node)) {
            return super.visit(node);
        }
        IBinding binding = node.resolveBinding();
        if (this.isMovedMember(binding)) {
            return super.visit(node);
        }
        if (this.isSourceAccess(binding)) {
            this.rewrite(node, this.fSource);
        }
        return super.visit(node);
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (this.isSourceAccess(binding)) {
            if (this.isMovedMember(binding)) {
                this.rewrite(node, this.fTarget);
                return false;
            }
            this.rewrite(node, this.fSource);
            return false;
        }
        if (this.isTargetAccess(binding)) {
            SimpleName replace = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget(node.getName());
            this.fCuRewrite.getASTRewrite().replace(node, replace, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode(node);
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(FieldAccess node) {
        IVariableBinding binding = node.resolveFieldBinding();
        if (this.isSourceAccess(binding)) {
            if (this.isMovedMember(binding)) {
                if (node.getExpression() != null) {
                    this.rewrite(node, this.fTarget);
                }
            } else {
                this.rewrite(node, this.fSource);
            }
        } else if (this.isTargetAccess(binding)) {
            this.fCuRewrite.getASTRewrite().remove(node.getExpression(), null);
            this.fCuRewrite.getImportRemover().registerRemovedNode(node.getExpression());
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (this.isSourceAccess(binding)) {
            if (this.isMovedMember(binding)) {
                if (node.getExpression() != null) {
                    this.rewrite(node, this.fTarget);
                }
            } else {
                this.rewrite(node, this.fSource);
            }
        } else if (this.isTargetAccess(binding) && node.getExpression() != null) {
            this.fCuRewrite.getASTRewrite().remove(node.getExpression(), null);
            this.fCuRewrite.getImportRemover().registerRemovedNode(node.getExpression());
        }
        return super.visit(node);
    }

    public boolean visit(MemberRef node) {
        IBinding binding = node.resolveBinding();
        if (this.isSourceAccess(binding)) {
            if (this.isMovedMember(binding)) {
                if (node.getQualifier() != null) {
                    this.rewrite(node, this.fTarget);
                }
            } else {
                this.rewrite(node, this.fSource);
            }
        } else if (this.isTargetAccess(binding)) {
            SimpleName replace = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget(node.getName());
            this.fCuRewrite.getASTRewrite().replace(node, replace, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode(node);
        }
        return super.visit(node);
    }

    public boolean visit(MethodRef node) {
        IBinding binding = node.resolveBinding();
        if (this.isSourceAccess(binding)) {
            if (this.isMovedMember(binding)) {
                if (node.getQualifier() != null) {
                    this.rewrite(node, this.fTarget);
                }
            } else {
                this.rewrite(node, this.fSource);
            }
        } else if (this.isTargetAccess(binding)) {
            SimpleName replace = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget(node.getName());
            this.fCuRewrite.getASTRewrite().replace(node, replace, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode(node);
        }
        return super.visit(node);
    }

    private boolean isSourceAccess(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return Modifier.isStatic(method.getModifiers()) && Bindings.equals(this.fSource, method.getDeclaringClass());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            return Modifier.isStatic(type.getModifiers()) && Bindings.equals(this.fSource, type.getDeclaringClass());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding field = (IVariableBinding)binding;
            return field.isField() && Modifier.isStatic(field.getModifiers()) && Bindings.equals(this.fSource, field.getDeclaringClass());
        }
        return false;
    }

    private boolean isTargetAccess(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return Modifier.isStatic(method.getModifiers()) && Bindings.equals(this.fTarget, method.getDeclaringClass());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            return Modifier.isStatic(type.getModifiers()) && Bindings.equals(this.fTarget, type.getDeclaringClass());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding field = (IVariableBinding)binding;
            return field.isField() && Modifier.isStatic(field.getModifiers()) && Bindings.equals(this.fTarget, field.getDeclaringClass());
        }
        return false;
    }
}

