/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.ui.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeVariableUtil {
    public static TypeVariableMaplet[] composeMappings(TypeVariableMaplet[] first, TypeVariableMaplet[] second) {
        Assert.isNotNull(first);
        Assert.isNotNull(second);
        if (first.length == 0) {
            return first;
        }
        if (second.length == 0) {
            return second;
        }
        TypeVariableMaplet source = null;
        TypeVariableMaplet target = null;
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>(first.length * second.length);
        int index = 0;
        while (index < first.length) {
            int offset = 0;
            while (offset < second.length) {
                source = first[index];
                target = second[offset];
                if (source.getTargetIndex() == target.getSourceIndex() && source.getTargetName().equals(target.getSourceName())) {
                    set.add(new TypeVariableMaplet(source.getSourceName(), index, target.getTargetName(), offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] mapping = new TypeVariableMaplet[set.size()];
        set.toArray(mapping);
        return mapping;
    }

    private static void extractTypeVariables(String signature, Set<String> variables) {
        Assert.isNotNull(signature);
        Assert.isNotNull(variables);
        String[] arguments = Signature.getTypeArguments(signature);
        if (arguments.length == 0) {
            variables.add(Signature.toString(signature));
        } else {
            int index = 0;
            while (index < arguments.length) {
                variables.add(Signature.toString(arguments[index]));
                ++index;
            }
        }
    }

    private static String[] getReferencedVariables(IType declaring, IMember member) throws JavaModelException {
        Assert.isNotNull(declaring);
        Assert.isNotNull(member);
        String[] variables = TypeVariableUtil.parametersToVariables(declaring.getTypeParameters());
        String[] result = new String[]{};
        if (member instanceof IField) {
            String signature = ((IField)member).getTypeSignature();
            String[] signatures = TypeVariableUtil.getVariableSignatures(signature);
            if (signatures.length == 0) {
                String variable = Signature.toString(signature);
                int index = 0;
                while (index < variables.length) {
                    if (variable.equals(variables[index])) {
                        result = new String[]{variable};
                        break;
                    }
                    ++index;
                }
            } else {
                result = new String[signatures.length];
                int index = 0;
                while (index < result.length) {
                    result[index] = Signature.toString(signatures[index]);
                    ++index;
                }
            }
        } else if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            HashSet<String> set = new HashSet<String>();
            String[] types = method.getParameterTypes();
            int index = 0;
            while (index < types.length) {
                TypeVariableUtil.extractTypeVariables(types[index], set);
                ++index;
            }
            TypeVariableUtil.extractTypeVariables(method.getReturnType(), set);
            String[] arguments = TypeVariableUtil.parametersToVariables(((IMethod)member).getTypeParameters());
            int index2 = 0;
            while (index2 < arguments.length) {
                set.add(arguments[index2]);
                ++index2;
            }
            result = new String[set.size()];
            set.toArray(result);
        } else if (member instanceof IType) {
            result = TypeVariableUtil.parametersToVariables(((IType)member).getTypeParameters());
        } else {
            JavaPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue(false);
        }
        ArrayList<String> list = new ArrayList<String>(variables.length);
        String variable = null;
        int index = 0;
        while (index < variables.length) {
            variable = variables[index];
            int offset = 0;
            while (offset < result.length) {
                if (variable.equals(result[offset])) {
                    list.add(result[offset]);
                }
                ++offset;
            }
            ++index;
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] getUnmappedVariables(TypeVariableMaplet[] mapping, IType declaring, IMember member) throws JavaModelException {
        Assert.isNotNull(mapping);
        Assert.isNotNull(declaring);
        Assert.isNotNull(member);
        ArrayList<String> list = null;
        String[] types = TypeVariableUtil.getReferencedVariables(declaring, member);
        if (mapping.length == 0) {
            list = new ArrayList<String>(types.length);
            list.addAll(Arrays.asList(types));
        } else {
            HashSet<String> mapped = new HashSet<String>(types.length);
            String type = null;
            int index = 0;
            while (index < types.length) {
                int offset = 0;
                while (offset < mapping.length) {
                    type = types[index];
                    if (mapping[offset].getSourceName().equals(type)) {
                        mapped.add(type);
                    }
                    ++offset;
                }
                ++index;
            }
            list = new ArrayList(types.length - mapped.size());
            index = 0;
            while (index < types.length) {
                type = types[index];
                if (!mapped.contains(type)) {
                    list.add(type);
                }
                ++index;
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private static String[] getVariableSignatures(String signature) {
        Assert.isNotNull(signature);
        String[] result = null;
        try {
            result = Signature.getTypeArguments(signature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = new String[]{};
        }
        return result;
    }

    public static TypeVariableMaplet[] inverseMapping(TypeVariableMaplet[] mapping) {
        Assert.isNotNull(mapping);
        TypeVariableMaplet[] result = new TypeVariableMaplet[mapping.length];
        TypeVariableMaplet maplet = null;
        int index = 0;
        while (index < mapping.length) {
            maplet = mapping[index];
            result[index] = new TypeVariableMaplet(maplet.getTargetName(), maplet.getTargetIndex(), maplet.getSourceName(), maplet.getSourceIndex());
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] parametersToSignatures(ITypeParameter[] domain, String[] range, boolean indexes) {
        Assert.isNotNull(domain);
        Assert.isNotNull(range);
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>();
        ITypeParameter source = null;
        String target = null;
        String element = null;
        String signature = null;
        int index = 0;
        while (index < domain.length) {
            source = domain[index];
            int offset = 0;
            while (offset < range.length) {
                target = range[offset];
                element = source.getElementName();
                signature = Signature.toString(target);
                if (indexes) {
                    if (offset == index) {
                        set.add(new TypeVariableMaplet(element, index, signature, offset));
                    }
                } else if (element.equals(signature)) {
                    set.add(new TypeVariableMaplet(element, index, signature, offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[set.size()];
        set.toArray(result);
        return result;
    }

    private static String[] parametersToVariables(ITypeParameter[] parameters) {
        Assert.isNotNull(parameters);
        String[] result = new String[parameters.length];
        int index = 0;
        while (index < parameters.length) {
            result[index] = parameters[index].getElementName();
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] signaturesToParameters(String[] domain, ITypeParameter[] range) {
        Assert.isNotNull(domain);
        Assert.isNotNull(range);
        Assert.isTrue(domain.length == 0 || domain.length == range.length);
        ArrayList<TypeVariableMaplet> list = new ArrayList<TypeVariableMaplet>();
        String source = null;
        String target = null;
        int index = 0;
        while (index < domain.length) {
            source = Signature.toString(domain[index]);
            target = range[index].getElementName();
            list.add(new TypeVariableMaplet(source, index, target, index));
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[list.size()];
        list.toArray(result);
        return result;
    }

    public static TypeVariableMaplet[] subTypeToInheritedType(IType type) throws JavaModelException {
        String[] range;
        String signature;
        Assert.isNotNull(type);
        ITypeParameter[] domain = type.getTypeParameters();
        if (domain.length > 0 && (signature = type.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, false);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] subTypeToSuperType(IType subtype, IType supertype) throws JavaModelException {
        String[] domain;
        String signature;
        ITypeParameter[] range;
        Assert.isNotNull(subtype);
        Assert.isNotNull(supertype);
        TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(subtype);
        if (mapping.length > 0 && (range = supertype.getTypeParameters()).length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (domain = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.composeMappings(mapping, TypeVariableUtil.signaturesToParameters(domain, range));
        }
        return mapping;
    }

    public static TypeVariableMaplet[] superTypeToInheritedType(IType supertype, IType subtype) throws JavaModelException {
        String[] range;
        String signature;
        Assert.isNotNull(subtype);
        Assert.isNotNull(supertype);
        ITypeParameter[] domain = supertype.getTypeParameters();
        if (domain.length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, true);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] superTypeToSubType(IType supertype, IType subtype) throws JavaModelException {
        Assert.isNotNull(supertype);
        Assert.isNotNull(subtype);
        return TypeVariableUtil.inverseMapping(TypeVariableUtil.subTypeToSuperType(subtype, supertype));
    }

    private TypeVariableUtil() {
    }
}

