/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.ConditionalTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.CovariantTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperTypeConstraintsSolver {
    public static final String DATA_TYPE_ESTIMATE = "te";
    protected final SuperTypeConstraintsModel fModel;
    protected Map<ICompilationUnit, Collection<CastVariable2>> fObsoleteCasts = null;
    protected LinkedList<ConstraintVariable2> fProcessable = null;
    protected Map<ICompilationUnit, Collection<ITypeConstraintVariable>> fTypeOccurrences = null;

    public SuperTypeConstraintsSolver(SuperTypeConstraintsModel model) {
        Assert.isNotNull(model);
        this.fModel = model;
    }

    private void computeConditionalTypeConstraints(Collection<ITypeConstraint2> constraints, int level) {
        ITypeConstraint2 constraint2 = null;
        for (ITypeConstraint2 constraint2 : constraints) {
            if (!(constraint2 instanceof ConditionalTypeConstraint)) continue;
            ConditionalTypeConstraint conditional = (ConditionalTypeConstraint)constraint2;
            this.fModel.createEqualityConstraint(constraint2.getLeft(), constraint2.getRight());
            this.fModel.createEqualityConstraint(conditional.getExpression(), constraint2.getLeft());
            this.fModel.createEqualityConstraint(conditional.getExpression(), constraint2.getRight());
        }
    }

    private void computeNonCovariantConstraints(Collection<ITypeConstraint2> constraints, int level) {
        if (level != 3) {
            ITypeConstraint2 constraint2 = null;
            for (ITypeConstraint2 constraint2 : constraints) {
                if (!(constraint2 instanceof CovariantTypeConstraint)) continue;
                this.fModel.createEqualityConstraint(constraint2.getLeft(), constraint2.getRight());
            }
        }
    }

    private void computeObsoleteCasts(Collection<CastVariable2> variables) {
        this.fObsoleteCasts = new HashMap<ICompilationUnit, Collection<CastVariable2>>();
        CastVariable2 variable2 = null;
        for (CastVariable2 variable2 : variables) {
            TType type = (TType)variable2.getExpressionVariable().getData(DATA_TYPE_ESTIMATE);
            if (type == null || !type.canAssignTo(variable2.getType())) continue;
            ICompilationUnit unit = variable2.getCompilationUnit();
            Collection<CastVariable2> casts = this.fObsoleteCasts.get(unit);
            if (casts != null) {
                casts.add(variable2);
                continue;
            }
            casts = new ArrayList<CastVariable2>(1);
            casts.add(variable2);
            this.fObsoleteCasts.put(unit, casts);
        }
    }

    protected ITypeSet computeTypeEstimate(ConstraintVariable2 variable) {
        TType type = variable.getType();
        if (variable instanceof ImmutableTypeVariable2 || !type.getErasure().equals(this.fModel.getSubType().getErasure())) {
            return SuperTypeSet.createTypeSet(type);
        }
        return SuperTypeSet.createTypeSet(type, this.fModel.getSuperType());
    }

    private void computeTypeEstimates(Collection<ConstraintVariable2> variables) {
        ConstraintVariable2 variable2 = null;
        for (ConstraintVariable2 variable2 : variables) {
            TypeEquivalenceSet set = variable2.getTypeEquivalenceSet();
            if (set == null) {
                set = new TypeEquivalenceSet(variable2);
                set.setTypeEstimate(this.computeTypeEstimate(variable2));
                variable2.setTypeEquivalenceSet(set);
                continue;
            }
            ITypeSet estimate = variable2.getTypeEstimate();
            if (estimate != null) continue;
            ConstraintVariable2[] contributing = set.getContributingVariables();
            estimate = SuperTypeSet.getUniverse();
            int index = 0;
            while (index < contributing.length) {
                estimate = estimate.restrictedTo(this.computeTypeEstimate(contributing[index]));
                ++index;
            }
            set.setTypeEstimate(estimate);
        }
    }

    private void computeTypeOccurrences(Collection<ConstraintVariable2> variables) {
        this.fTypeOccurrences = new HashMap<ICompilationUnit, Collection<ITypeConstraintVariable>>();
        TType superErasure = this.fModel.getSuperType().getErasure();
        TType estimatedType = null;
        ITypeSet set = null;
        ICompilationUnit unit = null;
        ConstraintVariable2 variable2 = null;
        ITypeConstraintVariable declaration = null;
        TType variableType = null;
        for (ConstraintVariable2 variable2 : variables) {
            TType typeErasure;
            if (!(variable2 instanceof ITypeConstraintVariable)) continue;
            declaration = (ITypeConstraintVariable)((Object)variable2);
            variableType = variable2.getType();
            set = declaration.getTypeEstimate();
            if (set == null || (estimatedType = set.chooseSingleType()) == null || (typeErasure = estimatedType.getErasure()).equals(variableType.getErasure()) || !typeErasure.equals(superErasure)) continue;
            declaration.setData(DATA_TYPE_ESTIMATE, estimatedType);
            unit = declaration.getCompilationUnit();
            if (unit == null) continue;
            Collection<ITypeConstraintVariable> matches = this.fTypeOccurrences.get(unit);
            if (matches != null) {
                matches.add(declaration);
                continue;
            }
            matches = new ArrayList<ITypeConstraintVariable>(1);
            matches.add(declaration);
            this.fTypeOccurrences.put(unit, matches);
        }
    }

    public final Map<ICompilationUnit, Collection<CastVariable2>> getObsoleteCasts() {
        return this.fObsoleteCasts;
    }

    public final Map<ICompilationUnit, Collection<ITypeConstraintVariable>> getTypeOccurrences() {
        return this.fTypeOccurrences;
    }

    private void processConstraints(Collection<ITypeConstraint2> constraints) {
        int level = this.fModel.getCompliance();
        ITypeConstraint2 constraint2 = null;
        for (ITypeConstraint2 constraint2 : constraints) {
            if (level != 3 && constraint2 instanceof CovariantTypeConstraint || constraint2 instanceof ConditionalTypeConstraint) continue;
            ConstraintVariable2 leftVariable = constraint2.getLeft();
            ITypeSet leftEstimate = leftVariable.getTypeEstimate();
            TypeEquivalenceSet set = leftVariable.getTypeEquivalenceSet();
            ITypeSet newEstimate = leftEstimate.restrictedTo(constraint2.getRight().getTypeEstimate());
            if (leftEstimate == newEstimate) continue;
            set.setTypeEstimate(newEstimate);
            this.fProcessable.addAll(Arrays.asList(set.getContributingVariables()));
        }
    }

    public final void solveConstraints() {
        this.fProcessable = new LinkedList();
        Collection<ConstraintVariable2> variables = this.fModel.getConstraintVariables();
        Collection<ITypeConstraint2> constraints = this.fModel.getTypeConstraints();
        int level = this.fModel.getCompliance();
        this.computeNonCovariantConstraints(constraints, level);
        this.computeConditionalTypeConstraints(constraints, level);
        this.computeTypeEstimates(variables);
        this.fProcessable.addAll(variables);
        Collection<ITypeConstraint2> usage = null;
        ConstraintVariable2 variable = null;
        while (!this.fProcessable.isEmpty()) {
            variable = this.fProcessable.removeFirst();
            usage = SuperTypeConstraintsModel.getVariableUsage(variable);
            if (!usage.isEmpty()) {
                this.processConstraints(usage);
                continue;
            }
            variable.setData(DATA_TYPE_ESTIMATE, variable.getTypeEstimate().chooseSingleType());
        }
        this.computeTypeOccurrences(variables);
        this.computeObsoleteCasts(this.fModel.getCastVariables());
    }
}

