/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;

public final class CompilationUnitRange {
    private final ICompilationUnit fCompilationUnit;
    private final ISourceRange fSourceRange;

    public CompilationUnitRange(ICompilationUnit unit, ISourceRange range) {
        Assert.isNotNull(unit);
        Assert.isNotNull(range);
        this.fCompilationUnit = unit;
        this.fSourceRange = range;
    }

    public CompilationUnitRange(ICompilationUnit unit, ASTNode node) {
        this(unit, SourceRangeFactory.create(node));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ISourceRange getSourceRange() {
        return this.fSourceRange;
    }

    public ASTNode getNode(CompilationUnit rootNode) {
        NodeFinder finder = new NodeFinder(rootNode, this.fSourceRange.getOffset(), this.fSourceRange.getLength());
        ASTNode result = finder.getCoveringNode();
        if (result != null) {
            return result;
        }
        return finder.getCoveredNode();
    }

    public String toString() {
        return "(" + this.fSourceRange.toString() + " in " + this.fCompilationUnit.getElementName() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompilationUnitRange)) {
            return false;
        }
        CompilationUnitRange other = (CompilationUnitRange)obj;
        return this.fCompilationUnit.equals(other.fCompilationUnit) && this.fSourceRange.equals(other.fSourceRange);
    }

    public int hashCode() {
        return 37 * this.fCompilationUnit.hashCode() ^ this.fSourceRange.hashCode();
    }
}

