/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.TypeRules;

public abstract class ConstraintVariable {
    private final ITypeBinding fTypeBinding;
    private Object fData;

    protected ConstraintVariable(ITypeBinding binding) {
        this.fTypeBinding = binding;
    }

    public boolean canBeAssignedTo(ConstraintVariable targetVariable) {
        if (this.fTypeBinding == null || targetVariable.fTypeBinding == null) {
            return false;
        }
        return TypeRules.canAssign(this.fTypeBinding, targetVariable.fTypeBinding);
    }

    public String toResolvedString() {
        if (this.fTypeBinding == null) {
            return "<NULL BINDING>";
        }
        return Bindings.asString(this.fTypeBinding);
    }

    public String toString() {
        return this.toResolvedString();
    }

    public ITypeBinding getBinding() {
        return this.fTypeBinding;
    }

    public Object getData() {
        return this.fData;
    }

    public void setData(Object data) {
        this.fData = data;
    }
}

