/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;

public final class GenericType
extends HierarchyType {
    private TypeVariable[] fTypeParameters;

    protected GenericType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        Assert.isTrue(binding.isGenericType());
        super.initialize(binding, javaElementType);
        TypeEnvironment environment = this.getEnvironment();
        ITypeBinding[] typeParameters = binding.getTypeParameters();
        this.fTypeParameters = new TypeVariable[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            this.fTypeParameters[i] = (TypeVariable)environment.create(typeParameters[i]);
            ++i;
        }
    }

    public int getKind() {
        return 6;
    }

    public TypeVariable[] getTypeParameters() {
        return (TypeVariable[])this.fTypeParameters.clone();
    }

    public boolean doEquals(TType type) {
        return this.getJavaElementType().equals(((GenericType)type).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    protected boolean doCanAssignTo(TType type) {
        return false;
    }

    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 8 || otherElementType == 7) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        StringBuffer result = new StringBuffer(this.getJavaElementType().getFullyQualifiedName('.'));
        result.append("<");
        result.append(this.fTypeParameters[0].getPrettySignature());
        int i = 1;
        while (i < this.fTypeParameters.length) {
            result.append(", ");
            result.append(this.fTypeParameters[i].getPrettySignature());
            ++i;
        }
        result.append(">");
        return result.toString();
    }
}

