/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints2;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public abstract class ConstraintVariable2 {
    public static final String TO_STRING = "toString";
    private Object[] fDatas;
    private TypeEquivalenceSet fTypeEquivalenceSet;
    protected final TType fType;

    protected ConstraintVariable2(TType type) {
        this.fType = type;
    }

    public Object getData(String name) {
        if (this.fDatas == null) {
            return null;
        }
        int i = 0;
        while (i < this.fDatas.length) {
            String key = (String)this.fDatas[i];
            if (key.equals(name)) {
                return this.fDatas[i + 1];
            }
            i += 2;
        }
        return null;
    }

    public TypeEquivalenceSet getTypeEquivalenceSet() {
        return this.fTypeEquivalenceSet;
    }

    public TType getType() {
        return this.fType;
    }

    public ITypeSet getTypeEstimate() {
        Assert.isNotNull(this.fTypeEquivalenceSet);
        return this.fTypeEquivalenceSet.getTypeEstimate();
    }

    public void setData(String name, Object data) {
        int index = 0;
        if (this.fDatas != null) {
            while (index < this.fDatas.length) {
                if (name.equals(this.fDatas[index])) break;
                index += 2;
            }
        }
        if (data != null) {
            if (this.fDatas != null) {
                if (index == this.fDatas.length) {
                    Object[] newTable = new Object[this.fDatas.length + 2];
                    System.arraycopy(this.fDatas, 0, newTable, 0, this.fDatas.length);
                    this.fDatas = newTable;
                }
            } else {
                this.fDatas = new Object[2];
            }
            this.fDatas[index] = name;
            this.fDatas[index + 1] = data;
        } else if (this.fDatas != null && index != this.fDatas.length) {
            int length = this.fDatas.length - 2;
            if (length == 0) {
                this.fDatas = null;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(this.fDatas, 0, newTable, 0, index);
                System.arraycopy(this.fDatas, index + 2, newTable, index, length - index);
                this.fDatas = newTable;
            }
        }
    }

    public void setTypeEquivalenceSet(TypeEquivalenceSet set) {
        this.fTypeEquivalenceSet = set;
    }

    public String toString() {
        int dot;
        String toString = (String)this.getData(TO_STRING);
        if (toString != null) {
            return toString;
        }
        String name = this.getClass().getName();
        return String.valueOf(name.substring((dot = name.lastIndexOf(46)) + 1)) + ": " + this.fType != null ? this.fType.getPrettySignature() : "<NONE>";
    }
}

