/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.internal.corext.dom.Bindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExceptionAnalyzer
extends ASTVisitor {
    private List<ITypeBinding> fCurrentExceptions;
    private Stack<List<ITypeBinding>> fTryStack = new Stack();

    protected AbstractExceptionAnalyzer() {
        this.fCurrentExceptions = new ArrayList<ITypeBinding>(1);
        this.fTryStack.push(this.fCurrentExceptions);
    }

    @Override
    public abstract boolean visit(ThrowStatement var1);

    @Override
    public abstract boolean visit(MethodInvocation var1);

    @Override
    public abstract boolean visit(ClassInstanceCreation var1);

    @Override
    public boolean visit(TypeDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        return !node.isLocalTypeDeclaration();
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        List catchClauses;
        this.fCurrentExceptions = new ArrayList<ITypeBinding>(1);
        this.fTryStack.push(this.fCurrentExceptions);
        node.getBody().accept(this);
        if (node.getAST().apiLevel() >= 4) {
            List resources = node.resources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                ((VariableDeclarationExpression)iterator.next()).accept(this);
            }
        }
        if (!(catchClauses = node.catchClauses()).isEmpty()) {
            this.handleCatchArguments(catchClauses);
        }
        List<ITypeBinding> current = this.fTryStack.pop();
        this.fCurrentExceptions = this.fTryStack.peek();
        Iterator<ITypeBinding> iter = current.iterator();
        while (iter.hasNext()) {
            this.addException(iter.next());
        }
        iter = catchClauses.iterator();
        while (iter.hasNext()) {
            ((CatchClause)((Object)iter.next())).accept(this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        IMethodBinding methodBinding;
        Type type;
        ITypeBinding resourceTypeBinding;
        if (node.getAST().apiLevel() >= 4 && node.getLocationInParent() == TryStatement.RESOURCES_PROPERTY && (resourceTypeBinding = (type = node.getType()).resolveBinding()) != null && (methodBinding = Bindings.findMethodInHierarchy(resourceTypeBinding, "close", new ITypeBinding[0])) != null) {
            this.addExceptions(methodBinding.getExceptionTypes());
        }
        return super.visit(node);
    }

    protected void addExceptions(ITypeBinding[] exceptions) {
        if (exceptions == null) {
            return;
        }
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i]);
            ++i;
        }
    }

    protected void addException(ITypeBinding exception) {
        if (!this.fCurrentExceptions.contains(exception)) {
            this.fCurrentExceptions.add(exception);
        }
    }

    protected List<ITypeBinding> getCurrentExceptions() {
        return this.fCurrentExceptions;
    }

    private void handleCatchArguments(List<CatchClause> catchClauses) {
        Iterator<CatchClause> iter = catchClauses.iterator();
        while (iter.hasNext()) {
            Type type = iter.next().getException().getType();
            if (type instanceof UnionType) {
                List types = ((UnionType)type).types();
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    this.removeCaughtExceptions(((Type)iterator.next()).resolveBinding());
                }
                continue;
            }
            this.removeCaughtExceptions(type.resolveBinding());
        }
    }

    private void removeCaughtExceptions(ITypeBinding catchTypeBinding) {
        if (catchTypeBinding == null) {
            return;
        }
        for (ITypeBinding throwTypeBinding : new ArrayList<ITypeBinding>(this.fCurrentExceptions)) {
            if (!this.catches(catchTypeBinding, throwTypeBinding)) continue;
            this.fCurrentExceptions.remove(throwTypeBinding);
        }
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }
}

