/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;

public class SelectionAwareSourceRangeComputer
extends TargetSourceRangeComputer {
    private ASTNode[] fSelectedNodes;
    private int fSelectionStart;
    private int fSelectionLength;
    private Map<ASTNode, TargetSourceRangeComputer.SourceRange> fRanges;
    private String fDocumentPortionToScan;

    public SelectionAwareSourceRangeComputer(ASTNode[] selectedNodes, IBuffer buffer, int selectionStart, int selectionLength) {
        this.fSelectedNodes = selectedNodes;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fDocumentPortionToScan = buffer.getText(this.fSelectionStart, this.fSelectionLength);
    }

    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
        try {
            TargetSourceRangeComputer.SourceRange result;
            if (this.fRanges == null) {
                this.initializeRanges();
            }
            if ((result = this.fRanges.get(node)) != null) {
                return result;
            }
            return super.computeSourceRange(node);
        }
        catch (CoreException coreException) {
            this.fRanges = new HashMap<ASTNode, TargetSourceRangeComputer.SourceRange>();
            return super.computeSourceRange(node);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeRanges() throws CoreException {
        block5: {
            this.fRanges = new HashMap<ASTNode, TargetSourceRangeComputer.SourceRange>();
            if (this.fSelectedNodes.length == 0) {
                return;
            }
            this.fRanges.put(this.fSelectedNodes[0], super.computeSourceRange(this.fSelectedNodes[0]));
            last = this.fSelectedNodes.length - 1;
            this.fRanges.put(this.fSelectedNodes[last], super.computeSourceRange(this.fSelectedNodes[last]));
            scanner = ToolFactory.createScanner(true, false, false, false);
            source = this.fDocumentPortionToScan.toCharArray();
            scanner.setSource(source);
            this.fDocumentPortionToScan = null;
            tokenizer = new TokenScanner(scanner);
            pos = tokenizer.getNextStartOffset(0, false);
            currentNode = this.fSelectedNodes[0];
            newStart = Math.min(this.fSelectionStart + pos, currentNode.getStartPosition());
            range = this.fRanges.get(currentNode);
            this.fRanges.put(currentNode, new TargetSourceRangeComputer.SourceRange(newStart, range.getLength() + range.getStartPosition() - newStart));
            currentNode = this.fSelectedNodes[last];
            scannerStart = currentNode.getStartPosition() + currentNode.getLength() - this.fSelectionStart;
            tokenizer.setOffset(scannerStart);
            pos = scannerStart;
            token = -1;
            try {
                while (true) {
                    token = tokenizer.readNext(false);
                    pos = tokenizer.getCurrentEndOffset();
                }
            }
            catch (CoreException v0) {
                if (token != 1001) break block5;
                index = pos - 1;
                ** while (index >= 0 && IndentManipulation.isLineDelimiterChar((char)source[index]))
            }
lbl-1000:
            // 1 sources

            {
                --pos;
                --index;
                continue;
            }
        }
        newEnd = Math.max(this.fSelectionStart + pos, currentNode.getStartPosition() + currentNode.getLength());
        range = this.fRanges.get(currentNode);
        this.fRanges.put(currentNode, new TargetSourceRangeComputer.SourceRange(range.getStartPosition(), newEnd - range.getStartPosition()));
    }
}

