/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.CommentAnalyzer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementAnalyzer
extends SelectionAnalyzer {
    protected ICompilationUnit fCUnit;
    private TokenScanner fScanner;
    private RefactoringStatus fStatus;

    public StatementAnalyzer(ICompilationUnit cunit, Selection selection, boolean traverseSelectedNode) throws CoreException {
        super(selection, traverseSelectedNode);
        Assert.isNotNull(cunit);
        this.fCUnit = cunit;
        this.fStatus = new RefactoringStatus();
        this.fScanner = new TokenScanner(this.fCUnit);
    }

    protected void checkSelectedNodes() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            return;
        }
        ASTNode node = nodes[0];
        int selectionOffset = this.getSelection().getOffset();
        try {
            int start = this.fScanner.getNextStartOffset(selectionOffset, true);
            if (start == node.getStartPosition()) {
                int selectionEnd;
                int lastNodeEnd = ASTNodes.getExclusiveEnd(nodes[nodes.length - 1]);
                int pos = this.fScanner.getNextStartOffset(lastNodeEnd, true);
                if (pos <= (selectionEnd = this.getSelection().getInclusiveEnd())) {
                    IScanner scanner = this.fScanner.getScanner();
                    char[] token = scanner.getCurrentTokenSource();
                    if (start < lastNodeEnd && token.length == 1 && (token[0] == ';' || token[0] == ',')) {
                        this.setSelection(Selection.createFromStartEnd(start, lastNodeEnd - 1));
                    } else {
                        SourceRange range = new SourceRange(lastNodeEnd, pos - lastNodeEnd);
                        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_end_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, range));
                    }
                }
                return;
            }
        }
        catch (CoreException coreException) {}
        SourceRange range = new SourceRange(selectionOffset, node.getStartPosition() - selectionOffset + 1);
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_beginning_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, range));
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected TokenScanner getTokenScanner() {
        return this.fScanner;
    }

    @Override
    public void endVisit(CompilationUnit node) {
        if (!this.hasSelectedNodes()) {
            super.endVisit(node);
            return;
        }
        ASTNode selectedNode = this.getFirstSelectedNode();
        Selection selection = this.getSelection();
        if (node != selectedNode) {
            ASTNode parent = selectedNode.getParent();
            this.fStatus.merge(CommentAnalyzer.perform(selection, this.fScanner.getScanner(), parent.getStartPosition(), parent.getLength()));
        }
        if (!this.fStatus.hasFatalError()) {
            this.checkSelectedNodes();
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(DoStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation(node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, node.getBody()) && StatementAnalyzer.contains(selectedNodes, node.getExpression())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_do_body_expression);
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(ForStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation(node, selectedNodes)) {
            boolean containsExpression = StatementAnalyzer.contains(selectedNodes, node.getExpression());
            boolean containsUpdaters = StatementAnalyzer.contains(selectedNodes, node.updaters());
            if (StatementAnalyzer.contains(selectedNodes, node.initializers()) && containsExpression) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_initializer_expression);
            } else if (containsExpression && containsUpdaters) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_expression_updater);
            } else if (containsUpdaters && StatementAnalyzer.contains(selectedNodes, node.getBody())) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_updater_body);
            }
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(SwitchStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation(node, selectedNodes)) {
            List<SwitchCase> cases = StatementAnalyzer.getSwitchCases(node);
            int i = 0;
            while (i < selectedNodes.length) {
                ASTNode topNode = selectedNodes[i];
                if (cases.contains(topNode)) {
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_switch_statement);
                    break;
                }
                ++i;
            }
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(SynchronizedStatement node) {
        ASTNode firstSelectedNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode(node) == 2 && firstSelectedNode == node.getBody()) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_synchronized_statement);
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(TryStatement node) {
        ASTNode firstSelectedNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode(node) == 3) {
            if (firstSelectedNode == node.getBody() || firstSelectedNode == node.getFinally()) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
            } else {
                List catchClauses = node.catchClauses();
                for (CatchClause element : catchClauses) {
                    if (element == firstSelectedNode || element.getBody() == firstSelectedNode) {
                        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
                        continue;
                    }
                    if (element.getException() != firstSelectedNode) continue;
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_catch_argument);
                }
            }
        }
        super.endVisit(node);
    }

    @Override
    public void endVisit(WhileStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation(node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, node.getExpression()) && StatementAnalyzer.contains(selectedNodes, node.getBody())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_while_expression_body);
        }
        super.endVisit(node);
    }

    private boolean doAfterValidation(ASTNode node, ASTNode[] selectedNodes) {
        return selectedNodes.length > 0 && node == selectedNodes[0].getParent() && this.getSelection().getEndVisitSelectionMode(node) == 3;
    }

    protected void invalidSelection(String message) {
        this.fStatus.addFatalError(message);
        this.reset();
    }

    protected void invalidSelection(String message, RefactoringStatusContext context) {
        this.fStatus.addFatalError(message, context);
        this.reset();
    }

    private static List<SwitchCase> getSwitchCases(SwitchStatement node) {
        ArrayList<SwitchCase> result = new ArrayList<SwitchCase>();
        for (Object element : node.statements()) {
            if (!(element instanceof SwitchCase)) continue;
            result.add((SwitchCase)element);
        }
        return result;
    }

    protected static boolean contains(ASTNode[] nodes, ASTNode node) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == node) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean contains(ASTNode[] nodes, List<Expression> list) {
        int i = 0;
        while (i < nodes.length) {
            if (list.contains(nodes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

