/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationMethod(member)) {
            return true;
        }
        return Flags.isAbstract(member.getFlags());
    }

    public static boolean isAbstract(IMethodBinding member) {
        if (JdtFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isDeprecated(IMember member) throws JavaModelException {
        return Flags.isDeprecated(member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationField(member)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(member)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isFinal(member.getFlags());
    }

    public static boolean isNative(IMember member) throws JavaModelException {
        return Flags.isNative(member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws JavaModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isProtected(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    public static boolean isPackageVisible(IBinding binding) {
        return !JdtFlags.isPrivate(binding) && !JdtFlags.isProtected(binding) && !JdtFlags.isPublic(binding);
    }

    public static boolean isPrivate(IMember member) throws JavaModelException {
        return Flags.isPrivate(member.getFlags());
    }

    public static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate(bodyDeclaration.getModifiers());
    }

    public static boolean isPrivate(IBinding binding) {
        return Modifier.isPrivate(binding.getModifiers());
    }

    public static boolean isProtected(IMember member) throws JavaModelException {
        return Flags.isProtected(member.getFlags());
    }

    public static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected(bodyDeclaration.getModifiers());
    }

    public static boolean isProtected(IBinding binding) {
        return Modifier.isProtected(binding.getModifiers());
    }

    public static boolean isPublic(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isPublic(member.getFlags());
    }

    public static boolean isPublic(IBinding binding) {
        if (JdtFlags.isInterfaceOrAnnotationMember(binding)) {
            return true;
        }
        return Modifier.isPublic(binding.getModifiers());
    }

    public static boolean isPublic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        return Modifier.isPublic(bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IMember member) throws JavaModelException {
        if (JdtFlags.isNestedInterfaceOrAnnotation(member)) {
            return true;
        }
        if (member.getElementType() != 9 && JdtFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isStatic(member.getFlags());
    }

    public static boolean isStatic(IMethodBinding methodBinding) {
        return Modifier.isStatic(methodBinding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding variableBinding) {
        if (JdtFlags.isInterfaceOrAnnotationMember(variableBinding)) {
            return true;
        }
        return Modifier.isStatic(variableBinding.getModifiers());
    }

    public static boolean isStrictfp(IMember member) throws JavaModelException {
        return Flags.isStrictfp(member.getFlags());
    }

    public static boolean isSynchronized(IMember member) throws JavaModelException {
        return Flags.isSynchronized(member.getFlags());
    }

    public static boolean isSynthetic(IMember member) throws JavaModelException {
        return Flags.isSynthetic(member.getFlags());
    }

    public static boolean isAnnotation(IMember member) throws JavaModelException {
        return Flags.isAnnotation(member.getFlags());
    }

    public static boolean isEnum(IMember member) throws JavaModelException {
        return Flags.isEnum(member.getFlags());
    }

    public static boolean isVarargs(IMethod method) throws JavaModelException {
        return Flags.isVarargs(method.getFlags());
    }

    public static boolean isTransient(IMember member) throws JavaModelException {
        return Flags.isTransient(member.getFlags());
    }

    public static boolean isVolatile(IMember member) throws JavaModelException {
        return Flags.isVolatile(member.getFlags());
    }

    private static boolean isInterfaceOrAnnotationMethod(IMember member) throws JavaModelException {
        return member.getElementType() == 9 && JdtFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationField(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationMember(IMember member) throws JavaModelException {
        return member.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation(member.getDeclaringType());
    }

    private static boolean isInterfaceOrAnnotationMember(IBinding binding) {
        ITypeBinding declaringType = null;
        if (binding instanceof IVariableBinding) {
            declaringType = ((IVariableBinding)binding).getDeclaringClass();
        } else if (binding instanceof IMethodBinding) {
            declaringType = ((IMethodBinding)binding).getDeclaringClass();
        } else if (binding instanceof ITypeBinding) {
            declaringType = ((ITypeBinding)binding).getDeclaringClass();
        }
        return declaringType != null && (declaringType.isInterface() || declaringType.isAnnotation());
    }

    private static boolean isInterfaceOrAnnotationMember(BodyDeclaration bodyDeclaration) {
        boolean isInterface = bodyDeclaration.getParent() instanceof TypeDeclaration && ((TypeDeclaration)bodyDeclaration.getParent()).isInterface();
        boolean isAnnotation = bodyDeclaration.getParent() instanceof AnnotationTypeDeclaration;
        return isInterface || isAnnotation;
    }

    private static boolean isNestedInterfaceOrAnnotation(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation((IType)member);
    }

    private static boolean isEnumConstant(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isEnum(member);
    }

    private static boolean isAnonymousType(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static int getVisibilityCode(IBinding binding) {
        if (JdtFlags.isPublic(binding)) {
            return 1;
        }
        if (JdtFlags.isProtected(binding)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(binding)) {
            return 0;
        }
        if (JdtFlags.isPrivate(binding)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic(visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected(visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate(visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static int getVisibilityCode(String visibilityString) {
        Assert.isNotNull(visibilityString);
        if (VISIBILITY_STRING_PACKAGE.equals(visibilityString)) {
            return 0;
        }
        if (VISIBILITY_STRING_PRIVATE.equals(visibilityString)) {
            return 2;
        }
        if (VISIBILITY_STRING_PROTECTED.equals(visibilityString)) {
            return 4;
        }
        if (VISIBILITY_STRING_PUBLIC.equals(visibilityString)) {
            return 1;
        }
        return -1;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue(false);
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int clearAccessModifiers(int flags) {
        return JdtFlags.clearFlag(7, flags);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

