/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.LRUMap;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;
    private Map<IMethod, Substitutions> fMethodSubstitutions;
    private Map<IType, Substitutions> fTypeVariableSubstitutions;

    public MethodOverrideTester(IType focusType, ITypeHierarchy hierarchy) {
        if (focusType == null || hierarchy == null) {
            throw new IllegalArgumentException();
        }
        this.fFocusType = focusType;
        this.fHierarchy = hierarchy;
        this.fTypeVariableSubstitutions = null;
        this.fMethodSubstitutions = null;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IMethod findDeclaringMethod(IMethod overriding, boolean testVisibility) throws JavaModelException {
        IMethod result = null;
        IMethod overridden = this.findOverriddenMethod(overriding, testVisibility);
        while (overridden != null) {
            result = overridden;
            overridden = this.findOverriddenMethod(result, testVisibility);
        }
        return result;
    }

    public IMethod findOverriddenMethod(IMethod overriding, boolean testVisibility) throws JavaModelException {
        IMethod res;
        int flags = overriding.getFlags();
        if (Flags.isPrivate(flags) || Flags.isStatic(flags) || overriding.isConstructor()) {
            return null;
        }
        IType type = overriding.getDeclaringType();
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null && (!testVisibility || JavaModelUtil.isVisibleInHierarchy(res, type.getPackageFragment()))) {
            return res;
        }
        IType[] interfaces = this.fHierarchy.getSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            IMethod res2 = this.findOverriddenMethodInHierarchy(interfaces[i], overriding);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return null;
    }

    public IMethod findOverriddenMethodInHierarchy(IType type, IMethod overriding) throws JavaModelException {
        IMethod res;
        IMethod method = this.findOverriddenMethodInType(type, overriding);
        if (method != null) {
            return method;
        }
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null) {
            return res;
        }
        IType[] superInterfaces = this.fHierarchy.getSuperInterfaces(type);
        int i = 0;
        while (i < superInterfaces.length) {
            IMethod res2 = this.findOverriddenMethodInHierarchy(superInterfaces[i], overriding);
            if (res2 != null) {
                return res2;
            }
            ++i;
        }
        return method;
    }

    public IMethod findOverriddenMethodInType(IType overriddenType, IMethod overriding) throws JavaModelException {
        int flags = overriding.getFlags();
        if (Flags.isPrivate(flags) || Flags.isStatic(flags) || overriding.isConstructor()) {
            return null;
        }
        IMethod[] overriddenMethods = overriddenType.getMethods();
        int i = 0;
        while (i < overriddenMethods.length) {
            IMethod overridden = overriddenMethods[i];
            flags = overridden.getFlags();
            if (!Flags.isPrivate(flags) && !Flags.isStatic(flags) && !overridden.isConstructor() && this.isSubsignature(overriding, overridden)) {
                return overridden;
            }
            ++i;
        }
        return null;
    }

    public IMethod findOverridingMethodInType(IType overridingType, IMethod overridden) throws JavaModelException {
        int flags = overridden.getFlags();
        if (Flags.isPrivate(flags) || Flags.isStatic(flags) || overridden.isConstructor()) {
            return null;
        }
        IMethod[] overridingMethods = overridingType.getMethods();
        int i = 0;
        while (i < overridingMethods.length) {
            IMethod overriding = overridingMethods[i];
            flags = overriding.getFlags();
            if (!Flags.isPrivate(flags) && !Flags.isStatic(flags) && !overriding.isConstructor() && this.isSubsignature(overriding, overridden)) {
                return overriding;
            }
            ++i;
        }
        return null;
    }

    public boolean isSubsignature(IMethod overriding, IMethod overridden) throws JavaModelException {
        if (!overridden.getElementName().equals(overriding.getElementName())) {
            return false;
        }
        int nParameters = overridden.getNumberOfParameters();
        if (nParameters != overriding.getNumberOfParameters()) {
            return false;
        }
        if (!this.hasCompatibleTypeParameters(overriding, overridden)) {
            return false;
        }
        return nParameters == 0 || this.hasCompatibleParameterTypes(overriding, overridden);
    }

    private boolean hasCompatibleTypeParameters(IMethod overriding, IMethod overridden) throws JavaModelException {
        ITypeParameter[] overridingTypeParameters;
        int nOverridingTypeParameters;
        ITypeParameter[] overriddenTypeParameters = overridden.getTypeParameters();
        if (overriddenTypeParameters.length != (nOverridingTypeParameters = (overridingTypeParameters = overriding.getTypeParameters()).length)) {
            return nOverridingTypeParameters == 0;
        }
        Substitutions overriddenSubst = this.getMethodSubstitions(overridden);
        Substitutions overridingSubst = this.getMethodSubstitions(overriding);
        int i = 0;
        while (i < nOverridingTypeParameters) {
            String erasure1 = overriddenSubst.getErasure(overriddenTypeParameters[i].getElementName());
            String erasure2 = overridingSubst.getErasure(overridingTypeParameters[i].getElementName());
            if (erasure1 == null || !erasure1.equals(erasure2)) {
                return false;
            }
            int nBounds = overriddenTypeParameters[i].getBounds().length;
            if (nBounds > 1 && nBounds != overridingTypeParameters[i].getBounds().length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasCompatibleParameterTypes(IMethod overriding, IMethod overridden) throws JavaModelException {
        String overridingParamName;
        String overriddenParamName;
        String overriddenParamSig;
        String[] overriddenParamTypes = overridden.getParameterTypes();
        String[] overridingParamTypes = overriding.getParameterTypes();
        String[] substitutedOverriding = new String[overridingParamTypes.length];
        boolean testErasure = false;
        int i = 0;
        while (i < overridingParamTypes.length) {
            overriddenParamSig = overriddenParamTypes[i];
            overriddenParamName = this.getSubstitutedTypeName(overriddenParamSig, overridden);
            substitutedOverriding[i] = overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], overriding);
            if (!overriddenParamName.equals(overridingParamName)) {
                testErasure = true;
                break;
            }
            ++i;
        }
        if (testErasure) {
            i = 0;
            while (i < overridingParamTypes.length) {
                overriddenParamSig = overriddenParamTypes[i];
                overriddenParamName = this.getErasedTypeName(overriddenParamSig, overridden);
                overridingParamName = substitutedOverriding[i];
                if (overridingParamName == null) {
                    overridingParamName = this.getSubstitutedTypeName(overridingParamTypes[i], overriding);
                }
                if (!overriddenParamName.equals(overridingParamName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getVariableSubstitution(IMember context, String variableName) throws JavaModelException {
        IType type;
        String subst;
        if (context instanceof IMethod) {
            subst = this.getMethodSubstitions((IMethod)context).getSubstitution(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getSubstitution(variableName);
        if (subst != null) {
            return subst;
        }
        return variableName;
    }

    private String getVariableErasure(IMember context, String variableName) throws JavaModelException {
        IType type;
        String subst;
        if (context instanceof IMethod) {
            subst = this.getMethodSubstitions((IMethod)context).getErasure(variableName);
            if (subst != null) {
                return subst;
            }
            type = context.getDeclaringType();
        } else {
            type = (IType)context;
        }
        subst = this.getTypeSubstitions(type).getErasure(variableName);
        if (subst != null) {
            return subst;
        }
        return variableName;
    }

    private Substitutions getMethodSubstitions(IMethod method) throws JavaModelException {
        Substitutions s;
        if (this.fMethodSubstitutions == null) {
            this.fMethodSubstitutions = new LRUMap<IMethod, Substitutions>(3);
        }
        if ((s = this.fMethodSubstitutions.get(method)) == null) {
            ITypeParameter[] typeParameters = method.getTypeParameters();
            if (typeParameters.length == 0) {
                s = Substitutions.EMPTY_SUBST;
            } else {
                IType instantiatedType = method.getDeclaringType();
                s = new Substitutions();
                int i = 0;
                while (i < typeParameters.length) {
                    ITypeParameter curr = typeParameters[i];
                    s.addSubstitution(curr.getElementName(), String.valueOf('+') + String.valueOf(i), this.getTypeParameterErasure(curr, instantiatedType));
                    ++i;
                }
            }
            this.fMethodSubstitutions.put(method, s);
        }
        return s;
    }

    private Substitutions getTypeSubstitions(IType type) throws JavaModelException {
        Substitutions subst;
        if (this.fTypeVariableSubstitutions == null) {
            this.fTypeVariableSubstitutions = new HashMap<IType, Substitutions>();
            this.computeSubstitutions(this.fFocusType, null, null);
        }
        if ((subst = this.fTypeVariableSubstitutions.get(type)) == null) {
            return Substitutions.EMPTY_SUBST;
        }
        return subst;
    }

    private void computeSubstitutions(IType instantiatedType, IType instantiatingType, String[] typeArguments) throws JavaModelException {
        IType[] superInterfaces;
        String[] superInterfacesTypeSignature;
        int nInterfaces;
        ITypeParameter curr;
        int i;
        Substitutions s = new Substitutions();
        this.fTypeVariableSubstitutions.put(instantiatedType, s);
        ITypeParameter[] typeParameters = instantiatedType.getTypeParameters();
        if (instantiatingType == null) {
            i = 0;
            while (i < typeParameters.length) {
                curr = typeParameters[i];
                s.addSubstitution(curr.getElementName(), String.valueOf('*') + curr.getElementName(), this.getTypeParameterErasure(curr, instantiatedType));
                ++i;
            }
        } else if (typeParameters.length == typeArguments.length) {
            i = 0;
            while (i < typeParameters.length) {
                curr = typeParameters[i];
                String substString = this.getSubstitutedTypeName(typeArguments[i], instantiatingType);
                String erasure = this.getErasedTypeName(typeArguments[i], instantiatingType);
                s.addSubstitution(curr.getElementName(), substString, erasure);
                ++i;
            }
        } else if (typeArguments.length == 0) {
            i = 0;
            while (i < typeParameters.length) {
                curr = typeParameters[i];
                String erasure = this.getTypeParameterErasure(curr, instantiatedType);
                s.addSubstitution(curr.getElementName(), erasure, erasure);
                ++i;
            }
        }
        String superclassTypeSignature = instantiatedType.getSuperclassTypeSignature();
        if (superclassTypeSignature != null) {
            String[] superTypeArguments = Signature.getTypeArguments(superclassTypeSignature);
            IType superclass = this.fHierarchy.getSuperclass(instantiatedType);
            if (superclass != null && !this.fTypeVariableSubstitutions.containsKey(superclass)) {
                this.computeSubstitutions(superclass, instantiatedType, superTypeArguments);
            }
        }
        if ((nInterfaces = (superInterfacesTypeSignature = instantiatedType.getSuperInterfaceTypeSignatures()).length) > 0 && (superInterfaces = this.fHierarchy.getSuperInterfaces(instantiatedType)).length == nInterfaces) {
            int i2 = 0;
            while (i2 < nInterfaces) {
                String[] superTypeArguments = Signature.getTypeArguments(superInterfacesTypeSignature[i2]);
                IType superInterface = superInterfaces[i2];
                if (!this.fTypeVariableSubstitutions.containsKey(superInterface)) {
                    this.computeSubstitutions(superInterface, instantiatedType, superTypeArguments);
                }
                ++i2;
            }
        }
    }

    private String getTypeParameterErasure(ITypeParameter typeParameter, IType context) throws JavaModelException {
        String[] bounds = typeParameter.getBounds();
        if (bounds.length > 0) {
            return this.getSubstitutedTypeName(Signature.createTypeSignature(bounds[0], false), context);
        }
        return "Object";
    }

    private String getSubstitutedTypeName(String typeSig, IMember context) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, false, new StringBuffer()).toString();
    }

    private String getErasedTypeName(String typeSig, IMember context) throws JavaModelException {
        return this.internalGetSubstitutedTypeName(typeSig, context, true, new StringBuffer()).toString();
    }

    private StringBuffer internalGetSubstitutedTypeName(String typeSig, IMember context, boolean erasure, StringBuffer buf) throws JavaModelException {
        int sigKind = Signature.getTypeSignatureKind(typeSig);
        switch (sigKind) {
            case 2: {
                return buf.append(Signature.toString(typeSig));
            }
            case 4: {
                this.internalGetSubstitutedTypeName(Signature.getElementType(typeSig), context, erasure, buf);
                int i = Signature.getArrayCount(typeSig);
                while (i > 0) {
                    buf.append('[').append(']');
                    --i;
                }
                return buf;
            }
            case 1: {
                String[] typeArguments;
                String erasureSig = Signature.getTypeErasure(typeSig);
                String erasureName = Signature.getSimpleName(Signature.toString(erasureSig));
                char ch = erasureSig.charAt(0);
                if (ch == 'L') {
                    buf.append(erasureName);
                } else if (ch == 'Q') {
                    if (erasure) {
                        buf.append(this.getVariableErasure(context, erasureName));
                    } else {
                        buf.append(this.getVariableSubstitution(context, erasureName));
                    }
                } else {
                    Assert.isTrue(false, "Unknown class type signature");
                }
                if (!erasure && (typeArguments = Signature.getTypeArguments(typeSig)).length > 0) {
                    buf.append('<');
                    int i = 0;
                    while (i < typeArguments.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        this.internalGetSubstitutedTypeName(typeArguments[i], context, erasure, buf);
                        ++i;
                    }
                    buf.append('>');
                }
                return buf;
            }
            case 3: {
                String varName = Signature.toString(typeSig);
                if (erasure) {
                    return buf.append(this.getVariableErasure(context, varName));
                }
                return buf.append(this.getVariableSubstitution(context, varName));
            }
            case 5: {
                buf.append('?');
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    return buf;
                }
                if (ch == '+') {
                    buf.append(" extends ");
                } else {
                    buf.append(" super ");
                }
                return this.internalGetSubstitutedTypeName(typeSig.substring(1), context, erasure, buf);
            }
            case 6: {
                return this.internalGetSubstitutedTypeName(typeSig.substring(1), context, erasure, buf);
            }
        }
        Assert.isTrue(false, "Unhandled type signature kind");
        return buf;
    }

    private static class Substitutions {
        public static final Substitutions EMPTY_SUBST = new Substitutions();
        private HashMap<String, String[]> fMap = null;

        public void addSubstitution(String typeVariable, String substitution, String erasure) {
            if (this.fMap == null) {
                this.fMap = new HashMap(3);
            }
            this.fMap.put(typeVariable, new String[]{substitution, erasure});
        }

        private String[] getSubstArray(String typeVariable) {
            if (this.fMap != null) {
                return this.fMap.get(typeVariable);
            }
            return null;
        }

        public String getSubstitution(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[0];
            }
            return null;
        }

        public String getErasure(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[1];
            }
            return null;
        }
    }
}

