/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Comparator;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsSourcePositionComparator
implements Comparator<IMethodBinding> {
    private final ITypeBinding fTypeBinding;

    public MethodsSourcePositionComparator(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new IllegalArgumentException();
        }
        this.fTypeBinding = typeBinding;
    }

    @Override
    public int compare(IMethodBinding firstMethodBinding, IMethodBinding secondMethodBinding) {
        ITypeBinding secondMethodType;
        if (firstMethodBinding == null || secondMethodBinding == null) {
            return 0;
        }
        ITypeBinding firstMethodType = firstMethodBinding.getDeclaringClass();
        if (firstMethodType.equals(secondMethodType = secondMethodBinding.getDeclaringClass())) {
            return this.compareInTheSameType(firstMethodBinding, secondMethodBinding);
        }
        if (firstMethodType.equals(this.fTypeBinding)) {
            return 1;
        }
        if (secondMethodType.equals(this.fTypeBinding)) {
            return -1;
        }
        ITypeBinding type = this.fTypeBinding;
        int count = 0;
        int firstCount = -1;
        int secondCount = -1;
        while ((type = type.getSuperclass()) != null) {
            if (firstMethodType.equals(type)) {
                firstCount = count;
            }
            if (secondMethodType.equals(type)) {
                secondCount = count;
            }
            ++count;
        }
        if (firstCount != -1 && secondCount != -1) {
            return firstCount - secondCount;
        }
        if (firstCount != -1 && secondCount == -1) {
            return 1;
        }
        if (firstCount == -1 && secondCount != -1) {
            return -1;
        }
        ITypeBinding[] interfaces = this.fTypeBinding.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (firstMethodType.equals(interfaces[i])) {
                return 1;
            }
            if (secondMethodType.equals(interfaces[i])) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int compareInTheSameType(IMethodBinding firstMethodBinding, IMethodBinding secondMethodBinding) {
        IMethod secondMethod;
        IMethod firstMethod;
        block4: {
            try {
                firstMethod = (IMethod)firstMethodBinding.getJavaElement();
                secondMethod = (IMethod)secondMethodBinding.getJavaElement();
                if (firstMethod != null && secondMethod != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        ISourceRange firstSourceRange = firstMethod.getSourceRange();
        ISourceRange secondSourceRange = secondMethod.getSourceRange();
        if (!SourceRange.isAvailable(firstSourceRange) || !SourceRange.isAvailable(secondSourceRange)) {
            return firstMethod.getElementName().compareTo(secondMethod.getElementName());
        }
        return firstSourceRange.getOffset() - secondSourceRange.getOffset();
    }
}

