/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class JarEntryEditorInputFactory
implements IElementFactory {
    public static final String FACTORY_ID = "org.eclipse.jdt.ui.internal.JarEntryEditorInputFactory";
    private static final String KEY_ELEMENT = "element";
    private static final String KEY_PATH = "path";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAdaptable createElement(IMemento memento) {
        String rootIdentifier = memento.getString(KEY_ELEMENT);
        String pathIdentifier = memento.getString(KEY_PATH);
        if (rootIdentifier != null && pathIdentifier != null) {
            IJavaElement restoredParent = JavaCore.create(rootIdentifier);
            try {
                Object[] children;
                if (restoredParent instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot restoredRoot = (IPackageFragmentRoot)restoredParent;
                    if (!restoredParent.exists() && (restoredRoot = this.fuzzyResolveRoot(restoredRoot)) == null) {
                        return null;
                    }
                    children = restoredRoot.getNonJavaResources();
                } else {
                    if (!(restoredParent instanceof IPackageFragment)) {
                        return null;
                    }
                    IPackageFragment restoredPackage = (IPackageFragment)restoredParent;
                    if (!restoredPackage.exists()) {
                        IPackageFragmentRoot restoredRoot = (IPackageFragmentRoot)restoredPackage.getParent();
                        if ((restoredRoot = this.fuzzyResolveRoot(restoredRoot)) == null) {
                            return null;
                        }
                        if (!(restoredPackage = restoredRoot.getPackageFragment(restoredPackage.getElementName())).exists()) {
                            return null;
                        }
                    }
                    children = restoredPackage.getNonJavaResources();
                }
                String[] pathSegments = new Path(pathIdentifier).segments();
                return this.createEditorInput(pathSegments, children);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    private IPackageFragmentRoot fuzzyResolveRoot(IPackageFragmentRoot restoredRoot) throws JavaModelException {
        IJavaProject project = restoredRoot.getJavaProject();
        String rootName = restoredRoot.getElementName();
        int versionSepIndex = rootName.indexOf(95);
        if (versionSepIndex > 0) {
            String prefix = rootName.substring(0, versionSepIndex);
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getElementName().startsWith(prefix)) {
                    return roots[i];
                }
                ++i;
            }
        }
        return null;
    }

    private JarEntryEditorInput createEditorInput(String[] pathSegments, Object[] children) {
        int depth = pathSegments.length;
        int i = 0;
        while (i < depth) {
            IJarEntryResource jarEntryResource;
            block5: {
                String name = pathSegments[i];
                int j = 0;
                while (j < children.length) {
                    Object child = children[j];
                    if (child instanceof IJarEntryResource && name.equals((jarEntryResource = (IJarEntryResource)child).getName())) {
                        boolean isFile = jarEntryResource.isFile();
                        if (isFile) {
                            if (i == depth - 1) {
                                return new JarEntryEditorInput(jarEntryResource);
                            }
                            return null;
                        }
                        break block5;
                    }
                    ++j;
                }
                return null;
            }
            children = jarEntryResource.getChildren();
            ++i;
        }
        return null;
    }

    public static void saveState(IMemento memento, IJarEntryResource jarEntryResource) {
        ArrayList<String> reversePath = new ArrayList<String>();
        reversePath.add(jarEntryResource.getName());
        Object parent = jarEntryResource.getParent();
        while (parent instanceof IJarEntryResource) {
            jarEntryResource = (IJarEntryResource)parent;
            reversePath.add(jarEntryResource.getName());
            parent = jarEntryResource.getParent();
        }
        if (parent instanceof IPackageFragmentRoot || parent instanceof IPackageFragment) {
            memento.putString(KEY_ELEMENT, ((IJavaElement)parent).getHandleIdentifier());
            IPath path = new Path((String)reversePath.get(reversePath.size() - 1));
            int i = reversePath.size() - 2;
            while (i >= 0) {
                path = path.append((String)reversePath.get(i));
                --i;
            }
            memento.putString(KEY_PATH, path.toString());
        }
    }
}

