/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.actions.BlockCommentAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddBlockCommentAction
extends BlockCommentAction {
    public AddBlockCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    protected void runInternal(ITextSelection selection, IDocumentExtension3 docExtension, BlockCommentAction.Edit.EditFactory factory) throws BadLocationException, BadPartitioningException {
        int selectionOffset = selection.getOffset();
        int selectionEndOffset = selectionOffset + selection.getLength();
        LinkedList<BlockCommentAction.Edit> edits = new LinkedList<BlockCommentAction.Edit>();
        ITypedRegion partition = docExtension.getPartition("___java_partitioning", selectionOffset, false);
        this.handleFirstPartition(partition, edits, factory, selectionOffset);
        while (partition.getOffset() + partition.getLength() < selectionEndOffset) {
            partition = this.handleInteriorPartition(partition, edits, factory, docExtension);
        }
        this.handleLastPartition(partition, edits, factory, selectionEndOffset);
        this.executeEdits(edits);
    }

    private void handleFirstPartition(ITypedRegion partition, List<BlockCommentAction.Edit> edits, BlockCommentAction.Edit.EditFactory factory, int offset) throws BadLocationException {
        int partOffset = partition.getOffset();
        String partType = partition.getType();
        Assert.isTrue(partOffset <= offset, "illegal partition");
        if (partType == "__dftl_partition_content_type") {
            edits.add(factory.createEdit(offset, 0, this.getCommentStart()));
        } else if (this.isSpecialPartition(partType)) {
            edits.add(factory.createEdit(partOffset, 0, this.getCommentStart()));
        }
    }

    private ITypedRegion handleInteriorPartition(ITypedRegion partition, List<BlockCommentAction.Edit> edits, BlockCommentAction.Edit.EditFactory factory, IDocumentExtension3 docExtension) throws BadPartitioningException, BadLocationException {
        String partType = partition.getType();
        int partEndOffset = partition.getOffset() + partition.getLength();
        int tokenLength = this.getCommentStart().length();
        boolean wasJavadoc = false;
        if (partType == "__java_javadoc") {
            wasJavadoc = true;
        } else if (partType == "__java_multiline_comment") {
            edits.add(factory.createEdit(partEndOffset - tokenLength, tokenLength, ""));
        }
        partition = docExtension.getPartition("___java_partitioning", partEndOffset, false);
        partType = partition.getType();
        if (wasJavadoc) {
            if (partType == "__dftl_partition_content_type" || this.isSpecialPartition(partType)) {
                edits.add(factory.createEdit(partition.getOffset(), 0, this.getCommentStart()));
            }
        } else if (partType == "__java_javadoc") {
            edits.add(factory.createEdit(partition.getOffset(), 0, this.getCommentEnd()));
        } else if (partType == "__java_multiline_comment") {
            edits.add(factory.createEdit(partition.getOffset(), this.getCommentStart().length(), ""));
        }
        return partition;
    }

    private void handleLastPartition(ITypedRegion partition, List<BlockCommentAction.Edit> edits, BlockCommentAction.Edit.EditFactory factory, int endOffset) throws BadLocationException {
        String partType = partition.getType();
        if (partType == "__dftl_partition_content_type") {
            edits.add(factory.createEdit(endOffset, 0, this.getCommentEnd()));
        } else if (this.isSpecialPartition(partType)) {
            edits.add(factory.createEdit(partition.getOffset() + partition.getLength(), 0, this.getCommentEnd()));
        }
    }

    private boolean isSpecialPartition(String partType) {
        return partType == "__java_character" || partType == "__java_string" || partType == "__java_singleline_comment";
    }

    @Override
    protected boolean isValidSelection(ITextSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getLength() > 0;
    }
}

