/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.TextEditorAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockCommentAction
extends TextEditorAction {
    public BlockCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null || !this.ensureEditable(editor)) {
            return;
        }
        ITextSelection selection = this.getCurrentSelection();
        if (!this.isValidSelection(selection)) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        if (docProvider == null || input == null) {
            return;
        }
        IDocument document = docProvider.getDocument((Object)input);
        if (document == null) {
            return;
        }
        if (!(document instanceof IDocumentExtension3)) {
            return;
        }
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        Edit.EditFactory factory = new Edit.EditFactory(document);
        try {
            try {
                this.runInternal(selection, docExtension, factory);
                return;
            }
            catch (BadLocationException badLocationException) {
                factory.release();
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
            catch (BadPartitioningException badPartitioningException) {
                Assert.isTrue(false, "bad partitioning");
                factory.release();
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
        }
        finally {
            factory.release();
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    protected void executeEdits(List<Edit> edits) throws BadLocationException {
        for (Edit edit : edits) {
            edit.perform();
        }
    }

    protected boolean ensureEditable(ITextEditor editor) {
        Assert.isNotNull(editor);
        if (editor instanceof ITextEditorExtension2) {
            ITextEditorExtension2 ext = (ITextEditorExtension2)editor;
            return ext.validateEditorInputState();
        }
        return editor.isEditable();
    }

    public void update() {
        super.update();
        if (!(!this.isEnabled() || this.canModifyEditor() && this.isValidSelection(this.getCurrentSelection()))) {
            this.setEnabled(false);
        }
    }

    protected ITextSelection getCurrentSelection() {
        ISelection selection;
        ISelectionProvider provider;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (provider = editor.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected abstract void runInternal(ITextSelection var1, IDocumentExtension3 var2, Edit.EditFactory var3) throws BadLocationException, BadPartitioningException;

    protected abstract boolean isValidSelection(ITextSelection var1);

    protected String getCommentStart() {
        return "/*";
    }

    protected String getCommentEnd() {
        return "*/";
    }

    static class Edit
    extends DocumentEvent {
        private Position fPosition;

        protected Edit(IDocument document, int length, String text, Position position) {
            super(document, 0, length, text);
            this.fPosition = position;
        }

        public int getOffset() {
            return this.fPosition.getOffset();
        }

        public void perform() throws BadLocationException {
            this.getDocument().replace(this.getOffset(), this.getLength(), this.getText());
        }

        public static class EditFactory {
            private static final String CATEGORY = "__positionalEditPositionCategory";
            private static int fgCount = 0;
            private final String fCategory = "__positionalEditPositionCategory" + fgCount++;
            private IDocument fDocument;
            private IPositionUpdater fUpdater;

            public EditFactory(IDocument document) {
                this.fDocument = document;
            }

            public Edit createEdit(int offset, int length, String text) throws BadLocationException {
                if (!this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.addPositionCategory(this.fCategory);
                    this.fUpdater = new DefaultPositionUpdater(this.fCategory);
                    this.fDocument.addPositionUpdater(this.fUpdater);
                }
                Position position = new Position(offset);
                try {
                    this.fDocument.addPosition(this.fCategory, position);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    Assert.isTrue(false);
                }
                return new Edit(this.fDocument, length, text, position);
            }

            public void release() {
                if (this.fDocument != null && this.fDocument.containsPositionCategory(this.fCategory)) {
                    this.fDocument.removePositionUpdater(this.fUpdater);
                    try {
                        this.fDocument.removePositionCategory(this.fCategory);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                        Assert.isTrue(false);
                    }
                    this.fDocument = null;
                    this.fUpdater = null;
                }
            }
        }
    }
}

