/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    public OpenTypeAction() {
        this.setText(JavaUIMessages.OpenTypeAction_label);
        this.setDescription(JavaUIMessages.OpenTypeAction_description);
        this.setToolTipText(JavaUIMessages.OpenTypeAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_TOOL_OPENTYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_type_action");
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event e) {
        Shell parent = JavaPlugin.getActiveWorkbenchShell();
        if (!this.doCreateProjectFirstOnEmptyWorkspace(parent)) {
            return;
        }
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0);
        dialog.setTitle(JavaUIMessages.OpenTypeAction_dialogTitle);
        dialog.setMessage(JavaUIMessages.OpenTypeAction_dialogMessage);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return;
        }
        if (types.length == 1) {
            try {
                JavaUI.openInEditor((IJavaElement)types[0], true, true);
            }
            catch (CoreException x) {
                ExceptionHandler.handle(x, JavaUIMessages.OpenTypeAction_errorTitle, JavaUIMessages.OpenTypeAction_errorMessage);
            }
            return;
        }
        IWorkbenchPage workbenchPage = JavaPlugin.getActivePage();
        if (workbenchPage == null) {
            Status status = new Status(4, JavaPlugin.getPluginId(), JavaUIMessages.OpenTypeAction_no_active_WorkbenchPage);
            ExceptionHandler.handle(status, JavaUIMessages.OpenTypeAction_errorTitle, JavaUIMessages.OpenTypeAction_errorMessage);
            return;
        }
        MultiStatus multiStatus = new MultiStatus(JavaPlugin.getPluginId(), 10001, JavaUIMessages.OpenTypeAction_multiStatusMessage, null);
        int i = 0;
        while (i < types.length) {
            IType type = (IType)types[i];
            try {
                JavaUI.openInEditor(type, true, true);
            }
            catch (CoreException x) {
                multiStatus.merge(x.getStatus());
            }
            ++i;
        }
        if (!multiStatus.isOK()) {
            ExceptionHandler.handle(multiStatus, JavaUIMessages.OpenTypeAction_errorTitle, JavaUIMessages.OpenTypeAction_errorMessage);
        }
    }

    protected boolean doCreateProjectFirstOnEmptyWorkspace(Shell parent) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (workspaceRoot.getProjects().length == 0) {
            String title = JavaUIMessages.OpenTypeAction_dialogTitle;
            String message = JavaUIMessages.OpenTypeAction_createProjectFirst;
            if (MessageDialog.openQuestion((Shell)parent, (String)title, (String)message)) {
                new NewProjectAction().run();
                return workspaceRoot.getProjects().length != 0;
            }
            return false;
        }
        return true;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void init(IAction action) {
    }
}

