/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class LogicalPackage
extends PlatformObject {
    private Set<IPackageFragment> fPackages;
    private String fName;
    private IJavaProject fJavaProject;

    public LogicalPackage(IPackageFragment fragment) {
        Assert.isNotNull(fragment);
        this.fPackages = new HashSet<IPackageFragment>();
        this.fJavaProject = fragment.getJavaProject();
        Assert.isNotNull(this.fJavaProject);
        this.add(fragment);
        this.fName = fragment.getElementName();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public IPackageFragment[] getFragments() {
        return this.fPackages.toArray(new IPackageFragment[this.fPackages.size()]);
    }

    public void add(IPackageFragment fragment) {
        Assert.isTrue(fragment != null && this.fJavaProject.equals(fragment.getJavaProject()));
        this.fPackages.add(fragment);
    }

    public void remove(IPackageFragment fragment) {
        this.fPackages.remove(fragment);
    }

    public boolean contains(IPackageFragment fragment) {
        return this.fPackages.contains(fragment);
    }

    public String getElementName() {
        return this.fName;
    }

    public int size() {
        return this.fPackages.size();
    }

    public boolean belongs(IPackageFragment fragment) {
        if (fragment == null) {
            return false;
        }
        if (this.fJavaProject.equals(fragment.getJavaProject())) {
            return this.fName.equals(fragment.getElementName());
        }
        return false;
    }

    public boolean hasSubpackages() throws JavaModelException {
        for (IPackageFragment pack : this.fPackages) {
            if (!pack.hasSubpackages()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.fName.length() == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogicalPackage)) {
            return false;
        }
        LogicalPackage lp = (LogicalPackage)o;
        if (!this.fJavaProject.equals(lp.getJavaProject())) {
            return false;
        }
        IPackageFragment[] fragments = lp.getFragments();
        if (fragments.length != this.getFragments().length) {
            return false;
        }
        int i = 0;
        while (i < fragments.length) {
            IPackageFragment fragment = fragments[i];
            if (!this.fPackages.contains(fragment)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        IPackageFragment[] fragments = this.getFragments();
        return this.fJavaProject.hashCode() + this.getHash(fragments, fragments.length - 1);
    }

    private int getHash(IPackageFragment[] fragments, int index) {
        if (index <= 0) {
            return fragments[0].hashCode() * 17;
        }
        return fragments[index].hashCode() * 17 + this.getHash(fragments, index - 1);
    }
}

