/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.ProjectAndSourceFolderContentProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInTargetList;

public class ProjectsView
extends JavaBrowsingPart {
    private FilterUpdater fFilterUpdater;
    private CollapseAllAction fCollapseAllAction;

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer result = new ProblemTreeViewer(parent, 2);
        this.fFilterUpdater = new FilterUpdater(result);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fFilterUpdater);
        return result;
    }

    public void dispose() {
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fFilterUpdater);
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected IContentProvider createContentProvider() {
        return new ProjectAndSourceFolderContentProvider(this);
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.projects_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.jdt.ui.browsing.projectstoeditor";
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)ProjectsView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    protected void setInitialInput() {
        IJavaModel root = JavaCore.create(JavaPlugin.getWorkspace().getRoot());
        this.getViewer().setInput((Object)root);
        this.updateTitle();
    }

    protected boolean isValidInput(Object element) {
        return element instanceof IJavaModel;
    }

    protected boolean isValidElement(Object element) {
        return element instanceof IJavaProject || element instanceof IPackageFragmentRoot;
    }

    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 1: {
                return null;
            }
            case 2: {
                return je;
            }
            case 3: {
                if (je.getElementName().equals("")) {
                    return je.getParent();
                }
                return je;
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    protected void setInput(Object input) {
        if (input != null) {
            super.setInput(input);
        } else {
            this.getViewer().setSelection(null);
        }
    }

    protected void createActions() {
        super.createActions();
        this.fActionGroups.addGroup(new ProjectActionGroup((IViewPart)this));
        this.fCollapseAllAction = new CollapseAllAction((TreeViewer)this.getViewer());
        this.fCollapseAllAction.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
    }

    protected void activateHandlers(IHandlerService handlerService) {
        super.activateHandlers(handlerService);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler((IAction)this.fCollapseAllAction));
    }

    protected void fillToolBar(IToolBarManager tbm) {
        super.fillToolBar(tbm);
        tbm.add((IAction)this.fCollapseAllAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object selectedElement : sel) {
                if (!(selectedElement instanceof LogicalPackage)) continue;
                selection = new StructuredSelection((Object)((LogicalPackage)selectedElement).getJavaProject());
                break;
            }
        }
        super.selectionChanged(part, selection);
    }
}

