/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.actions.SelectAllAction;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.eclipse.jdt.internal.ui.filters.NonJavaElementFilter;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTargetList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesView
extends JavaBrowsingPart {
    private SelectAllAction fSelectAllAction;

    @Override
    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(2288083699499049L, 1);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonJavaElementFilter());
    }

    @Override
    protected boolean isValidInput(Object element) {
        return element instanceof IPackageFragment;
    }

    @Override
    protected boolean isValidElement(Object element) {
        if (element instanceof ICompilationUnit) {
            return super.isValidElement(((ICompilationUnit)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null && this.isValidElement(type.getCompilationUnit());
        }
        return false;
    }

    @Override
    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return type;
            }
            case 5: {
                return this.getTypeForCU((ICompilationUnit)je);
            }
            case 6: {
                return this.findElementToSelect(((IClassFile)je).getType());
            }
            case 11: 
            case 12: 
            case 13: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect(((IMember)je).getDeclaringType());
        }
        return null;
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.types_view_context";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.jdt.ui.browsing.typestoeditor";
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object selectedElement = sel.getFirstElement();
            if (sel.size() == 1 && selectedElement instanceof LogicalPackage) {
                IPackageFragment[] fragments = ((LogicalPackage)selectedElement).getFragments();
                List<IPackageFragment> selectedElements = Arrays.asList(fragments);
                if (selectedElements.size() > 1) {
                    this.adjustInput(selectedElements);
                    this.fPreviousSelectedElement = selectedElements;
                    this.fPreviousSelectionProvider = part;
                } else if (selectedElements.size() == 1) {
                    super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
                } else {
                    Assert.isLegal(false);
                }
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(List<IPackageFragment> selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }

    @Override
    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider provider) {
        DecoratingJavaLabelProvider decoratingLabelProvider = super.createDecoratingLabelProvider(provider);
        provider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return decoratingLabelProvider;
    }
}

