/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyImageDescriptor;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CallHierarchyLabelDecorator
implements ILabelDecorator {
    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new CallHierarchyImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    private int computeAdornmentFlags(Object element) {
        int flags = 0;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)element;
            if (methodWrapper.isRecursive()) {
                flags = 1;
            }
            if (this.isMaxCallDepthExceeded(methodWrapper)) {
                flags |= 2;
            }
        }
        return flags;
    }

    private boolean isMaxCallDepthExceeded(MethodWrapper methodWrapper) {
        return methodWrapper.getLevel() > CallHierarchyUI.getDefault().getMaxCallDepth();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

