/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

class FocusOnSelectionAction
extends Action {
    private CallHierarchyViewPart fPart;

    public FocusOnSelectionAction(CallHierarchyViewPart part) {
        super(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_text);
        this.fPart = part;
        this.setDescription(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_description);
        this.setToolTipText(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_focus_on_selection_action_context");
    }

    public boolean canActionBeAdded() {
        IMember[] members = this.getSelectedInputElements();
        if (members != null) {
            if (members.length == 1) {
                this.setText(Messages.format(CallHierarchyMessages.FocusOnSelectionAction_focusOn_text, BasicElementLabels.getJavaElementName(members[0].getElementName())));
            } else {
                this.setText(CallHierarchyMessages.FocusOnSelectionAction_focusOn_selected);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IMember[] getSelectedInputElements() {
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) return null;
        Object[] elements = ((IStructuredSelection)selection).toArray();
        IMember[] members = new IMember[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (CallHierarchy.isPossibleInputElement(element)) {
                members[i] = (IMember)element;
            } else {
                if (!(element instanceof MethodWrapper)) return null;
                IMember wrapped = ((MethodWrapper)element).getMember();
                if (!CallHierarchy.isPossibleInputElement(wrapped)) return null;
                members[i] = wrapped;
            }
            ++i;
        }
        if (members.length <= 0) return null;
        return members;
    }

    public void run() {
        IMember[] members = this.getSelectedInputElements();
        if (members != null) {
            this.fPart.setInputElements(members);
        }
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }
}

