/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_open_action_context");
    }

    public OpenCallHierarchyAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(CallHierarchy.arePossibleInputElements(selection.toList()));
    }

    public void run(ITextSelection selection) {
        ITypeRoot input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IJavaElement enclosingMethod;
            IJavaElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IJavaElement> candidates = new ArrayList<IJavaElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                if (CallHierarchy.isPossibleInputElement(element)) {
                    candidates.add(element);
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod(input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            CallHierarchyUI.openSelectionDialog(candidates.toArray(new IMember[candidates.size()]), this.getSite().getWorkbenchWindow());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CallHierarchyMessages.OpenCallHierarchyAction_dialog_title, ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IJavaElement getEnclosingMethod(ITypeRoot input, ITextSelection selection) {
        try {
            IJavaElement enclosingElement = input.getElementAt(selection.getOffset());
            if (enclosingElement instanceof IMethod || enclosingElement instanceof IInitializer || enclosingElement instanceof IField) {
                return enclosingElement;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        List elements = selection.toList();
        if (!CallHierarchy.arePossibleInputElements(elements)) {
            elements = Collections.EMPTY_LIST;
        }
        IJavaElement[] members = elements.toArray(new IMember[elements.size()]);
        if (!ActionUtil.areProcessable(this.getShell(), members)) {
            return;
        }
        CallHierarchyUI.openView((IMember[])members, this.getSite().getWorkbenchWindow());
    }
}

