/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionDelegate;

public abstract class JavaHistoryAction
extends Action
implements IActionDelegate {
    private JavaHistoryActionImpl fDelegate;
    private JavaEditor fEditor;
    private String fTitle;
    private String fMessage;

    JavaHistoryAction() {
    }

    private JavaHistoryActionImpl getDelegate() {
        if (this.fDelegate == null) {
            this.fDelegate = this.createDelegate();
            if (this.fEditor != null && this.fTitle != null && this.fMessage != null) {
                this.fDelegate.init(this.fEditor, this.fTitle, this.fMessage);
            }
        }
        return this.fDelegate;
    }

    protected abstract JavaHistoryActionImpl createDelegate();

    final void init(JavaEditor editor, String text, String title, String message) {
        Assert.isNotNull(editor);
        Assert.isNotNull(title);
        Assert.isNotNull(message);
        this.fEditor = editor;
        this.fTitle = title;
        this.fMessage = message;
        this.setText(text);
    }

    public final void run(ISelection selection) {
        this.getDelegate().run(selection);
    }

    public final void run() {
        this.getDelegate().runFromEditor((IAction)this);
    }

    final void update() {
        this.getDelegate().update((IAction)this);
    }

    public final void selectionChanged(IAction uiProxy, ISelection selection) {
        this.getDelegate().selectionChanged(uiProxy, selection);
    }

    public final void run(IAction action) {
        this.getDelegate().run(action);
    }
}

