/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.history.ElementLocalHistoryPageSource;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryPageSource;

class JavaReplaceWithEditionActionImpl
extends JavaHistoryActionImpl {
    protected boolean fPrevious = false;

    JavaReplaceWithEditionActionImpl(boolean previous) {
        super(true);
        this.fPrevious = previous;
    }

    public void run(ISelection selection) {
        Shell shell = this.getShell();
        final IMember input = this.getEditionElement(selection);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)CompareMessages.ReplaceFromHistory_title, (String)CompareMessages.ReplaceFromHistory_invalidSelectionMessage);
            return;
        }
        final IFile file = this.getFile(input);
        if (file == null) {
            this.showError();
            return;
        }
        IStatus status = Resources.makeCommittable(file, (Object)shell);
        if (!status.isOK()) {
            return;
        }
        if (this.fPrevious) {
            String errorTitle = CompareMessages.ReplaceFromHistory_title;
            String errorMessage = CompareMessages.ReplaceFromHistory_internalErrorMessage;
            try {
                ITypedElement ti = ElementLocalHistoryPageSource.getPreviousEdition((IFile)file, (Object)input);
                if (ti == null) {
                    MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)CompareMessages.ReplaceFromHistory_parsingErrorMessage);
                    return;
                }
                this.replace(input, file, ti);
            }
            catch (TeamException e) {
                ExceptionHandler.handle((CoreException)((Object)e), shell, errorTitle, errorMessage);
            }
        } else {
            JavaElementHistoryPageSource pageSource = JavaElementHistoryPageSource.getInstance();
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            HistoryPageCompareEditorInput ci = new HistoryPageCompareEditorInput(cc, (IHistoryPageSource)pageSource, input){

                protected void performReplace(Object selectedElement) {
                    if (selectedElement instanceof ITypedElement) {
                        JavaReplaceWithEditionActionImpl.this.replace(input, file, (ITypedElement)selectedElement);
                    }
                }
            };
            ci.setReplace(true);
            ci.setTitle(CompareMessages.JavaReplaceWithEditionActionImpl_0);
            ci.setHelpContextId("org.eclipse.jdt.ui.replace_element_with_history_dialog_context");
            CompareUI.openCompareDialog((CompareEditorInput)ci);
        }
    }

    /*
     * Loose catch block
     */
    public void replace(IMember input, IFile file, ITypedElement element) {
        Shell shell = this.getShell();
        String errorTitle = CompareMessages.ReplaceFromHistory_title;
        String errorMessage = CompareMessages.ReplaceFromHistory_internalErrorMessage;
        IPath path = file.getFullPath();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = null;
        try {
            try {
                bufferManager.connect(path, LocationKind.IFILE, null);
                textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                IDocument document = textFileBuffer.getDocument();
                this.performReplace(input, file, textFileBuffer, document, element);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                try {
                    if (textFileBuffer != null) {
                        bufferManager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
            catch (InterruptedException interruptedException) {
                Assert.isTrue(false);
                try {
                    if (textFileBuffer != null) {
                        bufferManager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (textFileBuffer != null) {
                        bufferManager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        finally {
            try {
                if (textFileBuffer != null) {
                    bufferManager.disconnect(path, LocationKind.IFILE, null);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private void performReplace(IMember input, IFile file, ITextFileBuffer textFileBuffer, IDocument document, ITypedElement ti) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        if (ti instanceof IStreamContentAccessor) {
            JavaEditor je;
            ASTNode node2;
            ASTNode node;
            int length;
            boolean inEditor = this.beingEdited(file);
            String content = JavaCompareUtilities.readString((IStreamContentAccessor)ti);
            String newContent = JavaReplaceWithEditionActionImpl.trimTextBlock(content, TextUtilities.getDefaultLineDelimiter((IDocument)document), input.getJavaProject());
            if (newContent == null) {
                this.showError();
                return;
            }
            ICompilationUnit compilationUnit = input.getCompilationUnit();
            CompilationUnit root = JavaReplaceWithEditionActionImpl.parsePartialCompilationUnit(compilationUnit);
            ISourceRange nameRange = input.getNameRange();
            if (nameRange == null) {
                nameRange = input.getSourceRange();
            }
            if ((length = nameRange.getLength()) < 0) {
                length = 1;
            }
            if ((node = (node2 = NodeFinder.perform(root, new SourceRange(nameRange.getOffset(), length))).getNodeType() == 28 ? node2 : ASTNodes.getParent(node2, BodyDeclaration.class)) == null) {
                node = ASTNodes.getParent(node2, AnnotationTypeDeclaration.class);
            }
            if (node == null) {
                node = ASTNodes.getParent(node2, EnumDeclaration.class);
            }
            if (node == null) {
                this.showError();
                return;
            }
            ASTRewrite rewriter = ASTRewrite.create(root.getAST());
            rewriter.replace(node, rewriter.createStringPlaceholder(newContent, node.getNodeType()), null);
            if (inEditor && (je = this.getEditor(file)) != null) {
                je.setFocus();
            }
            Map options = null;
            IJavaProject javaProject = compilationUnit.getJavaProject();
            if (javaProject != null) {
                options = javaProject.getOptions(true);
            }
            this.applyChanges(rewriter, document, textFileBuffer, this.getShell(), inEditor, options);
        }
    }

    private void showError() {
        MessageDialog.openError((Shell)this.getShell(), (String)CompareMessages.ReplaceFromHistory_title, (String)CompareMessages.ReplaceFromHistory_internalErrorMessage);
    }
}

