/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaAddElementFromHistory;
import org.eclipse.jdt.internal.ui.compare.JavaCompareWithEditionAction;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.compare.JavaReplaceWithEditionAction;
import org.eclipse.jdt.internal.ui.compare.JavaReplaceWithPreviousEditionAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class LocalHistoryActionGroup
extends ActionGroup {
    private String fGroupName;
    private JavaHistoryAction fCompareWith;
    private JavaHistoryAction fReplaceWithPrevious;
    private JavaHistoryAction fReplaceWith;
    private JavaHistoryAction fAddFrom;

    public LocalHistoryActionGroup(CompilationUnitEditor editor, String groupName) {
        Assert.isNotNull(groupName);
        this.fGroupName = groupName;
        this.fCompareWith = new JavaCompareWithEditionAction();
        this.fCompareWith.init(editor, CompareMessages.LocalHistoryActionGroup_action_compare_with, CompareMessages.LocalHistoryActionGroup_action_compare_with_title, CompareMessages.LocalHistoryActionGroup_action_compare_with_message);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.fCompareWith, "org.eclipse.jdt.ui.compare_with_history_action");
        this.fReplaceWithPrevious = new JavaReplaceWithPreviousEditionAction();
        this.fReplaceWithPrevious.init(editor, CompareMessages.LocalHistoryActionGroup_action_replace_with_previous, CompareMessages.LocalHistoryActionGroup_action_replace_with_previous_title, CompareMessages.LocalHistoryActionGroup_action_replace_with_previous_message);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.fReplaceWithPrevious, "org.eclipse.jdt.ui.replace_with_previous_from_history_action");
        this.fReplaceWith = new JavaReplaceWithEditionAction();
        this.fReplaceWith.init(editor, CompareMessages.LocalHistoryActionGroup_action_replace_with, CompareMessages.LocalHistoryActionGroup_action_replace_with_title, CompareMessages.LocalHistoryActionGroup_action_replace_with_message);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.fReplaceWith, "org.eclipse.jdt.ui.replace_with_history_action");
        this.fAddFrom = new JavaAddElementFromHistory();
        this.fAddFrom.init(editor, CompareMessages.LocalHistoryActionGroup_action_add, CompareMessages.LocalHistoryActionGroup_action_add_title, CompareMessages.LocalHistoryActionGroup_action_add_message);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.fAddFrom, "org.eclipse.jdt.ui.add_from_history_action");
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager localMenu = new MenuManager(CompareMessages.LocalHistoryActionGroup_menu_local_history);
        int added = 0;
        added += this.addAction((IMenuManager)localMenu, this.fCompareWith);
        added += this.addAction((IMenuManager)localMenu, this.fReplaceWithPrevious);
        added += this.addAction((IMenuManager)localMenu, this.fReplaceWith);
        if ((added += this.addAction((IMenuManager)localMenu, this.fAddFrom)) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)localMenu);
        }
    }

    private int addAction(IMenuManager menu, JavaHistoryAction action) {
        action.update();
        if (action.isEnabled()) {
            menu.add((IAction)action);
            return 1;
        }
        return 0;
    }
}

