/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class MainTypeSelectionDialog
extends TwoPaneElementSelector {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fStyle;

    public MainTypeSelectionDialog(Shell shell, IRunnableContext context, IJavaSearchScope scope, int style) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        Assert.isNotNull(context);
        Assert.isNotNull(scope);
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fStyle = style;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.maintype_selection_dialog_context");
    }

    public int open() {
        Object[] types;
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        try {
            types = engine.searchMainMethods(this.fRunnableContext, this.fScope, this.fStyle);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, JavaUIMessages.MainTypeSelectionDialog_errorTitle, e.getMessage());
            return 1;
        }
        this.setElements(types);
        return super.open();
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            return super.getImage(((IType)element).getPackageFragment());
        }

        public String getText(Object element) {
            return super.getText(((IType)element).getPackageFragment());
        }
    }
}

