/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PluginTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class JdtViewerDropSupport {
    private final StructuredViewer fViewer;
    private final DelegatingDropAdapter fDelegatingDropAdapter;
    private final SelectionTransferDropAdapter fReorgDropListener;
    private boolean fStarted;

    public JdtViewerDropSupport(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fDelegatingDropAdapter = new DelegatingDropAdapter();
        this.fReorgDropListener = new SelectionTransferDropAdapter(this.fViewer);
        this.fDelegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)this.fReorgDropListener);
        this.fDelegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new FileTransferDropAdapter(this.fViewer));
        this.fDelegatingDropAdapter.addDropTargetListener((TransferDropTargetListener)new PluginTransferDropAdapter(this.fViewer));
        this.fStarted = false;
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        Assert.isLegal(!this.fStarted);
        this.fDelegatingDropAdapter.addDropTargetListener(listener);
    }

    public void start() {
        Assert.isLegal(!this.fStarted);
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        this.fViewer.addDropSupport(ops, transfers, (DropTargetListener)this.fDelegatingDropAdapter);
        this.fStarted = true;
    }

    public void setFeedbackEnabled(boolean enabled) {
        this.fReorgDropListener.setFeedbackEnabled(enabled);
    }
}

